/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.MenuUpdateAction;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;

public class ApplyStyleAction
extends MenuUpdateAction.DynamicItemAction {
    public static final String ID = "ApplyStyleAction";
    private SharedStyleHandle handle;
    private List selectionHandles;

    public ApplyStyleAction(SharedStyleHandle handle) {
        this.handle = handle;
        this.setId(ID);
        if (handle == null) {
            this.setText(Messages.getString((String)"ApplyStyleAction.actionLabel.none"));
        } else {
            SlotHandle slotHandle = handle.getContainerSlotHandle();
            if (slotHandle != null && slotHandle.getElementHandle() instanceof ThemeHandle) {
                this.setText(((ThemeHandle)handle.getContainerSlotHandle().getElementHandle()).getName() + "." + DEUtil.getEscapedMenuItemText((String)DEUtil.getDisplayLabel((Object)handle, (boolean)false)));
            } else {
                this.setText(DEUtil.getEscapedMenuItemText((String)DEUtil.getDisplayLabel((Object)handle, (boolean)false)));
            }
        }
    }

    public boolean isEnabled() {
        List handles = this.getElementHandles();
        if (handles.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < handles.size()) {
            if (!(handles.get(i) instanceof DesignElementHandle)) {
                return false;
            }
            DesignElementHandle handle = (DesignElementHandle)handles.get(i);
            if (handle != null && !handle.getDefn().hasStyle()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run() {
        if (this.handle != null) {
            CommandUtils.setVariable("ApplyStyleAction.StyleHandleName", this.handle);
        }
        CommandUtils.setVariable("ApplyStyleAction.StyleChecked", this.isChecked());
        try {
            CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.applyStyleCommand", null);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        CommandUtils.removeVariable("ApplyStyleAction.StyleHandleName");
        CommandUtils.removeVariable("ApplyStyleAction.StyleChecked");
    }

    protected List getElementHandles() {
        if (this.selectionHandles == null) {
            this.selectionHandles = DNDUtil.unwrapToModel((List)InsertInLayoutUtil.editPart2Model(TableUtil.filletCellInSelectionEditorpart(this.getSelection())).toList());
        }
        return this.selectionHandles;
    }
}

