/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.DataRequestSessionImpl;
import org.eclipse.birt.report.engine.adapter.ITotalExprBindings;
import org.eclipse.birt.report.engine.adapter.ParseIndicator;
import org.eclipse.birt.report.engine.adapter.ToBeTransformTopBottomConditionalExpression;
import org.eclipse.birt.report.engine.adapter.TotalExprBinding;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.ir.Expression;

public final class ExpressionUtil {
    private static Logger logger = Logger.getLogger(ExpressionUtil.class.getName());
    private static final String TOTAL_PREFIX = "TOTAL_COLUMN_";
    private int totalColumnSuffix = 0;
    private IModelAdapter adapter = null;

    public ITotalExprBindings prepareTotalExpressions(List<Expression> exprs, IDataQueryDefinition queryDefn) throws EngineException {
        return this.prepareTotalExpressions(exprs, null, queryDefn);
    }

    public ITotalExprBindings prepareTotalExpressions(List<Expression> exprs, String groupName, IDataQueryDefinition queryDefn) throws EngineException {
        TotalExprBinding result = new TotalExprBinding();
        ArrayList l = new ArrayList();
        boolean isCube = false;
        if (queryDefn instanceof IBaseCubeQueryDefinition) {
            isCube = true;
        }
        int i = 0;
        while (i < exprs.size()) {
            Expression expr = exprs.get(i);
            result.addColumnBindings(l);
            if (expr == null) {
                result.addNewExpression(null);
            } else {
                switch (expr.getType()) {
                    case 0: {
                        result.addNewExpression(expr);
                        break;
                    }
                    case 1: {
                        String newExpr = this.prepareTotalExpression(expr.getScriptText(), l, groupName, isCube);
                        result.addColumnBindings(l);
                        expr.setScriptText(newExpr);
                        result.addNewExpression(expr);
                        break;
                    }
                    case 2: {
                        this.addConditionalExprBindings(result, (Expression.Conditional)expr, l, groupName, isCube);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("invalid expression type:" + expr.getType());
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static IConditionalExpression transformConditionalExpression(IConditionalExpression ce) {
        boolean needTransform = false;
        switch (ce.getOperator()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                needTransform = true;
                break;
            }
            default: {
                needTransform = false;
            }
        }
        if (needTransform) {
            ce = new ToBeTransformTopBottomConditionalExpression(ce.getExpression(), ce.getOperator(), ce.getOperand1(), ce.getOperand2());
        }
        return ce;
    }

    private void addConditionalExprBindings(TotalExprBinding result, Expression.Conditional key, List bindings, String groupName, boolean isCube) throws EngineException {
        try {
            IConditionalExpression ce = key.getConditionalExpression();
            if (!this.hasAggregationInFilter((IBaseExpression)ce) && !(ce instanceof ToBeTransformTopBottomConditionalExpression)) {
                result.addNewExpression(key);
                return;
            }
            if (groupName != null) {
                ce.setGroupName(groupName);
            }
            String bindingName = TOTAL_PREFIX + this.totalColumnSuffix;
            ++this.totalColumnSuffix;
            if (ce instanceof ToBeTransformTopBottomConditionalExpression) {
                ArrayList<Binding> allColumnBindings = new ArrayList<Binding>();
                allColumnBindings.add(((ToBeTransformTopBottomConditionalExpression)ce).transform(bindingName, groupName));
                result.addColumnBindings(allColumnBindings);
                result.addNewExpression(Expression.newScript(org.eclipse.birt.core.data.ExpressionUtil.createJSRowExpression((String)bindingName)));
                return;
            }
            Binding columnBinding = new Binding(bindingName, (IBaseExpression)ce);
            if (groupName != null) {
                columnBinding.addAggregateOn(groupName);
            }
            ArrayList<Binding> allColumnBindings = new ArrayList<Binding>();
            allColumnBindings.add(columnBinding);
            result.addColumnBindings(allColumnBindings);
            if (!isCube) {
                String script = org.eclipse.birt.core.data.ExpressionUtil.createJSRowExpression((String)bindingName);
                result.addNewExpression(Expression.newScript(script));
            } else {
                String script = org.eclipse.birt.core.data.ExpressionUtil.createJSDataExpression((String)bindingName);
                result.addNewExpression(Expression.newScript(script));
            }
        }
        catch (DataException e) {
            throw new EngineException((BirtException)e);
        }
    }

    private boolean hasAggregationInFilter(IBaseExpression expr) {
        IConditionalExpression ce;
        if (expr == null) {
            return false;
        }
        if (expr instanceof IScriptExpression) {
            return org.eclipse.birt.core.data.ExpressionUtil.hasAggregation((String)((ScriptExpression)expr).getText());
        }
        return expr instanceof IConditionalExpression && (this.hasAggregationInFilter((IBaseExpression)(ce = (IConditionalExpression)expr).getExpression()) || this.hasAggregationInFilter(ce.getOperand1()) || this.hasAggregationInFilter(ce.getOperand2()));
    }

    private String prepareTotalExpression(String oldExpression, List columnBindings, String groupName, boolean isCube) throws EngineException {
        block11: {
            if (oldExpression != null) break block11;
            return null;
        }
        try {
            char[] chars = oldExpression.toCharArray();
            if (chars.length < 8) {
                return oldExpression;
            }
            ParseIndicator indicator = new ParseIndicator(0, 0, false, false, true, true);
            int i = 0;
            while (i < chars.length) {
                if ((i = (indicator = ExpressionUtil.getParseIndicator(chars, i, indicator.omitNextQuote(), indicator.getCandidateKey1(), indicator.getCandidateKey2())).getNewIndex()) >= indicator.getRetrieveSize() + 6 && indicator.isCandidateKey() && chars[i - indicator.getRetrieveSize() - 6] == 'T' && chars[i - indicator.getRetrieveSize() - 5] == 'o' && chars[i - indicator.getRetrieveSize() - 4] == 't' && chars[i - indicator.getRetrieveSize() - 3] == 'a' && chars[i - indicator.getRetrieveSize() - 2] == 'l' && chars[i - indicator.getRetrieveSize() - 1] == '.' && (i - indicator.getRetrieveSize() - 7 <= 0 || ExpressionUtil.isValidProceeding(chars[i - indicator.getRetrieveSize() - 7]))) {
                    String firstPart = oldExpression.substring(0, i - indicator.getRetrieveSize() - 6);
                    int startIndex = i - indicator.getRetrieveSize() - 6;
                    i = ExpressionUtil.advanceToNextValidEncloser(chars, i);
                    String secondPart = "";
                    Object name = "";
                    String expr = "";
                    if (i < chars.length) {
                        int endIndex = i + 1;
                        expr = oldExpression.substring(startIndex, endIndex);
                        secondPart = this.prepareTotalExpression(oldExpression.substring(i + 1 - indicator.getRetrieveSize()), columnBindings, groupName, isCube);
                    } else {
                        expr = oldExpression.substring(startIndex);
                    }
                    boolean shouldAddToList = true;
                    int j = 0;
                    while (j < columnBindings.size()) {
                        IBaseExpression expression = ((IBinding)columnBindings.get(j)).getExpression();
                        if (expression instanceof IScriptExpression && oldExpression.equals(((IScriptExpression)expression).getText())) {
                            shouldAddToList = false;
                            name = ((IBinding)columnBindings.get(j)).getBindingName();
                            break;
                        }
                        ++j;
                    }
                    if (shouldAddToList) {
                        name = TOTAL_PREFIX + this.totalColumnSuffix;
                        ++this.totalColumnSuffix;
                        ScriptExpression se = new ScriptExpression(expr);
                        se.setGroupName(groupName);
                        Binding columnBinding = new Binding((String)name, (IBaseExpression)se);
                        columnBindings.add(columnBinding);
                    }
                    String newExpression = null;
                    newExpression = !isCube ? firstPart + org.eclipse.birt.core.data.ExpressionUtil.createJSRowExpression((String)name) + secondPart : firstPart + org.eclipse.birt.core.data.ExpressionUtil.createJSDataExpression((String)name) + secondPart;
                    return newExpression;
                }
                ++i;
            }
            return oldExpression;
        }
        catch (DataException e) {
            throw new EngineException((BirtException)e);
        }
    }

    private static int advanceToNextValidEncloser(char[] chars, int i) {
        boolean isTotalConstants = true;
        int numberOfOpenBracket = 0;
        while (i < chars.length) {
            ParseIndicator pid = ExpressionUtil.getParseIndicator(chars, i, false, true, true);
            i = pid.getNewIndex();
            if (pid.isCandidateKey() && chars[i] == '(') {
                isTotalConstants = false;
                ++numberOfOpenBracket;
            }
            if (isTotalConstants) {
                if (ExpressionUtil.isValidProceeding(chars[i])) break;
                ++i;
                continue;
            }
            if (chars[i] != ')') {
                ++i;
                continue;
            }
            if (chars[i] == ')') {
                --numberOfOpenBracket;
            }
            if (numberOfOpenBracket == 0) break;
            ++i;
        }
        if (isTotalConstants) {
            --i;
        }
        return i;
    }

    private static ParseIndicator getParseIndicator(char[] chars, int i, boolean omitNextQuote, boolean candidateKey1, boolean candidateKey2) {
        int retrieveSize = 0;
        if (chars[i] == '/') {
            if (i > 0 && chars[i - 1] == '/') {
                ++retrieveSize;
                while (i < chars.length - 2) {
                    ++retrieveSize;
                    if (chars[++i] == '\n') break;
                }
                ++retrieveSize;
                ++i;
            }
        } else if (chars[i] == '*' && i > 0 && chars[i - 1] == '/') {
            ++i;
            retrieveSize += 2;
            while (i < chars.length - 2) {
                ++retrieveSize;
                if (chars[++i - 1] == '*' && chars[i] == '/') break;
            }
            ++retrieveSize;
            ++i;
        }
        if (!omitNextQuote && chars[i] == '\"') {
            boolean bl = candidateKey1 = !candidateKey1;
            if (candidateKey1) {
                candidateKey2 = true;
            }
        }
        if (!omitNextQuote && chars[i] == '\'') {
            boolean bl = candidateKey2 = !candidateKey2;
            if (candidateKey2) {
                candidateKey1 = true;
            }
        }
        omitNextQuote = chars[i] == '\\';
        return new ParseIndicator(retrieveSize, i, candidateKey1, omitNextQuote, candidateKey1, candidateKey2);
    }

    private static boolean isValidProceeding(char operator) {
        return !(operator >= 'A' && operator <= 'Z' || operator >= 'a' && operator <= 'z') && operator != '_';
    }

    private IScriptExpression adapterExpression(Expression expr) {
        if (expr instanceof Expression.Script && !"javascript".equals(((Expression.Script)expr).getLanguage())) {
            ScriptExpression scriptExpr = null;
            try {
                scriptExpr = this.getModelAdapter().adaptJSExpression(expr.getScriptText(), ((Expression.Script)expr).getLanguage());
                return new ScriptExpression(scriptExpr.getText());
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Error adapting expr " + expr.getScriptText(), ex);
            }
        } else if (expr.getType() == 0) {
            ScriptExpression jsExpr = new ScriptExpression(expr.getScriptText());
            jsExpr.setScriptId("constant");
            jsExpr.setHandle((Object)expr.getScriptText());
            return jsExpr;
        }
        return new ScriptExpression(expr.getScriptText());
    }

    public IConditionalExpression createConditionalExpression(Expression testExpression, String operator, Expression value1, Expression value2) {
        IScriptExpression expr = null;
        IScriptExpression tempV1 = null;
        IScriptExpression tempV2 = null;
        if (testExpression != null) {
            expr = this.adapterExpression(testExpression);
        }
        if (value1 != null) {
            tempV1 = this.adapterExpression(value1);
        }
        if (value2 != null) {
            tempV2 = this.adapterExpression(value2);
        }
        ConditionalExpression expression = new ConditionalExpression(expr, DataAdapterUtil.adaptModelFilterOperator((String)operator), (IBaseExpression)tempV1, (IBaseExpression)tempV2);
        return ExpressionUtil.transformConditionalExpression((IConditionalExpression)expression);
    }

    public IConditionalExpression createConditionExpression(Expression testExpression, String operator, List<Expression> valueList) {
        Expression expr2;
        ArrayList<IScriptExpression> values = new ArrayList<IScriptExpression>(valueList.size());
        for (Expression expr2 : valueList) {
            values.add(this.adapterExpression(expr2));
        }
        expr2 = null;
        if (testExpression != null) {
            expr2 = this.adapterExpression(testExpression);
        }
        ConditionalExpression expression = new ConditionalExpression((IScriptExpression)expr2, DataAdapterUtil.adaptModelFilterOperator((String)operator), values);
        return ExpressionUtil.transformConditionalExpression((IConditionalExpression)expression);
    }

    private IModelAdapter getModelAdapter() throws BirtException {
        if (this.adapter == null) {
            DataRequestSessionImpl session = new DataRequestSessionImpl(new DataSessionContext(3));
            this.adapter = session.getModelAdaptor();
        }
        return this.adapter;
    }
}

