/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;

public class FilterUtil {
    private FilterUtil() {
    }

    public static List<IFilterDefinition> sortFilters(List<IFilterDefinition> filters) {
        if (filters == null) {
            return null;
        }
        int size = filters.size();
        IFilterDefinition[] filterArray = new IFilterDefinition[size];
        int i = 0;
        while (i < size) {
            filterArray[i] = filters.get(i);
            ++i;
        }
        Arrays.sort(filterArray, new Comparator<IFilterDefinition>(){

            @Override
            public int compare(IFilterDefinition o1, IFilterDefinition o2) {
                if (FilterUtil.isTopOrBottomFilter((FilterDefinition)o1)) {
                    return -1;
                }
                if (FilterUtil.isTopOrBottomFilter((FilterDefinition)o2)) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<IFilterDefinition> sortedFilters = new ArrayList<IFilterDefinition>();
        int i2 = 0;
        while (i2 < size) {
            sortedFilters.add(filterArray[i2]);
            ++i2;
        }
        return sortedFilters;
    }

    private static boolean isTopOrBottomFilter(FilterDefinition fd) {
        ConditionalExpression ce;
        IBaseExpression be = fd.getExpression();
        return be instanceof ConditionalExpression && ((ce = (ConditionalExpression)be).getOperator() == 14 || ce.getOperator() == 16 || ce.getOperator() == 15 || ce.getOperator() == 17);
    }
}

