/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.ITableLayoutCalculator;

public class FixTableLayoutCalculator
implements ITableLayoutCalculator {
    private float tableWidth;
    private int colNum;
    private String[] definedWidthValues;
    private float[] tableWidthValues = null;
    private float fixWidthAmt;
    private float colMinSize;
    private float minWidthAmt;
    private int minAmt;

    @Override
    public float[] getFloatColWidth() {
        if (this.definedWidthValues.length > 0) {
            this.colNum = this.definedWidthValues.length;
            this.tableWidthValues = new float[this.colNum];
            return this.calcColumnWidth();
        }
        return null;
    }

    public void setDefinedColWidth(String[] widthValues) {
        this.definedWidthValues = widthValues;
    }

    public float[] getRowHeight() {
        return null;
    }

    public void setTableWidth(float width) {
        this.tableWidth = width;
    }

    private float[] calcColumnWidth() throws NumberFormatException {
        this.fixWidthAmt = 0.0f;
        this.getFixNumColWidth();
        this.calPercentAndNullColWidth();
        this.adjustWidth();
        return this.tableWidthValues;
    }

    /*
     * Unable to fully structure code
     */
    private void adjustWidth() {
        block13: {
            amt = 0.0f;
            if (this.minWidthAmt > this.tableWidth) {
                i = 0;
                while (i < this.tableWidthValues.length) {
                    this.tableWidthValues[i] = Math.max(this.colMinSize, this.tableWidthValues[i]);
                    ++i;
                }
                return;
            }
            i = 0;
            while (i < this.tableWidthValues.length) {
                amt += this.tableWidthValues[i];
                ++i;
            }
            adjustValue = 0.0f;
            if (this.tableWidth - amt > 0.0f) {
                adjustValue = (this.tableWidth - amt) / (float)this.minAmt;
                if (adjustValue - this.colMinSize < 0.0f) {
                    adjustValue = this.colMinSize;
                }
                i = 0;
                while (i < this.tableWidthValues.length) {
                    if (this.tableWidthValues[i] == 0.0f) {
                        this.tableWidthValues[i] = adjustValue;
                    }
                    ++i;
                }
            }
            amt = 0.0f;
            i = 0;
            while (i < this.tableWidthValues.length) {
                amt += this.tableWidthValues[i];
                ++i;
            }
            if (!(this.tableWidth <= (float)this.colNum * this.colMinSize)) ** GOTO lbl52
            i = 0;
            while (i < this.tableWidthValues.length) {
                this.tableWidthValues[i] = Math.max(this.colMinSize, this.tableWidthValues[i]);
                ++i;
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                adjustValue = this.tableWidth / amt;
                i = 0;
                while (i < this.tableWidthValues.length) {
                    this.tableWidthValues[i] = this.tableWidthValues[i] * adjustValue;
                    if (this.tableWidthValues[i] < this.colMinSize) {
                        this.tableWidthValues[i] = this.colMinSize;
                    }
                    ++i;
                }
                amt = 0.0f;
                i = 0;
                while (i < this.tableWidthValues.length) {
                    amt += this.tableWidthValues[i];
                    ++i;
                }
lbl52:
                // 2 sources

                ** while ((double)Math.abs((float)(amt - this.tableWidth)) > 0.5)
            }
        }
    }

    private void calPercentAndNullColWidth() throws NumberFormatException {
        int i = 0;
        while (i < this.definedWidthValues.length) {
            try {
                Float.parseFloat(this.definedWidthValues[i]);
            }
            catch (NumberFormatException e) {
                if (this.definedWidthValues[i].endsWith("%")) {
                    this.tableWidthValues[i] = this.tableWidth * this.getPercentValue(this.definedWidthValues[i]) / 100.0f;
                    if (this.tableWidthValues[i] < this.colMinSize) {
                        this.tableWidthValues[i] = 0.0f;
                        this.minWidthAmt += this.colMinSize;
                        ++this.minAmt;
                    }
                    this.fixWidthAmt += this.tableWidthValues[i];
                }
                if (this.definedWidthValues[i] == null || "".equalsIgnoreCase(this.definedWidthValues[i])) {
                    this.tableWidthValues[i] = 0.0f;
                    this.fixWidthAmt += this.tableWidthValues[i];
                    this.minWidthAmt += this.colMinSize;
                    ++this.minAmt;
                }
                throw e;
            }
            ++i;
        }
        this.setFixWidthAmt(this.fixWidthAmt);
    }

    private float getPercentValue(String value) {
        return Float.parseFloat(value.substring(0, value.indexOf("%")));
    }

    private void getFixNumColWidth() {
        float fixWidthAmt = 0.0f;
        int i = 0;
        while (i < this.definedWidthValues.length) {
            try {
                float width;
                this.tableWidthValues[i] = width = Float.parseFloat(this.definedWidthValues[i]);
                if (this.tableWidthValues[i] < this.colMinSize) {
                    this.tableWidthValues[i] = this.colMinSize;
                    this.minWidthAmt += this.colMinSize;
                    ++this.minAmt;
                }
                fixWidthAmt += width;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        this.setFixWidthAmt(fixWidthAmt);
    }

    private void setFixWidthAmt(float widthAmt) {
        this.fixWidthAmt = widthAmt;
    }

    public void setColMinSize(float minSize) {
        this.colMinSize = minSize;
    }

    @Override
    public int[] getIntColWidth() throws NumberFormatException {
        float[] width = null;
        width = this.getFloatColWidth();
        int amt = 0;
        if (width == null) {
            throw new NumberFormatException(Messages.getString("FixTableLayoutCalculator.Error.CannotParse"));
        }
        int[] intWidth = new int[width.length];
        int i = 0;
        while (i < width.length) {
            intWidth[i] = Math.round(width[i]);
            amt += intWidth[i];
            ++i;
        }
        int balance = amt - (int)this.tableWidth;
        int i2 = 0;
        while (balance > 0) {
            if ((float)intWidth[i2] > this.colMinSize) {
                int n = i2;
                intWidth[n] = intWidth[n] - 1;
            }
            if (++i2 >= intWidth.length - 1) break;
            --balance;
        }
        return intWidth;
    }

    @Override
    public float[] getFloatRowHeight() {
        return null;
    }

    @Override
    public float[] getIntRowHeight() {
        return null;
    }
}

