/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import java.lang.reflect.Member;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.oda.pojo.impl.Driver;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.MethodSource;
import org.eclipse.birt.data.oda.pojo.querymodel.PojoQuery;
import org.eclipse.birt.data.oda.pojo.querymodel.VariableParameter;
import org.eclipse.birt.data.oda.pojo.ui.Activator;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.impl.dialogs.ClassInputDialog;
import org.eclipse.birt.data.oda.pojo.ui.impl.dialogs.ColumnMappingDialog;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.ColumnDefinition;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.ToolTipFaker;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.TreeData;
import org.eclipse.birt.data.oda.pojo.ui.impl.providers.ClassTreeContentProvider;
import org.eclipse.birt.data.oda.pojo.ui.impl.providers.ClassTreeLabelProvider;
import org.eclipse.birt.data.oda.pojo.ui.impl.providers.ColumnMappingPageHelper;
import org.eclipse.birt.data.oda.pojo.ui.impl.providers.ColumnMappingTableProvider;
import org.eclipse.birt.data.oda.pojo.ui.util.HelpUtil;
import org.eclipse.birt.data.oda.pojo.ui.util.Utils;
import org.eclipse.birt.data.oda.pojo.util.ClassLister;
import org.eclipse.birt.data.oda.pojo.util.PojoQueryParser;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.CustomData;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class ColumnMappingWizardPage
extends DataSetWizardPage {
    private static Logger logger = Logger.getLogger(ColumnMappingWizardPage.class.getName());
    private static final String DEFAULT_FILTER_STRING = "get*";
    private static final String EMPTY_STRING = "";
    private String pojoRootClass;
    private String pojoDataSetClass;
    private Text txtMethodNameRegex;
    private Text pojoClassNameText;
    private TreeViewer classStructureTree;
    private TableViewer columnMappingsTable;
    private MenuItem menuRemove;
    private MenuItem menuRemoveAll;
    private Button addBtn;
    private Button removeBtn;
    private Button editButton;
    private Button upButton;
    private Button downButton;
    private DataSetDesign design;
    private ColumnMappingPageHelper helper = new ColumnMappingPageHelper();

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.getControl() == null) {
            return super.collectDataSetDesign(design);
        }
        try {
            Utils.savePrivateProperty(design, "methodNameRegx", this.txtMethodNameRegex.getText().trim());
            Utils.savePrivateProperty(design, "pojoClass", this.pojoRootClass);
        }
        catch (OdaException e1) {
            ExceptionHandler.showException((Shell)this.getControl().getShell(), (String)Messages.getString("DataSet.FailedToSaveTitle"), (String)Messages.getString("DataSet.FailedToSaveMsg"), (Throwable)e1);
        }
        PojoQuery pq = null;
        String query = design.getQueryText();
        if (query != null && query.length() > 0) {
            try {
                pq = PojoQueryParser.parse((String)query);
            }
            catch (OdaException e) {
                logger.log(Level.WARNING, Messages.getString("ColumnMappingWizardPage.error.getQueryText"), e);
            }
        }
        ColumnDefinition[] inputs = this.helper.getColumnDefinitions().toArray(new ColumnDefinition[0]);
        if (pq == null) {
            pq = new PojoQuery("1.0", null, null);
            Utils.updateColumnMappings(pq, inputs);
            Utils.savePojoQuery(pq, design, this.getControl().getShell());
            this.populateResultSetMetaData(design);
        } else {
            Utils.updateColumnMappings(pq, inputs);
            Utils.savePojoQuery(pq, design, this.getControl().getShell());
            this.populateResultSetMetaData(design);
        }
        return design;
    }

    private void updateVariableParameters(ColumnDefinition[] inputs, DataSetDesign design) {
        if (design.getParameters() == null) {
            return;
        }
        EList parameters = design.getParameters().getParameterDefinitions();
        int i = 0;
        while (i < inputs.length) {
            List<VariableParameter> params = inputs[i].getVariableParameters();
            int j = 0;
            while (j < params.size()) {
                int k = 0;
                while (k < parameters.size()) {
                    if (params.get(j).getName() != null && params.get(j).getName().equals(((ParameterDefinition)parameters.get(k)).getAttributes().getName()) && ((ParameterDefinition)parameters.get(k)).getDefaultValues() != null) {
                        Object o = ((ParameterDefinition)parameters.get(k)).getDefaultValues().getValues().get(0);
                        if (o != null && o instanceof CustomData) {
                            params.get(j).setStringValue(((CustomData)o).getValue().toString());
                        } else {
                            params.get(j).setStringValue(((ParameterDefinition)parameters.get(k)).getDefaultScalarValue());
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        this.design = dataSetDesign;
        this.updateVariableParameters(this.helper.getColumnDefinitions().toArray(new ColumnDefinition[0]), dataSetDesign);
        super.refresh(dataSetDesign);
    }

    public ColumnMappingWizardPage(String pageName) {
        super(pageName);
        this.setMessage(Messages.getString("DataSet.ColumnMappingPageMsg"));
    }

    public ColumnMappingWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage(Messages.getString("DataSet.ColumnMappingPageMsg"));
    }

    private void initPageControls() {
        this.txtMethodNameRegex.setText(EMPTY_STRING);
        super.refresh(this.design);
        String query = this.design.getQueryText();
        PojoQuery pq = null;
        if (query != null && query.length() > 0) {
            try {
                pq = PojoQueryParser.parse((String)query);
            }
            catch (OdaException e) {
                logger.log(Level.WARNING, Messages.getString("ColumnMappingWizardPage.error.getQueryText"), e);
            }
        }
        if (pq == null) {
            pq = new PojoQuery("1.0", null, null);
        }
        this.helper.clearColumnDefinitions();
        try {
            ColumnDefinition[] defns = Utils.getColumnDefinitions(pq);
            this.helper.addColumnDefinitions(defns);
            this.columnMappingsTable.setInput(this.helper.getColumnDefinitions());
        }
        catch (OdaException e) {
            logger.log(Level.WARNING, EMPTY_STRING, e);
        }
        this.refreshColumnMappingTable();
        String prop = Utils.getPrivateProperty(this.design, "methodNameRegx");
        if (prop != null) {
            this.txtMethodNameRegex.setText(prop.trim());
        }
        this.pojoDataSetClass = Utils.getPrivateProperty(this.design, "pojoClass");
        this.setPojoDataSetClass(pq.getDataSetClass());
        try {
            this.initClassStructure(this.design);
        }
        catch (Throwable t) {
            ExceptionHandler.showException((Shell)this.getControl().getShell(), (String)Messages.getString("DataSet.FailedToLoadClassTitle"), (String)Messages.getFormattedString("DataSet.FailedToLoadPojoClassMsg", new String[]{this.pojoRootClass}), (Throwable)t);
        }
    }

    public void createPageCustomControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        pageComposite.setLayout((Layout)new FillLayout());
        SashForm sf = new SashForm(pageComposite, 256);
        this.createLeftComposite(sf);
        this.createRightComposite(sf);
        this.setControl((Control)pageComposite);
        this.refreshColumnMappingTable();
        this.design = this.getInitializationDesign();
        this.initPageControls();
        this.updateButtonStatus();
        HelpUtil.setSystemHelp((Control)pageComposite, "org.eclipse.birt.cshelp.Wizard_POJO_Dataset_ColumnMapping_ID");
    }

    private void createRightComposite(SashForm sf) {
        Composite right = new Composite((Composite)sf, 0);
        right.setLayout((Layout)new GridLayout(1, false));
        Group classStructureGroup = new Group(right, 0);
        classStructureGroup.setLayoutData((Object)new GridData(1808));
        classStructureGroup.setText(Messages.getString("DataSet.ColumnMapping"));
        classStructureGroup.setLayout((Layout)new GridLayout(2, false));
        this.createRightTableViewer(classStructureGroup);
        this.createRightButtonArea(classStructureGroup);
    }

    private void createRightTableViewer(Group classStructureGroup) {
        this.columnMappingsTable = new TableViewer((Composite)classStructureGroup, 68356);
        this.columnMappingsTable.getTable().setLayoutData((Object)new GridData(1808));
        TableViewerColumn tc = new TableViewerColumn(this.columnMappingsTable, 16384);
        tc.getColumn().setText(Messages.getString("ColumnMappingPage.table.head.columnName"));
        tc.getColumn().setWidth(80);
        tc = new TableViewerColumn(this.columnMappingsTable, 16384);
        tc.getColumn().setText(Messages.getString("ColumnMappingPage.table.head.MethodField"));
        tc.getColumn().setWidth(140);
        tc = new TableViewerColumn(this.columnMappingsTable, 16384);
        tc.getColumn().setText(Messages.getString("ColumnMappingPage.table.head.columnType"));
        tc.getColumn().setWidth(80);
        this.columnMappingsTable.getTable().setHeaderVisible(true);
        this.columnMappingsTable.getTable().setLinesVisible(true);
        ColumnMappingTableProvider provider = new ColumnMappingTableProvider();
        this.columnMappingsTable.setContentProvider((IContentProvider)provider.getTableContentProvider());
        this.columnMappingsTable.setLabelProvider((IBaseLabelProvider)provider.getTableLabelProvider());
        this.columnMappingsTable.setInput(this.helper.getColumnDefinitions());
        this.createTableMenuItems();
    }

    private void createTableMenuItems() {
        Menu menu = new Menu((Control)this.columnMappingsTable.getTable());
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                ColumnMappingWizardPage.this.columnMappingsTable.cancelEditing();
            }
        });
        this.menuRemove = new MenuItem(menu, 0);
        this.menuRemove.setText(Messages.getString("ColumnMappingDialog.MenuItem.remove"));
        this.menuRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingWizardPage.this.removeColumnMappingsFromTable();
                ColumnMappingWizardPage.this.refreshColumnMappingTable();
                ColumnMappingWizardPage.this.updateButtonStatus();
            }
        });
        this.menuRemoveAll = new MenuItem(menu, 0);
        this.menuRemoveAll.setText(Messages.getString("ColumnMappingDialog.MenuItem.removeAll"));
        this.menuRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingWizardPage.this.removeAllColumnMappingsFromTable();
                ColumnMappingWizardPage.this.refreshColumnMappingTable();
                ColumnMappingWizardPage.this.updateButtonStatus();
            }
        });
        this.columnMappingsTable.getTable().setMenu(menu);
    }

    private void createRightButtonArea(Group classStructureGroup) {
        Composite buttonComposite = new Composite((Composite)classStructureGroup, 0);
        buttonComposite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(1, false);
        layout.marginBottom = 30;
        layout.marginWidth = 5;
        buttonComposite.setLayout((Layout)layout);
        this.editButton = new Button(buttonComposite, 0);
        this.editButton.setEnabled(false);
        this.editButton.setText(Messages.getString("DataSet.Edit"));
        this.editButton.setToolTipText(Messages.getString("DataSet.button.tooltip.Edit"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingWizardPage.this.editColumnMapping();
            }
        });
        int maxWidth = this.computeMaxWidth(this.editButton, 52);
        this.upButton = new Button(buttonComposite, 0);
        this.upButton.setEnabled(false);
        this.upButton.setText(Messages.getString("DataSet.Up"));
        this.upButton.setToolTipText(Messages.getString("DataSet.button.tooltip.Up"));
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingWizardPage.this.upColumnMapping();
            }
        });
        maxWidth = this.computeMaxWidth(this.upButton, maxWidth);
        this.downButton = new Button(buttonComposite, 0);
        this.downButton.setEnabled(false);
        this.downButton.setText(Messages.getString("DataSet.Down"));
        this.downButton.setToolTipText(Messages.getString("DataSet.button.tooltip.Down"));
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingWizardPage.this.downColumnMapping();
            }
        });
        maxWidth = this.computeMaxWidth(this.downButton, maxWidth);
        GridData btnData = new GridData(768);
        btnData.widthHint = maxWidth;
        this.editButton.setLayoutData((Object)btnData);
        this.upButton.setLayoutData((Object)btnData);
        this.downButton.setLayoutData((Object)btnData);
        this.addDoubleClickListeners();
        this.addKeyListener();
        this.columnMappingsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnMappingWizardPage.this.updateButtonStatus();
            }
        });
    }

    private void createLeftComposite(SashForm sf) {
        Composite left = new Composite((Composite)sf, 0);
        left.setLayout((Layout)new GridLayout(2, false));
        Group classStructureGroup = new Group(left, 0);
        classStructureGroup.setText(Messages.getString("DataSet.ClassStructure"));
        classStructureGroup.setLayoutData((Object)new GridData(1808));
        classStructureGroup.setLayout((Layout)new GridLayout(1, false));
        this.createClassNameComposite((Composite)classStructureGroup);
        this.createClassStructureComposite(left, classStructureGroup);
    }

    private void createClassStructureComposite(Composite left, Group classStructureGroup) {
        Label label = new Label((Composite)classStructureGroup, 0);
        label.setText(Messages.getString("DataSet.Label.MethodNameFilter"));
        GridData lableData = new GridData(768);
        label.setLayoutData((Object)lableData);
        this.txtMethodNameRegex = new Text((Composite)classStructureGroup, 2048);
        this.txtMethodNameRegex.setLayoutData((Object)new GridData(768));
        this.txtMethodNameRegex.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ColumnMappingWizardPage.this.initClassStructure(ColumnMappingWizardPage.this.getInitializationDesign());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.txtMethodNameRegex.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
            }

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 0x1000002) {
                    ColumnMappingWizardPage.this.classStructureTree.getTree().setFocus();
                    if (ColumnMappingWizardPage.this.classStructureTree.getTree().getItemCount() > 0) {
                        ColumnMappingWizardPage.this.classStructureTree.getTree().select(ColumnMappingWizardPage.this.classStructureTree.getTree().getItem(0));
                    }
                }
            }
        });
        this.classStructureTree = new TreeViewer((Composite)classStructureGroup, 2818);
        this.classStructureTree.getTree().setLayoutData((Object)new GridData(1808));
        this.classStructureTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnMappingWizardPage.this.updateCenterButtonStatus();
            }
        });
        new ToolTipFaker(this.classStructureTree).fakeToolTip();
        this.createCenterButtonArea(left);
    }

    private void createCenterButtonArea(Composite left) {
        Composite btnComposite = new Composite(left, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        btnComposite.setLayout((Layout)layout);
        this.addBtn = new Button(btnComposite, 0);
        this.addBtn.setText(">");
        this.addBtn.setToolTipText(Messages.getString("DataSet.button.addColumn.tooltip.mapColumn"));
        GridData buttonData = new GridData();
        buttonData.widthHint = Math.max(32, this.addBtn.computeSize((int)-1, (int)-1).x);
        this.addBtn.setLayoutData((Object)buttonData);
        this.addBtn.setEnabled(false);
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingWizardPage.this.addColumnMappingsFromTree();
                ColumnMappingWizardPage.this.refreshColumnMappingTable();
            }
        });
        this.removeBtn = new Button(btnComposite, 0);
        this.removeBtn.setText("<");
        this.removeBtn.setToolTipText(Messages.getString("DataSet.button.removeColumn.tooltip.mapColumn"));
        this.removeBtn.setLayoutData((Object)buttonData);
        this.removeBtn.setEnabled(false);
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingWizardPage.this.removeColumnMappingsFromTable();
                ColumnMappingWizardPage.this.refreshColumnMappingTable();
                ColumnMappingWizardPage.this.updateButtonStatus();
            }
        });
    }

    private void createClassNameComposite(Composite parent) {
        int width;
        Composite classNameComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 5;
        classNameComposite.setLayout((Layout)layout);
        GridData compositeData = new GridData(768);
        classNameComposite.setLayoutData((Object)compositeData);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        Label classNameLabel = new Label(classNameComposite, 0);
        classNameLabel.setLayoutData((Object)data);
        classNameLabel.setText(Messages.getString("DataSet.Label.POJOClassName"));
        classNameLabel.setFont(new Font((Device)Display.getCurrent(), "Tahoma", 10, 1));
        Label prompLabel = new Label(classNameComposite, 0);
        prompLabel.setText(Messages.getString("DataSet.Label.prompt.ClassName"));
        prompLabel.setLayoutData((Object)data);
        GridData textData = new GridData(768);
        textData.horizontalSpan = 2;
        this.pojoClassNameText = new Text(classNameComposite, 2048);
        this.pojoClassNameText.setLayoutData((Object)textData);
        String className = Utils.getPrivateProperty(this.getInitializationDesign(), "pojoClass");
        this.pojoRootClass = className == null ? EMPTY_STRING : className;
        this.pojoClassNameText.setText(this.pojoRootClass);
        Button browseButton = new Button(classNameComposite, 0);
        browseButton.setText(Messages.getString("DataSet.Browse1"));
        browseButton.setToolTipText(Messages.getString("DataSet.Browse.tooltip"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassInputDialog cid = new ClassInputDialog(ColumnMappingWizardPage.this.getControl().getShell(), ClassLister.listClasses((URL[])ColumnMappingWizardPage.this.getPojoClassPath()), ColumnMappingWizardPage.this.pojoClassNameText.getText().trim());
                if (cid.open() == 0 && cid.getInput() != null) {
                    ColumnMappingWizardPage.this.pojoClassNameText.setText(cid.getInput().trim());
                    ColumnMappingWizardPage.this.setPojoRootClass(cid.getInput().trim());
                    try {
                        ColumnMappingWizardPage.this.initClassStructure(ColumnMappingWizardPage.this.getInitializationDesign());
                    }
                    catch (Throwable t) {
                        ExceptionHandler.showException((Shell)ColumnMappingWizardPage.this.getShell(), (String)Messages.getString("DataSet.FailedToLoadClassTitle"), (String)Messages.getFormattedString("DataSet.FailedToLoadPojoClassMsg", new String[]{ColumnMappingWizardPage.this.pojoRootClass}), (Throwable)t);
                    }
                    ColumnMappingWizardPage.this.txtMethodNameRegex.setText(ColumnMappingWizardPage.DEFAULT_FILTER_STRING);
                }
            }
        });
        final Button applyButton = new Button(classNameComposite, 0);
        applyButton.setText(Messages.getString("ColumnMappingWizardPage.button.apply.text"));
        applyButton.setToolTipText(Messages.getString("ColumnMappingWizardPage.button.apply.tooltip"));
        applyButton.setEnabled(this.pojoClassNameText.getText().trim().length() > 0);
        applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingWizardPage.this.setPojoRootClass(ColumnMappingWizardPage.this.pojoClassNameText.getText().trim());
                ColumnMappingWizardPage.this.txtMethodNameRegex.setText(ColumnMappingWizardPage.DEFAULT_FILTER_STRING);
            }
        });
        GridData buttonData = new GridData();
        buttonData.widthHint = width = this.computeMaxWidth(applyButton, this.computeMaxWidth(browseButton, 80));
        browseButton.setLayoutData((Object)buttonData);
        applyButton.setLayoutData((Object)buttonData);
        this.pojoClassNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnMappingWizardPage.this.pojoRootClass = ColumnMappingWizardPage.this.pojoClassNameText.getText().trim();
                applyButton.setEnabled(ColumnMappingWizardPage.this.pojoRootClass.length() > 0);
            }
        });
    }

    private int computeMaxWidth(Button btn, int maxWidth) {
        int widthHint = btn.computeSize((int)-1, (int)-1).x - btn.getBorderWidth();
        return widthHint > maxWidth ? widthHint : maxWidth;
    }

    private void addKeyListener() {
        this.columnMappingsTable.getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    ColumnMappingWizardPage.this.removeColumnMappings();
                }
            }
        });
    }

    private URL[] getPojoClassPath() {
        if (this.design == null) {
            return null;
        }
        DataSourceDesign dataSource = this.design.getDataSourceDesign();
        String pojoClassPath = Utils.getPrivateProperty(dataSource, "pojoClassPath");
        try {
            return Utils.createURLParser(this.getHostResourceIdentifiers()).parse(pojoClassPath);
        }
        catch (OdaException e) {
            logger.log(Level.WARNING, "Failed to parse POJO Class Path", e);
            return null;
        }
    }

    private String[] splitNameFilterRegex(String methodNameRegex) {
        if (methodNameRegex == null || methodNameRegex.trim().length() == 0) {
            return null;
        }
        if (!methodNameRegex.contains(".")) {
            return new String[]{methodNameRegex};
        }
        methodNameRegex = methodNameRegex.replace("(", EMPTY_STRING);
        methodNameRegex = methodNameRegex.replace(")", EMPTY_STRING);
        String[] splits = methodNameRegex.split("\\.");
        int i = 0;
        while (i < splits.length) {
            if (splits[i].trim().length() == 0) {
                return null;
            }
            ++i;
        }
        return splits;
    }

    private boolean isFirstRow(Object o) {
        return this.helper.isFirstRow(o);
    }

    private boolean isLastRow(Object o) {
        return this.helper.isLastRow(o);
    }

    public void initClassStructure(DataSetDesign dataSet) throws Throwable {
        String[] splits = this.splitNameFilterRegex(this.txtMethodNameRegex.getText().trim());
        this.classStructureTree.setContentProvider((IContentProvider)new ClassTreeContentProvider(splits, null));
        this.classStructureTree.setInput(null);
        DataSourceDesign dataSource = dataSet.getDataSourceDesign();
        String pojoClassPath = Utils.getPrivateProperty(dataSource, "pojoClassPath");
        if (this.pojoRootClass != null && this.pojoRootClass.trim().length() > 0) {
            try {
                URL[] urls = Utils.createURLParser(this.getHostResourceIdentifiers()).parse(pojoClassPath);
                URLClassLoader cl = new URLClassLoader(urls, Activator.class.getClassLoader());
                Class<?> c = cl.loadClass(this.pojoRootClass.trim());
                this.classStructureTree.setContentProvider((IContentProvider)new ClassTreeContentProvider(splits, cl));
                this.classStructureTree.setLabelProvider((IBaseLabelProvider)new ClassTreeLabelProvider());
                TreeData treeData = new TreeData(c, 0);
                this.classStructureTree.setInput((Object)treeData);
                if (splits == null) {
                    this.classStructureTree.expandToLevel(2);
                }
                if (this.txtMethodNameRegex.getText().trim().endsWith(".")) {
                    this.classStructureTree.expandToLevel(splits.length + 2);
                }
                this.classStructureTree.expandToLevel(splits.length + 1);
            }
            catch (Throwable e) {
                this.setErrorMessageInTree(Messages.getFormattedString("DataSet.FailedToLoadPojoClassMsg", new String[]{this.pojoRootClass}));
                throw e;
            }
        } else {
            this.setErrorMessageInTree(Messages.getString("DataSet.MissPojoRootClass"));
        }
    }

    private void setErrorMessageInTree(String error) {
        this.classStructureTree.setContentProvider((IContentProvider)new ClassTreeContentProvider(null, null));
        this.classStructureTree.setInput((Object)error);
    }

    public void setPojoRootClass(String pojoRootClass) {
        this.pojoRootClass = pojoRootClass;
    }

    public String getPojoRootClass() {
        return this.pojoRootClass;
    }

    public void setPojoDataSetClass(String pojoDataSetClass) {
        this.pojoDataSetClass = pojoDataSetClass;
    }

    public String getPojoDataSetClass() {
        return this.pojoDataSetClass;
    }

    public void setPOJORootClass(String rootClass) {
        this.pojoRootClass = rootClass;
        if (this.pojoClassNameText != null && !this.pojoClassNameText.isDisposed()) {
            this.pojoClassNameText.setText(this.pojoRootClass != null ? this.pojoRootClass : EMPTY_STRING);
        }
    }

    private ColumnDefinition[] getMappingsToAdd() {
        this.helper.clearParametersCache();
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        TreeItem[] treeItemArray = this.classStructureTree.getTree().getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof TreeData && ((TreeData)item.getData()).getWrappedObject() instanceof Member) {
                Member m = (Member)((TreeData)item.getData()).getWrappedObject();
                ColumnDefinition cm = new ColumnDefinition(this.getMappingPath(item), Utils.getSuggestName(m), Utils.getSuggestOdaType(m));
                result.add(cm);
            }
            ++n2;
        }
        return result.toArray(new ColumnDefinition[0]);
    }

    private IMappingSource[] getMappingPath(TreeItem item) {
        ArrayList<Member> backs = new ArrayList<Member>();
        while (item != null && item.getData() instanceof TreeData && ((TreeData)item.getData()).getWrappedObject() instanceof Member) {
            backs.add((Member)((TreeData)item.getData()).getWrappedObject());
            item = item.getParentItem();
        }
        IMappingSource[] result = this.helper.createMappingPath(backs);
        return result;
    }

    private void populateResultSetMetaData(DataSetDesign dataSetDesign) {
        block13: {
            IConnection conn = null;
            try {
                try {
                    Driver driver = new Driver();
                    conn = driver.getConnection(null);
                    Properties properties = new Properties();
                    DataSourceDesign ds = dataSetDesign.getDataSourceDesign();
                    String dsClassPath = Utils.getPublicProperty(ds, "pojoDataSetClassPath");
                    if (dsClassPath != null) {
                        properties.put("pojoDataSetClassPath", dsClassPath);
                    }
                    conn.open(properties);
                    IQuery query = conn.newQuery(null);
                    query.prepare(dataSetDesign.getQueryText());
                    IResultSetMetaData metadata = query.getMetaData();
                    this.setParameterMetaData(dataSetDesign, query.getParameterMetaData());
                    ColumnMappingWizardPage.setResultSetMetaData(dataSetDesign, metadata);
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    ExceptionHandler.showException((Shell)this.getControl().getShell(), (String)Messages.getString("DataSet.FailedToSaveTitle"), (String)Messages.getString("DataSet.FailedToSaveMsg"), (Throwable)e);
                    if (conn == null) break block13;
                    try {
                        conn.close();
                    }
                    catch (OdaException odaException) {}
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (OdaException odaException) {}
                }
            }
        }
    }

    private void setParameterMetaData(DataSetDesign dataSetDesign, IParameterMetaData paramMetaData) {
        try {
            this.mergeParameterMetaData(dataSetDesign, paramMetaData);
        }
        catch (OdaException odaException) {
            // empty catch block
        }
    }

    private void mergeParameterMetaData(DataSetDesign dataSetDesign, IParameterMetaData paramMetaData) throws OdaException {
        if (paramMetaData == null || dataSetDesign == null) {
            return;
        }
        DataSetParameters dataSetParameter = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)paramMetaData, (ParameterMode)ParameterMode.IN_LITERAL);
        if (dataSetParameter == null) {
            dataSetDesign.setParameters(null);
            return;
        }
        List<IMethodParameter> parameters = this.helper.getAllParameters();
        EList params = dataSetParameter.getParameterDefinitions();
        int i = 0;
        while (i < params.size()) {
            if (((ParameterDefinition)params.get(i)).getAttributes() != null) {
                String paramName = ((ParameterDefinition)params.get(i)).getAttributes().getName();
                int j = 0;
                while (j < parameters.size()) {
                    IMethodParameter mp = parameters.get(j);
                    if (mp instanceof VariableParameter && paramName != null && paramName.equals(((VariableParameter)mp).getName()) && mp.getStringValue() != null && !mp.getStringValue().equals(EMPTY_STRING)) {
                        ((ParameterDefinition)params.get(i)).setDefaultScalarValue(mp.getStringValue());
                    }
                    ++j;
                }
            }
            ++i;
        }
        dataSetDesign.setParameters(dataSetParameter);
    }

    private static void setResultSetMetaData(DataSetDesign dataSetDesign, IResultSetMetaData md) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        if (columns != null) {
            ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
            resultSetDefn.setResultSetColumns(columns);
            dataSetDesign.setPrimaryResultSet(resultSetDefn);
            dataSetDesign.getResultSets().setDerivedMetaData(true);
        } else {
            dataSetDesign.setResultSets(null);
        }
    }

    private void addColumnMappingsFromTree() {
        ColumnDefinition[] mappings = this.getMappingsToAdd();
        if (mappings.length == 1) {
            boolean containsParam = this.containsParameter(mappings[0]);
            ColumnMappingDialog dialog = new ColumnMappingDialog(this.getControl().getShell(), null, this.helper, false, containsParam);
            dialog.setColumnDefinition(mappings[0]);
            if (dialog.open() == 0) {
                mappings[0] = dialog.getColumnDefinition();
                ColumnDefinition added = this.helper.addColumnDefinition(mappings[0]);
                this.refreshColumnMappingTable();
                this.columnMappingsTable.setSelection((ISelection)new StructuredSelection((Object)added));
            }
        } else if (mappings.length > 1) {
            Object[] added = this.helper.addColumnDefinitions(mappings);
            this.refreshColumnMappingTable();
            this.columnMappingsTable.setSelection((ISelection)new StructuredSelection(added));
        }
        this.columnMappingsTable.getTable().setFocus();
    }

    private boolean containsParameter(ColumnDefinition mapping) {
        IMappingSource[] sources = mapping.getMappingPath();
        boolean containsParam = this.containsParameter(sources);
        return containsParam;
    }

    private boolean containsParameter(IMappingSource[] sources) {
        boolean containsParam = false;
        int i = 0;
        while (i < sources.length) {
            MethodSource method;
            if (sources[i] instanceof MethodSource && (method = (MethodSource)sources[i]).getParameters() != null && method.getParameters().length > 0) {
                containsParam = true;
                break;
            }
            ++i;
        }
        return containsParam;
    }

    private void removeColumnMappingsFromTable() {
        int[] indices = this.columnMappingsTable.getTable().getSelectionIndices();
        TableItem[] items = this.columnMappingsTable.getTable().getSelection();
        this.removeColumnMappings(items);
        this.updateViewerSelectionStatus(indices);
        this.updateButtonStatus();
    }

    private void removeAllColumnMappingsFromTable() {
        TableItem[] items = this.columnMappingsTable.getTable().getItems();
        this.removeColumnMappings(items);
        this.updateButtonStatus();
    }

    private void removeColumnMappings(TableItem[] items) {
        int i = 0;
        while (i < items.length) {
            this.helper.removeColumnDefinition((ColumnDefinition)items[i].getData());
            ++i;
        }
        this.columnMappingsTable.refresh();
        this.columnMappingsTable.getTable().getItems();
        this.removeBtn.setEnabled(this.columnMappingsTable.getTable().getSelectionCount() > 0);
    }

    private void updateViewerSelectionStatus(int[] indices) {
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index >= 0 && this.columnMappingsTable.getTable().getItemCount() > index) {
                this.columnMappingsTable.getTable().select(index);
            } else if (this.columnMappingsTable.getTable().getItemCount() <= index && this.columnMappingsTable.getTable().getItemCount() > 0) {
                this.columnMappingsTable.getTable().select(this.columnMappingsTable.getTable().getItemCount() - 1);
            }
            ++i;
        }
    }

    private void editColumnMapping() {
        IStructuredSelection ss = (IStructuredSelection)this.columnMappingsTable.getSelection();
        Object o = ss.getFirstElement();
        int index = this.helper.getElementIndex(o);
        if (index < 0) {
            return;
        }
        ColumnMappingDialog cmd = new ColumnMappingDialog(this.getControl().getShell(), (ColumnDefinition)o, this.helper, true, this.containsParameter((ColumnDefinition)o));
        if (cmd.open() == 0) {
            ColumnDefinition cd = cmd.getColumnDefinition();
            ColumnDefinition newDef = this.helper.setColumnDefinition(index, cd);
            this.refreshColumnMappingTable();
            this.columnMappingsTable.setSelection((ISelection)new StructuredSelection((Object)newDef));
        }
    }

    private void removeColumnMappings() {
        IStructuredSelection ss = (IStructuredSelection)this.columnMappingsTable.getSelection();
        for (Object value : ss) {
            if (!(value instanceof ColumnDefinition)) continue;
            this.helper.removeColumnDefinition((ColumnDefinition)value);
        }
        this.refreshColumnMappingTable();
        this.updateButtonStatus();
    }

    private void upColumnMapping() {
        IStructuredSelection ss = (IStructuredSelection)this.columnMappingsTable.getSelection();
        Object o = ss.getFirstElement();
        int index = this.helper.getElementIndex(o);
        if (index >= 1) {
            this.helper.moveColumnDefinitionUp(index);
            this.refreshColumnMappingTable();
            this.columnMappingsTable.setSelection((ISelection)new StructuredSelection(o));
        }
    }

    private void downColumnMapping() {
        IStructuredSelection ss = (IStructuredSelection)this.columnMappingsTable.getSelection();
        Object o = ss.getFirstElement();
        int index = this.helper.getElementIndex(o);
        if (index >= 0 && index < this.helper.getColumnDefnCount() - 1) {
            this.helper.moveColumnDefinitionDown(index);
            this.refreshColumnMappingTable();
            this.columnMappingsTable.setSelection((ISelection)new StructuredSelection(o));
        }
    }

    private void addDoubleClickListeners() {
        this.columnMappingsTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ColumnMappingWizardPage.this.editColumnMapping();
            }
        });
        this.classStructureTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                ColumnMappingWizardPage.this.addColumnMappingsFromTree();
            }
        });
    }

    private void refreshColumnMappingTable() {
        this.columnMappingsTable.refresh();
        if (this.helper.getColumnDefnCount() > 0) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.setMessage(Messages.getString("DataSet.ColumnMappingPageMsg"));
        } else {
            this.setPageComplete(false);
            this.setErrorMessage(Messages.getString("DataSet.NoColumnMappingErrorMsg"));
        }
    }

    protected boolean canLeave() {
        if (this.columnMappingsTable == null) {
            return true;
        }
        return this.helper.getColumnDefnCount() > 0;
    }

    private void updateCenterButtonStatus() {
        if (this.classStructureTree.getTree().isFocusControl() && this.classStructureTree.getTree().getSelectionCount() > 0) {
            this.addBtn.setEnabled(this.classStructureTree.getTree().getSelection()[0].getParentItem() != null);
        } else {
            this.addBtn.setEnabled(false);
        }
        this.removeBtn.setEnabled(this.columnMappingsTable.getTable().getSelectionCount() > 0);
    }

    private void updateButtonStatus() {
        this.updateCenterButtonStatus();
        this.updateTableEditorButtons();
    }

    private void updateTableEditorButtons() {
        this.menuRemoveAll.setEnabled(this.columnMappingsTable.getTable().getItemCount() > 0);
        IStructuredSelection ss = (IStructuredSelection)this.columnMappingsTable.getSelection();
        this.editButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.menuRemove.setEnabled(ss.size() > 0);
        if (ss.size() == 1) {
            Object o = ss.getFirstElement();
            this.editButton.setEnabled(true);
            if (!this.isFirstRow(o)) {
                this.upButton.setEnabled(true);
            }
            if (!this.isLastRow(o)) {
                this.downButton.setEnabled(true);
            }
        }
    }
}

