/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.preview;

import java.io.IOException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.preview.ImageViewer;
import org.eclipse.birt.chart.ui.swt.wizard.preview.LivePreviewTask;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ChartLivePreviewThread
extends Thread {
    private volatile LivePreviewTask task = null;
    private boolean threadSuspended = true;
    private volatile Thread blinker;
    private Shell parentShell;
    PreviewTimerTask timeTask = null;
    private IDataServiceProvider dataProvider;
    private boolean hasDataEngine = false;
    private static final int DELAY_TIME = 2000;
    public static final String PARAM_CHART_MODEL = "Chart Model";
    private volatile boolean initFinished = false;

    public ChartLivePreviewThread() {
        this.setName("Chart live preview thread");
    }

    public ChartLivePreviewThread(IDataServiceProvider provider) {
        this.setName("Chart live preview thread");
        this.dataProvider = provider;
    }

    public void setParentShell(Shell shell) {
        this.parentShell = shell;
    }

    @Override
    public void start() {
        this.blinker = this;
        super.start();
        int i = 1;
        while (!this.initFinished && i < 6) {
            try {
                Thread.sleep(i * 10);
                ++i;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void end() {
        this.blinker = null;
        this.interrupt();
    }

    public synchronized void add(LivePreviewTask atask) {
        this.task = atask;
        this.threadSuspended = false;
        this.notify();
    }

    private synchronized LivePreviewTask remove() {
        LivePreviewTask tp = this.task;
        this.task = null;
        this.threadSuspended = true;
        return tp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.initDataEngine();
        this.initFinished = true;
        super.run();
        Timer fPaintTimer = null;
        this.timeTask = null;
        Thread thisThread = Thread.currentThread();
        while (this.blinker == thisThread) {
            block19: {
                LivePreviewTask tp;
                block18: {
                    tp = null;
                    ChartLivePreviewThread chartLivePreviewThread = this;
                    synchronized (chartLivePreviewThread) {
                        while (this.threadSuspended) {
                            this.wait();
                        }
                        tp = this.remove();
                    }
                    if (this.hasDataEngine) break block18;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            WizardBase.showException((String)Messages.getString("ChartLivePreviewThread.ErrorMessage.NoDataEngine"));
                        }
                    });
                    if (fPaintTimer != null) {
                        fPaintTimer.cancel();
                    }
                    if (this.timeTask == null) continue;
                    this.timeTask.dispose();
                    continue;
                }
                try {
                    try {
                        fPaintTimer = new Timer();
                        this.timeTask = new PreviewTimerTask(tp.getName(), this.parentShell);
                        fPaintTimer.schedule((TimerTask)this.timeTask, 2000L);
                        if (tp == null) break block19;
                        Map<String, Object> parameters = null;
                        LivePreviewTask[] livePreviewTaskArray = tp.getTasks();
                        int n = livePreviewTaskArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            LivePreviewTask lpt = livePreviewTaskArray[n2];
                            if (this.blinker == thisThread) {
                                if (parameters != null) {
                                    lpt.setParameters(parameters);
                                }
                                lpt.run();
                                parameters = lpt.getParameters();
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        if (fPaintTimer != null) {
                            fPaintTimer.cancel();
                        }
                        if (this.timeTask == null) continue;
                        this.timeTask.dispose();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (fPaintTimer != null) {
                        fPaintTimer.cancel();
                    }
                    if (this.timeTask != null) {
                        this.timeTask.dispose();
                    }
                    throw throwable;
                }
            }
            if (fPaintTimer != null) {
                fPaintTimer.cancel();
            }
            if (this.timeTask == null) continue;
            this.timeTask.dispose();
        }
        this.disposeDataEngine();
    }

    private void initDataEngine() {
        if (this.dataProvider != null) {
            try {
                this.dataProvider.initialize();
                this.hasDataEngine = true;
            }
            catch (ChartException e) {
                ChartException exp = e;
                Display.getDefault().asyncExec(new Runnable((Exception)((Object)exp)){
                    private final /* synthetic */ Exception val$exp;
                    {
                        this.val$exp = exception;
                    }

                    @Override
                    public void run() {
                        WizardBase.displayException((Throwable)this.val$exp);
                    }
                });
            }
        }
    }

    private void disposeDataEngine() {
        if (this.dataProvider != null) {
            this.dataProvider.dispose();
        }
    }

    static class PreviewTimerTask
    extends TimerTask {
        static ImageLoader loader;
        static ImageData[] imageDatas;
        Shell parentShell = null;
        Shell shell = null;
        private String taskName;

        PreviewTimerTask(String taskName, Shell parentShell) throws IOException {
            this.taskName = taskName;
            this.parentShell = parentShell;
            if (imageDatas == null) {
                loader = new ImageLoader();
                imageDatas = loader.load(UIHelper.getURL((String)"icons/obj16/progress_animation.gif").openStream());
            }
        }

        @Override
        public void run() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Display display = null;
                    if (parentShell != null && !parentShell.isDisposed()) {
                        shell = new Shell(parentShell, 16384);
                        display = shell.getDisplay();
                    } else {
                        display = Display.getDefault();
                        parentShell = display.getActiveShell();
                        shell = new Shell(display, 16384);
                    }
                    ImageViewer ic = new ImageViewer((Composite)shell, 0x140000);
                    Label l = new Label((Composite)shell, 0);
                    l.setText(taskName + Messages.getString("ChartLivePreviewThread_Text.PleaseWait"));
                    GridLayout gl = new GridLayout();
                    gl.numColumns = 2;
                    gl.marginLeft = 20;
                    gl.marginRight = 20;
                    gl.marginTop = 20;
                    gl.marginBottom = 20;
                    shell.setLayout((Layout)gl);
                    ic.setImages(imageDatas, PreviewTimerTask.loader.repeatCount);
                    ic.pack();
                    shell.pack();
                    Rectangle parentBounds = parentShell.getBounds();
                    Rectangle shellBounds = shell.getBounds();
                    shell.setLocation(parentBounds.x + (parentBounds.width - shellBounds.width) / 2, parentBounds.y + (parentBounds.height - shellBounds.height) / 2);
                    shell.open();
                    while (!shell.isDisposed()) {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                }
            });
        }

        public void dispose() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (shell != null) {
                            shell.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

