/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.providers.IBreadcrumbNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.ISelectionFilter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.CellBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.CellFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.util.bidi.BidiUIUtils;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabGraphicsFactory;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabTableEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editpolicies.CrosstabCellContainerEditPolicy;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editpolicies.CrosstabCellFlowLayoutEditPolicy;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.figures.CrosstabCellFigure;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.handles.CrosstavCellDragHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.views.provider.CrosstabCellBreadcrumbNodeProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;

public class CrosstabCellEditPart
extends AbstractCellEditPart {
    private List handles = null;

    public CrosstabCellEditPart(Object model) {
        super(model);
    }

    protected List getModelChildren() {
        return this.getCrosstabCellAdapter().getModelList();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest deleteRequest) {
                return UnexecutableCommand.INSTANCE;
            }

            protected Command getOrphanCommand() {
                return new Command(){};
            }
        });
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new CrosstabCellFlowLayoutEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new CrosstabCellContainerEditPolicy());
    }

    public void refreshFigure() {
        CellBorder cborder = new CellBorder();
        if (this.getFigure().getBorder() instanceof CellBorder) {
            cborder.setBorderInsets(((CellBorder)this.getFigure().getBorder()).getBorderInsets());
        }
        this.refreshBorder(this.getCrosstabCellAdapter().getDesignElementHandle(), (BaseBorder)cborder);
        this.refreshBackground(this.getCrosstabCellAdapter().getDesignElementHandle());
        ((CellFigure)this.getFigure()).setDirectionRTL(BidiUIUtils.INSTANCE.isDirectionRTL(this.getModel()));
        if (this.getCrosstabCellAdapter().getDesignElementHandle() != null) {
            this.setTextAliment(this.getCrosstabCellAdapter().getDesignElementHandle().getPrivateStyle());
        }
    }

    public void activate() {
        if (this.handles == null) {
            this.handles = this.getHandleList();
        }
        IFigure layer = this.getLayer("Handle Layer");
        int size = this.handles.size();
        int i = 0;
        while (i < size) {
            Figure handle = (Figure)this.handles.get(i);
            layer.add((IFigure)handle);
            ++i;
        }
        super.activate();
    }

    public void deactivate() {
        IFigure layer = this.getLayer("Handle Layer");
        int size = this.handles.size();
        int i = 0;
        while (i < size) {
            Figure handle = (Figure)this.handles.get(i);
            layer.remove((IFigure)handle);
            ++i;
        }
        super.deactivate();
    }

    protected List getHandleList() {
        ArrayList<CrosstavCellDragHandle> retValue = new ArrayList<CrosstavCellDragHandle>();
        CrosstabTableEditPart parent = (CrosstabTableEditPart)this.getParent();
        int columnNumner = parent.getColumnCount();
        int rowNumer = parent.getRowCount();
        if (this.getColumnNumber() + this.getColSpan() - 1 < columnNumner) {
            column = new CrosstavCellDragHandle(this, 16, this.getColumnNumber() + this.getColSpan() - 1, this.getColumnNumber() + this.getColSpan());
            retValue.add(column);
        } else {
            column = new CrosstavCellDragHandle(this, 16, this.getColumnNumber() + this.getColSpan() - 1, this.getColumnNumber() + this.getColSpan() - 1);
            retValue.add(column);
        }
        if (this.getRowNumber() + this.getRowSpan() - 1 < rowNumer) {
            row = new CrosstavCellDragHandle(this, 4, this.getRowNumber() + this.getRowSpan() - 1, this.getRowNumber() + this.getRowSpan());
            retValue.add(row);
        } else {
            row = new CrosstavCellDragHandle(this, 4, this.getRowNumber() + this.getRowSpan() - 1, this.getRowNumber() + this.getRowSpan() - 1);
            retValue.add(row);
        }
        return retValue;
    }

    protected IFigure createFigure() {
        CrosstabCellFigure figure = new CrosstabCellFigure();
        ReportFlowLayout rflayout = new ReportFlowLayout();
        figure.setLayoutManager((LayoutManager)rflayout);
        figure.setOpaque(false);
        return figure;
    }

    protected CrosstabCellAdapter getCrosstabCellAdapter() {
        return (CrosstabCellAdapter)this.getModel();
    }

    public int getColSpan() {
        return this.getCrosstabCellAdapter().getColumnSpan();
    }

    public int getColumnNumber() {
        return this.getCrosstabCellAdapter().getColumnNumber();
    }

    public int getRowNumber() {
        return this.getCrosstabCellAdapter().getRowNumber();
    }

    public int getRowSpan() {
        return this.getCrosstabCellAdapter().getRowSpan();
    }

    protected EditPart createChild(Object model) {
        EditPart part = CrosstabGraphicsFactory.INSTANCEOF.createEditPart((EditPart)this, model);
        if (part != null) {
            return part;
        }
        return super.createChild(model);
    }

    public Object getAdapter(Class key) {
        if (key == ISelectionFilter.class) {
            return new ISelectionFilter(){

                public List filterEditpart(List editparts) {
                    int size = editparts.size();
                    ArrayList copy = new ArrayList(editparts);
                    boolean hasCell = false;
                    boolean hasOther = false;
                    int i = 0;
                    while (i < size) {
                        if (editparts.get(i) instanceof CrosstabCellEditPart) {
                            hasCell = true;
                        } else {
                            hasOther = true;
                        }
                        ++i;
                    }
                    if (hasCell && hasOther) {
                        i = 0;
                        while (i < size) {
                            if (editparts.get(i) instanceof CrosstabCellEditPart) {
                                copy.remove(editparts.get(i));
                            }
                            ++i;
                        }
                    }
                    editparts = copy;
                    return editparts;
                }
            };
        }
        if (key == IBreadcrumbNodeProvider.class) {
            return new CrosstabCellBreadcrumbNodeProvider();
        }
        return super.getAdapter(key);
    }

    protected void contentChange(Map info) {
        ((ReportElementEditPart)this.getParent()).refresh();
        if (this.getParent() != null) {
            super.contentChange(info);
        }
    }

    public void showTargetFeedback(Request request) {
        if (this.getSelected() == 0 && this.isActive() && request.getType() == "selection") {
            if (this.isFigureLeft(request)) {
                this.getViewer().setCursor(ReportPlugin.getDefault().getLeftCellCursor());
            } else {
                this.getViewer().setCursor(ReportPlugin.getDefault().getRightCellCursor());
            }
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (this.isActive()) {
            this.getViewer().setCursor(null);
        }
        super.eraseTargetFeedback(request);
    }

    public boolean isinterestSelection(Object object) {
        if (object instanceof DesignElementHandle) {
            return this.getCrosstabCellAdapter().getCrosstabCellHandle().getModelHandle() == object;
        }
        return super.isinterestSelection(object);
    }

    public boolean isFixLayout() {
        return ((CrosstabTableEditPart)this.getParent()).isFixLayout();
    }
}

