/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.util.CopyUtil;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.gef.commands.Command;

public class CrosstabPasterCommand
extends Command {
    private DesignElementHandle sourceHandle;
    private IElementCopy cloneElement;
    private DesignElementHandle newContainer;
    private DesignElementHandle afterHandle;
    private int position = -1;
    private String contentName = null;

    public CrosstabPasterCommand(DesignElementHandle sourceHandle, DesignElementHandle newContainer, DesignElementHandle afterHandle) {
        this.sourceHandle = sourceHandle;
        this.cloneElement = CopyUtil.copy((DesignElementHandle)sourceHandle);
        this.newContainer = newContainer;
        this.afterHandle = afterHandle;
    }

    public boolean canExecute() {
        DesignElementHandle childHandle = this.sourceHandle;
        return DNDUtil.handleValidateTargetCanContain((Object)this.newContainer, (Object)childHandle) && DNDUtil.handleValidateTargetCanContainMore((Object)this.newContainer, (int)1);
    }

    public void execute() {
        try {
            this.calculatePositionAndSlotId();
            CopyUtil.paste((IElementCopy)this.cloneElement, (DesignElementHandle)this.newContainer, (String)this.getContentName(), (int)this.position);
        }
        catch (Exception e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("PasteCommand >> Failed.");
            }
            ExceptionUtil.handle((Throwable)e);
        }
    }

    private void calculatePositionAndSlotId() {
        if (this.contentName == null) {
            this.contentName = DEUtil.getDefaultContentName((Object)this.newContainer);
        }
        this.position = DEUtil.findInsertPosition((DesignElementHandle)this.newContainer, (DesignElementHandle)this.afterHandle, (String)this.getContentName());
    }

    public String getContentName() {
        return this.contentName;
    }

    public void setContentName(String contentName) {
        this.contentName = contentName;
    }
}

