/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.ResetAttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderColorDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderStyleDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderToggleDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderWidthDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.BorderSection;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BordersPage
extends ResetAttributePage {
    private static final String[] styles = new String[]{"solid", "dotted", "dashed", "double"};
    BorderToggleDescriptorProvider[] providers;
    private static final String LABEL_BORDER = Messages.getString((String)"BordersPage.Label.Borders");
    private BorderSection borderSection;

    @Override
    public void buildUI(Composite parent) {
        super.buildUI(parent);
        this.container.setLayout((Layout)WidgetUtil.createGridLayout((int)1, (int)15));
        this.providers = this.input != null && ((List)this.input).size() >= 1 && ((List)this.input).get(0) instanceof CellHandle ? new BorderToggleDescriptorProvider[]{new BorderToggleDescriptorProvider("borderTopStyle"), new BorderToggleDescriptorProvider("borderBottomStyle"), new BorderToggleDescriptorProvider("borderLeftStyle"), new BorderToggleDescriptorProvider("borderRightStyle"), new BorderToggleDescriptorProvider("diagonalStyle"), new BorderToggleDescriptorProvider("antidiagonalStyle")} : new BorderToggleDescriptorProvider[]{new BorderToggleDescriptorProvider("borderTopStyle"), new BorderToggleDescriptorProvider("borderBottomStyle"), new BorderToggleDescriptorProvider("borderLeftStyle"), new BorderToggleDescriptorProvider("borderRightStyle")};
        this.borderSection = new BorderSection(LABEL_BORDER, this.container, true);
        BorderStyleDescriptorProvider styleProvider = new BorderStyleDescriptorProvider();
        styleProvider.setItems(styles);
        this.borderSection.setStyleProvider(styleProvider);
        BorderColorDescriptorProvider colorProvider = new BorderColorDescriptorProvider();
        this.borderSection.setColorProvider(colorProvider);
        BorderWidthDescriptorProvider widthProvider = new BorderWidthDescriptorProvider();
        this.borderSection.setWidthProvider(widthProvider);
        int i = 0;
        while (i < this.providers.length) {
            this.providers[i].enableReset(true);
            ++i;
        }
        this.borderSection.setToggleProviders(this.providers);
        this.addSection("BORDERS_BORDER_STYLE", this.borderSection);
        this.createSections();
        this.layoutSections();
    }

    private boolean checkControl(BorderSection border) {
        return border != null && border.getBorderControl() != null && !border.getBorderControl().getControl().isDisposed();
    }

    @Override
    public void postElementEvent() {
        if (this.checkControl(this.borderSection)) {
            this.borderSection.getBorderControl().postElementEvent();
        }
    }
}

