/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.internal.impl;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.eclipse.birt.data.oda.mongodb.impl.MDbResultSet;
import org.eclipse.birt.data.oda.mongodb.impl.MDbResultSetMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbOperation;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class QueryModel {
    private static final int DEFAULT_RUNTIME_METADATA_SEARCH_LIMIT = 10;
    static final String DOC_ID_FIELD_NAME = "_id";
    private static final String GROUP_AGGR_KEY = "$group";
    private static final String SORT_AGGR_KEY = "$sort";
    private static final String EVAL_KEY = "eval";
    private static final String NOLOCK_KEY = "nolock";
    static final String MAP_REDUCE_MAP_FUNCTION = "map";
    static final String MAP_REDUCE_REDUCE_FUNCTION = "reduce";
    private static final String[] REQUIRED_MAPREDUCE_KEYS = new String[]{"map", "reduce", "out"};
    static final String MAP_REDUCE_CMD_KEY = "mapreduce";
    static final String MAP_REDUCE_CMD_KEY2 = "mapReduce";
    private static final String[] SUPPORTED_DB_COMMANDS = new String[]{"buildInfo", "collStats", "connPoolStats", "count", "cursorInfo", "dataSize", "dbStats", "distinct", "eval", "geoNear", "geoSearch", "getLastError", "getLog", "getPrevError", "group", "isMaster", "isdbgrid", "listCommands", "listDatabases", "listShards", "ping", "printShardingStatus", "replSetGetStatus", "serverStatus"};
    private QueryProperties m_queryProps;
    private MongoDatabase m_connectedDB;
    private MongoCollection<Document> m_dbCollection;
    private Integer m_metaDataSearchLimit;
    private MDbOperation m_operation;

    public QueryModel(QueryProperties queryProps, MongoDatabase connectedDB) throws OdaException {
        if (connectedDB == null) {
            throw new OdaException((Throwable)new IllegalArgumentException("null com.mongodb.DB"));
        }
        this.m_connectedDB = connectedDB;
        this.m_queryProps = queryProps;
        this.initialize();
    }

    public void addQuerySpec(QuerySpecification querySpec) {
        if (querySpec == null) {
            return;
        }
        this.m_queryProps.setNonNullValues(querySpec.getProperties());
    }

    private void initialize() throws OdaException {
        if (this.m_queryProps == null || this.m_queryProps.getPropertiesMap().isEmpty()) {
            throw new OdaException(Messages.queryModel_missingQueryProps);
        }
        if (!this.m_queryProps.hasRunCommand()) {
            String collectionName = this.m_queryProps.getCollectionName();
            if (collectionName == null || collectionName.isEmpty()) {
                throw new OdaException(Messages.queryModel_missingCollectionName);
            }
            MDbMetaData metadataUtil = new MDbMetaData(this.m_connectedDB);
            this.m_dbCollection = metadataUtil.getCollection(collectionName);
            if (this.m_dbCollection == null) {
                throw new OdaException(Messages.bind((String)Messages.queryModel_invalidCollectionName, (Object)collectionName));
            }
        }
    }

    public boolean isValid() {
        return this.m_dbCollection != null || this.m_queryProps.hasRunCommand() && this.m_connectedDB != null;
    }

    QueryProperties getQueryProperties() {
        return this.m_queryProps;
    }

    MongoDatabase getConnectedDB() {
        return this.m_connectedDB;
    }

    MongoCollection<Document> getCollection() {
        return this.m_dbCollection;
    }

    private boolean isPrepared() {
        return this.m_operation != null;
    }

    public MDbResultSetMetaData getResultSetMetaData() throws OdaException {
        if (!this.isPrepared()) {
            this.prepare();
        }
        return this.m_operation.getResultSetMetaData();
    }

    private void prepare() throws OdaException {
        if (!this.isValid()) {
            throw new OdaException(Messages.queryModel_invalidModelToPrepare);
        }
        this.m_operation = MDbOperation.createQueryOperation(this);
        this.m_operation.prepare(this.m_dbCollection);
    }

    public MDbResultSet execute() throws OdaException {
        if (!this.isValid()) {
            throw new OdaException(Messages.queryModel_invalidModelToExec);
        }
        if (!this.isPrepared()) {
            this.prepare();
        }
        return this.m_operation.execute();
    }

    private int getMetaDataSearchLimit() {
        if (this.m_metaDataSearchLimit == null) {
            return 10;
        }
        return this.m_metaDataSearchLimit;
    }

    int getEffectiveMDSearchLimit(QueryProperties queryProps) {
        Integer searchLimit = queryProps.getRuntimeMetaDataSearchLimit();
        if (searchLimit == null || searchLimit < 0 || searchLimit == 10) {
            searchLimit = this.getMetaDataSearchLimit();
        }
        return searchLimit;
    }

    public void setMetaDataSearchLimit(int searchLimit) {
        if (searchLimit > 0) {
            this.m_metaDataSearchLimit = searchLimit;
        }
    }

    public String getEffectiveQueryText() {
        if (!this.isPrepared()) {
            return "";
        }
        QueryProperties effectiveProps = this.m_operation.getEffectiveProperties();
        return effectiveProps != null ? effectiveProps.serialize() : "";
    }

    private static final DBObject parseExprToDBObject(String jsonExpr) throws OdaException {
        return DriverUtil.parseExprToDBObject(jsonExpr);
    }

    public static void validateQuerySyntax(String queryExpr) throws OdaException {
        if (queryExpr == null) {
            return;
        }
        QueryModel.parseExprToDBObject(queryExpr.trim());
    }

    public static void validateSortExprSyntax(String sortExpr) throws OdaException {
        if (sortExpr == null) {
            return;
        }
        DBObject parsedSortObj = QueryModel.parseExprToDBObject(sortExpr.trim());
        if (parsedSortObj instanceof BasicDBObject) {
            BasicDBObject sortExprObj = (BasicDBObject)parsedSortObj;
            for (Object sortKeySpec : sortExprObj.values()) {
                if (sortKeySpec instanceof Number) continue;
                throw new OdaException(Messages.bind((String)Messages.queryModel_invalidQuerySortExpr, (Object)sortExpr));
            }
        }
    }

    public static void validateCommandSyntax(QueryProperties.CommandOperationType cmdOp, String commandExpr) throws OdaException {
        if (cmdOp != QueryProperties.CommandOperationType.AGGREGATE && cmdOp != QueryProperties.CommandOperationType.MAP_REDUCE && cmdOp != QueryProperties.CommandOperationType.RUN_DB_COMMAND || commandExpr == null) {
            return;
        }
        if ((commandExpr = commandExpr.trim()).isEmpty()) {
            return;
        }
        if (cmdOp == QueryProperties.CommandOperationType.AGGREGATE) {
            commandExpr = QueryProperties.addArrayMarkers(commandExpr);
        }
        DBObject parsedCmdObj = QueryModel.parseExprToDBObject(commandExpr);
        if (cmdOp == QueryProperties.CommandOperationType.MAP_REDUCE) {
            QueryModel.validateMapReduceCommand(parsedCmdObj);
        } else if (cmdOp == QueryProperties.CommandOperationType.AGGREGATE) {
            QueryModel.validateAggregateCommand(parsedCmdObj);
        } else if (cmdOp == QueryProperties.CommandOperationType.RUN_DB_COMMAND) {
            QueryModel.validateDBCommand(parsedCmdObj);
        }
    }

    private static void validateMapReduceCommand(DBObject commandObj) throws OdaException {
        int i = 0;
        while (i < REQUIRED_MAPREDUCE_KEYS.length) {
            String requiredKey = REQUIRED_MAPREDUCE_KEYS[i];
            if (!commandObj.containsField(requiredKey)) {
                throw new OdaException(Messages.bind((String)Messages.queryModel_missingMapReduceKey, (Object)requiredKey));
            }
            if (commandObj.get(requiredKey) == null) {
                throw new OdaException(Messages.bind((String)Messages.queryModel_missingMapReduceValue, (Object)requiredKey));
            }
            ++i;
        }
    }

    private static void validateAggregateCommand(DBObject commandObj) throws OdaException {
        List<BasicDBObject> groupOps = QueryModel.findPipelineOperation(commandObj, GROUP_AGGR_KEY);
        for (BasicDBObject groupOp : groupOps) {
            if (groupOp.containsField(DOC_ID_FIELD_NAME)) continue;
            throw new OdaException(Messages.bind((String)Messages.queryModel_missingGroupAggrKey, (Object[])new Object[]{GROUP_AGGR_KEY, DOC_ID_FIELD_NAME, groupOp}));
        }
        List<BasicDBObject> sortOps = QueryModel.findPipelineOperation(commandObj, SORT_AGGR_KEY);
        for (BasicDBObject sortOp : sortOps) {
            for (Object sortKeySpec : sortOp.values()) {
                int sortKeyValue;
                if (sortKeySpec instanceof Number && ((sortKeyValue = ((Number)sortKeySpec).intValue()) == 1 || sortKeyValue == -1)) continue;
                throw new OdaException(Messages.bind((String)Messages.queryModel_invalidSortAggrValue, (Object)SORT_AGGR_KEY, (Object)sortOp));
            }
        }
    }

    private static List<BasicDBObject> findPipelineOperation(DBObject commandObj, String operator) throws OdaException {
        ArrayList<BasicDBObject> foundOps = new ArrayList<BasicDBObject>(2);
        if (commandObj instanceof BasicDBObject) {
            BasicDBObject foundOp = QueryModel.findOperation((BasicDBObject)commandObj, operator);
            if (foundOp != null) {
                foundOps.add(foundOp);
            }
        } else if (commandObj instanceof BasicDBList) {
            BasicDBList ops = (BasicDBList)commandObj;
            for (Object op : ops) {
                if (!(op instanceof DBObject)) {
                    if (String.valueOf(op).isEmpty()) {
                        op = Messages.queryModel_emptyExprErrorMsg;
                    }
                    throw new OdaException(Messages.bind((String)Messages.queryModel_invalidPipelineOp, op));
                }
                List<BasicDBObject> foundOpsInElement = QueryModel.findPipelineOperation((DBObject)op, operator);
                if (foundOpsInElement.isEmpty()) continue;
                foundOps.addAll(foundOpsInElement);
            }
        }
        return foundOps;
    }

    private static BasicDBObject findOperation(BasicDBObject opObj, String operator) {
        if (opObj == null) {
            return null;
        }
        Object op = opObj.get(operator);
        return op instanceof BasicDBObject ? (BasicDBObject)op : null;
    }

    private static void validateDBCommand(DBObject commandObj) throws OdaException {
        boolean noLockValue;
        boolean hasSupportedCommand = false;
        int i = 0;
        while (i < SUPPORTED_DB_COMMANDS.length) {
            String supportedCommand = SUPPORTED_DB_COMMANDS[i];
            if (commandObj.containsField(supportedCommand) || commandObj.containsField(supportedCommand.toLowerCase())) {
                hasSupportedCommand = true;
                break;
            }
            ++i;
        }
        if (!hasSupportedCommand) {
            throw new OdaException(Messages.bind((String)Messages.queryModel_nonSupportedDbCmd, (Object)commandObj.toString()));
        }
        if (commandObj.containsField(EVAL_KEY) && !(noLockValue = QueryModel.getBooleanValueOfKey(commandObj, NOLOCK_KEY, false))) {
            throw new OdaException(Messages.bind((String)Messages.queryModel_invalidDbCmdKeyValue, (Object)EVAL_KEY, (Object)"{nolock : true}"));
        }
    }

    private static boolean getBooleanValueOfKey(DBObject commandObj, String keyName, boolean defaultValue) {
        Object value = commandObj.get(keyName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() > 0;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }
}

