/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editor.pages.script;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.editors.script.IScriptEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSEditor;
import org.eclipse.birt.report.designer.ui.editor.script.DecoratedScriptEditor;
import org.eclipse.birt.report.designer.ui.editor.script.IDebugScriptEditor;
import org.eclipse.birt.report.designer.ui.editor.script.ScriptDocumentProvider;
import org.eclipse.birt.report.designer.ui.editors.IReportScriptLocation;
import org.eclipse.birt.report.designer.ui.editors.pages.ReportScriptFormPage;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.CommandNotMappedException;
import org.eclipse.ui.actions.ContributedAction;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;

public class DecoratedScriptFormPage
extends ReportScriptFormPage {
    private static final String TAG_CONTRIBUTION_TYPE = "editorContribution";
    private static final String ID = "org.eclipse.birt.report.designer.ui.editor.script.DecoratedScriptEditor";

    protected IEditorPart createJSEditor() {
        return new DebugJSEditor((IEditorPart)this);
    }

    private class DebugJSEditor
    extends JSEditor {
        public DebugJSEditor(IEditorPart parent) {
            super(parent);
        }

        public void createPartControl(Composite parent) {
            super.createPartControl(parent);
            this.hideValidateButtonIcon();
        }

        protected IScriptEditor createScriptEditor() {
            return new ReportDecoratedScriptEditor(this.getParentEditor());
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IReportScriptLocation.class) {
                final PropertyHandle handle = this.getPropertyHandle();
                if (handle == null) {
                    return null;
                }
                return new IReportScriptLocation(){

                    public String getID() {
                        return ModuleUtil.getScriptUID((Object)handle);
                    }

                    public int getLineNumber() {
                        return -1;
                    }

                    public String getReportFileName() {
                        return handle.getElementHandle().getModuleHandle().getFileName();
                    }

                    public String getDisplayName() {
                        return DEUtil.getFlatHirarchyPathName((Object)handle.getElementHandle()) + "." + handle.getDefn().getName();
                    }
                };
            }
            return super.getAdapter(adapter);
        }

        protected void setEditorText(String text) {
            PropertyHandle handle = this.getPropertyHandle();
            if (this.getScriptEditor() instanceof IDebugScriptEditor) {
                ((IDebugScriptEditor)this.getScriptEditor()).beforeChangeContents(handle);
            }
            super.setEditorText(text);
            if (this.getScriptEditor() instanceof IDebugScriptEditor) {
                ((IDebugScriptEditor)this.getScriptEditor()).updateScipt(handle);
            }
        }

        public void doSave(IProgressMonitor monitor, boolean chnageText) {
            super.doSave(monitor, chnageText);
            if (this.getScriptEditor() instanceof IDebugScriptEditor) {
                ((IDebugScriptEditor)this.getScriptEditor()).saveDocument();
            }
        }

        public void doSave(IProgressMonitor monitor) {
            super.doSave(monitor);
            if (this.getScriptEditor() instanceof IDebugScriptEditor) {
                ((IDebugScriptEditor)this.getScriptEditor()).saveDocument();
            }
        }

        protected IScriptEditor getScriptEditor() {
            return super.getScriptEditor();
        }
    }

    private class ReportDecoratedScriptEditor
    extends DecoratedScriptEditor
    implements IDebugScriptEditor {
        private String fileName;

        public ReportDecoratedScriptEditor(IEditorPart parent) {
            super(parent);
            this.fileName = "";
            this.setRulerContextMenuId("#ReportScriptRulerContext");
        }

        public IAction getAction(String actionID) {
            IAction action = super.getAction(actionID);
            if (action == null && (action = this.findContributedAction(actionID)) != null) {
                this.setAction(actionID, action);
            }
            return action;
        }

        private IAction findContributedAction(String actionID) {
            Object element;
            ArrayList<IConfigurationElement> actions = new ArrayList<IConfigurationElement>();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "editorActions");
            int i = 0;
            while (i < elements.length) {
                element = elements[i];
                if (DecoratedScriptFormPage.TAG_CONTRIBUTION_TYPE.equals(element.getName()) && DecoratedScriptFormPage.ID.equals(element.getAttribute("targetID"))) {
                    IConfigurationElement[] children = element.getChildren("action");
                    int j = 0;
                    while (j < children.length) {
                        IConfigurationElement child = children[j];
                        if (actionID.equals(child.getAttribute("actionID"))) {
                            actions.add(child);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            int actionSize = actions.size();
            if (actionSize > 0) {
                if (actionSize > 1) {
                    Object[] actionArray = actions.toArray(new IConfigurationElement[actionSize]);
                    ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                        public IConfigurationElement getConfigurationElement(Object object) {
                            return (IConfigurationElement)object;
                        }
                    };
                    sorter.sort(actionArray);
                    element = actionArray[0];
                } else {
                    element = (IConfigurationElement)actions.get(0);
                }
                try {
                    return new ContributedAction((IServiceLocator)this.getSite(), element);
                }
                catch (CommandNotMappedException commandNotMappedException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IReportScriptLocation.class) {
                IEditorPart parent = this.getParent();
                return parent == null ? null : parent.getAdapter(adapter);
            }
            return super.getAdapter(adapter);
        }

        @Override
        public void updateScipt(PropertyHandle handle) {
            ScriptDocumentProvider provider = (ScriptDocumentProvider)this.getDocumentProvider();
            provider.update(provider.getAnnotationModel(this.getEditorInput()));
            ((ScriptDocumentProvider.DebugResourceMarkerAnnotationModel)provider.getAnnotationModel(this.getEditorInput())).resetReportMarkers();
        }

        @Override
        public void beforeChangeContents(PropertyHandle handle) {
            ScriptDocumentProvider provider = (ScriptDocumentProvider)this.getDocumentProvider();
            String id = ModuleUtil.getScriptUID((Object)handle);
            boolean isSame = provider.getId().equals(id);
            if (!isSame) {
                DecoratedScriptFormPage.this.jsEditor.doSave(null);
            }
            if (id == null) {
                provider.setId("");
            } else {
                provider.setId(id);
            }
            provider.setSameElement(isSame);
            if (handle != null) {
                provider.setFileName(handle.getElementHandle().getModuleHandle().getFileName());
            }
            ((ScriptDocumentProvider.DebugResourceMarkerAnnotationModel)provider.getAnnotationModel(this.getEditorInput())).beforeChangeText();
        }
    }
}

