/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IOutsideBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ShowDragInfomationProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableDragGuideTracker;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.ResizeTracker;

public class ReportResizeTracker
extends ResizeTracker {
    private ShowDragInfomationProcessor processor;

    public ReportResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
        if (16 == direction || 4 == direction) {
            this.processor = new ShowDragInfomationProcessor((EditPart)owner);
        }
    }

    protected void showSourceFeedback() {
        super.showSourceFeedback();
        if (this.processor != null) {
            int pix = 0;
            if (16 == this.getResizeDirection()) {
                pix = this.getFigureSize().width;
            } else if (4 == this.getResizeDirection()) {
                pix = this.getFigureSize().height;
            }
            this.processor.getInfomationLabel(this.getInfomation(pix), this.getStartLocation()).setText(this.getInfomation(pix));
        }
    }

    private Dimension getFigureSize() {
        IFigure figure = this.getOwner().getFigure();
        Dimension dim = figure.getSize();
        if (figure instanceof IOutsideBorder) {
            Border border = ((IOutsideBorder)figure).getOutsideBorder();
            Insets insets = border.getInsets(figure);
            if (16 == this.getResizeDirection()) {
                dim.width = dim.width - insets.right - insets.left;
            } else if (4 == this.getResizeDirection()) {
                dim.height = dim.height - insets.bottom - insets.top;
            }
        }
        return dim;
    }

    protected boolean handleButtonDown(int button) {
        boolean bool = super.handleButtonDown(button);
        if (button == 1) {
            this.showSourceFeedback();
        }
        return bool;
    }

    protected void eraseSourceFeedback() {
        super.eraseSourceFeedback();
        if (this.processor != null) {
            this.processor.removeLabelFigue();
        }
    }

    protected boolean handleDragInProgress() {
        boolean bool = super.handleDragInProgress();
        if (this.processor != null) {
            int width = 0;
            if (16 == this.getResizeDirection()) {
                width = this.getFigureSize().width + this.getMouseTrueValueX();
            } else if (4 == this.getResizeDirection()) {
                width = this.getFigureSize().height + this.getMouseTrueValueY();
            }
            if (width < 1) {
                width = 1;
            }
            this.processor.updateInfomation(this.getInfomation(width), this.getStartLocation());
        }
        return bool;
    }

    protected int getMouseTrueValueX() {
        int value = this.getLocation().x - this.getStartLocation().x;
        Dimension temp = new Dimension(value, 0);
        this.getOwner().getFigure().translateToRelative((Translatable)temp);
        value = temp.width;
        return value;
    }

    protected int getMouseTrueValueY() {
        int value = this.getLocation().y - this.getStartLocation().y;
        Dimension temp = new Dimension(value, 0);
        this.getOwner().getFigure().translateToRelative((Translatable)temp);
        value = temp.width;
        return value;
    }

    protected String getInfomation(int pix) {
        return this.getShowLabel(pix);
    }

    protected String getDefaultUnits() {
        Object model = this.getOwner().getModel();
        if (!(model instanceof DesignElementHandle)) {
            return "in";
        }
        ModuleHandle handle = ((DesignElementHandle)model).getModuleHandle();
        return handle.getDefaultUnits();
    }

    private String getShowLabel(int pix) {
        String unit = this.getDefaultUnits();
        double doubleValue = MetricUtility.pixelToPixelInch((int)pix);
        double showValue = DimensionUtil.convertTo((double)doubleValue, (String)"in", (String)unit).getMeasure();
        String prefix = "";
        if (16 == this.getResizeDirection()) {
            prefix = Messages.getString((String)"ColumnDragTracker.Show.Label");
        } else if (4 == this.getResizeDirection()) {
            prefix = Messages.getString((String)"RowDragTracker.Show.Label");
        }
        return prefix + " " + TableDragGuideTracker.FORMAT.format(showValue) + " " + TableDragGuideTracker.getUnitDisplayName(unit) + " (" + pix + " " + TableDragGuideTracker.PIXELS_LABEL + ")";
    }
}

