/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;

public class DeleteColumnHandler
extends SelectionHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        TableEditPart part = this.getTableEditPart();
        if (part != null) {
            EditPartViewer viewer = part.getViewer();
            part.deleteColumn(this.getColumnNumbers());
            viewer.select((EditPart)part);
        }
        return Boolean.TRUE;
    }

    public int[] getColumnNumbers() {
        List columnHandles = this.getColumnHandles();
        if (columnHandles.isEmpty()) {
            return new int[0];
        }
        int size = columnHandles.size();
        int[] colNumbers = new int[size];
        int i = 0;
        while (i < size) {
            colNumbers[i] = this.getColumnNumber(columnHandles.get(i));
            ++i;
        }
        int[] a = colNumbers;
        Arrays.sort(a);
        return a;
    }

    protected List getColumnHandles() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> columnHandles = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof DummyEditpart && ((DummyEditpart)obj).getModel() instanceof ColumnHandle) {
                columnHandles.add(((DummyEditpart)obj).getModel());
            }
            ++i;
        }
        return columnHandles;
    }

    public int getColumnNumber(Object columnHandle) {
        return HandleAdapterFactory.getInstance().getColumnHandleAdapter(columnHandle).getColumnNumber();
    }
}

