/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IAutoTextEventHandler;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.AutoText;
import org.eclipse.birt.report.engine.script.internal.instance.AutoTextInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class AutoTextScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(AutoTextHandle autoTextHandle, ExecutionContext context) {
        try {
            AutoText cell = new AutoText((ReportItemHandle)autoTextHandle);
            IAutoTextEventHandler eh = AutoTextScriptExecutor.getEventHandler(autoTextHandle, context);
            if (eh != null) {
                eh.onPrepare(cell, context.getReportContext());
            }
        }
        catch (Exception e) {
            AutoTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IAutoTextContent content, ExecutionContext context) {
        Object generateBy = content.getGenerateBy();
        if (generateBy == null) {
            return;
        }
        ReportItemDesign autoTextItemDesign = (ReportItemDesign)generateBy;
        try {
            if (!AutoTextScriptExecutor.needOnCreate(autoTextItemDesign)) {
                return;
            }
            AutoTextInstance autoText = new AutoTextInstance(content, context, RunningState.CREATE);
            if (AutoTextScriptExecutor.handleScript(autoText, autoTextItemDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IAutoTextEventHandler eh = AutoTextScriptExecutor.getEventHandler(autoTextItemDesign, context);
            if (eh != null) {
                eh.onCreate(autoText, context.getReportContext());
            }
        }
        catch (Exception e) {
            AutoTextScriptExecutor.addException(context, e, autoTextItemDesign.getHandle());
        }
    }

    public static void handleOnRender(IAutoTextContent content, ExecutionContext context) {
        Object generateBy = content.getGenerateBy();
        if (generateBy == null) {
            return;
        }
        ReportItemDesign autoTextDesign = (ReportItemDesign)generateBy;
        if (!AutoTextScriptExecutor.needOnRender(autoTextDesign)) {
            return;
        }
        try {
            AutoTextInstance autoText = new AutoTextInstance(content, context, RunningState.RENDER);
            if (AutoTextScriptExecutor.handleScript(autoText, autoTextDesign.getOnRender(), context).didRun()) {
                return;
            }
            IAutoTextEventHandler eh = AutoTextScriptExecutor.getEventHandler(autoTextDesign, context);
            if (eh != null) {
                eh.onRender(autoText, context.getReportContext());
            }
        }
        catch (Exception e) {
            AutoTextScriptExecutor.addException(context, e, autoTextDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(IAutoTextContent content, ExecutionContext context) {
        Object generateBy = content.getGenerateBy();
        if (generateBy == null) {
            return;
        }
        ReportItemDesign autoTextDesign = (ReportItemDesign)generateBy;
        try {
            if (!AutoTextScriptExecutor.needOnPageBreak(autoTextDesign, context)) {
                return;
            }
            AutoTextInstance autoText = new AutoTextInstance(content, context, RunningState.PAGEBREAK);
            if (AutoTextScriptExecutor.handleScript(autoText, autoTextDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IAutoTextEventHandler eh = AutoTextScriptExecutor.getEventHandler(autoTextDesign, context);
            if (eh != null) {
                eh.onPageBreak(autoText, context.getReportContext());
            }
        }
        catch (Exception e) {
            AutoTextScriptExecutor.addException(context, e, autoTextDesign.getHandle());
        }
    }

    private static IAutoTextEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (IAutoTextEventHandler)AutoTextScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            AutoTextScriptExecutor.addClassCastException(context, e, design.getHandle(), IAutoTextEventHandler.class);
        }
        catch (EngineException e) {
            AutoTextScriptExecutor.addException(context, (Exception)((Object)e), design.getHandle());
        }
        return null;
    }

    private static IAutoTextEventHandler getEventHandler(AutoTextHandle handle, ExecutionContext context) {
        try {
            return (IAutoTextEventHandler)AutoTextScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            AutoTextScriptExecutor.addClassCastException(context, e, (DesignElementHandle)handle, IAutoTextEventHandler.class);
        }
        catch (EngineException e) {
            AutoTextScriptExecutor.addException(context, (Exception)((Object)e), (DesignElementHandle)handle);
        }
        return null;
    }
}

