/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class StylePropertyMapping {
    protected static final HashMap<String, Integer> nameMapping = new HashMap();
    protected static IElementDefn styleDefn;

    static {
        nameMapping.put("fontFamily", 69);
        nameMapping.put("fontStyle", 55);
        nameMapping.put("fontVariant", 48);
        nameMapping.put("fontWeight", 47);
        nameMapping.put("fontSize", 54);
        nameMapping.put("color", 66);
        nameMapping.put("backgroundColor", 41);
        nameMapping.put("backgroundImage", 56);
        nameMapping.put("backgroundImageType", 58);
        nameMapping.put("backgroundRepeat", 24);
        nameMapping.put("backgroundAttachment", 68);
        nameMapping.put("backgroundPositionX", 51);
        nameMapping.put("backgroundPositionY", 62);
        nameMapping.put("wordSpacing", 42);
        nameMapping.put("letterSpacing", 70);
        nameMapping.put("textUnderline", 60);
        nameMapping.put("textOverline", 49);
        nameMapping.put("textLineThrough", 32);
        nameMapping.put("textDecoration", 40);
        nameMapping.put("verticalAlign", 43);
        nameMapping.put("textTransform", 28);
        nameMapping.put("textAlign", 37);
        nameMapping.put("textIndent", 26);
        nameMapping.put("lineHeight", 64);
        nameMapping.put("whiteSpace", 61);
        nameMapping.put("marginTop", 6);
        nameMapping.put("marginBottom", 2);
        nameMapping.put("marginLeft", 0);
        nameMapping.put("marginRight", 1);
        nameMapping.put("paddingTop", 19);
        nameMapping.put("paddingBottom", 13);
        nameMapping.put("paddingLeft", 12);
        nameMapping.put("paddingRight", 16);
        nameMapping.put("borderTopWidth", 35);
        nameMapping.put("borderBottomWidth", 10);
        nameMapping.put("borderLeftWidth", 59);
        nameMapping.put("borderRightWidth", 9);
        nameMapping.put("borderTopColor", 23);
        nameMapping.put("borderBottomColor", 5);
        nameMapping.put("borderLeftColor", 57);
        nameMapping.put("borderRightColor", 4);
        nameMapping.put("borderTopStyle", 45);
        nameMapping.put("borderBottomStyle", 21);
        nameMapping.put("borderLeftStyle", 65);
        nameMapping.put("borderRightStyle", 20);
        nameMapping.put("display", 63);
        nameMapping.put("orphans", 36);
        nameMapping.put("widows", 53);
        nameMapping.put("pageBreakAfter", 67);
        nameMapping.put("pageBreakBefore", 30);
        nameMapping.put("pageBreakInside", 52);
        nameMapping.put("masterPage", 44);
        nameMapping.put("showIfBlank", 46);
        nameMapping.put("canShrink", 34);
        nameMapping.put("numberAlign", 38);
        nameMapping.put("bidiTextDirection", 17);
        nameMapping.put("data-format", 3);
    }

    protected static IElementDefn getStyleDefn() {
        if (styleDefn != null) {
            return styleDefn;
        }
        styleDefn = MetaDataDictionary.getInstance().getElement("Style");
        assert (styleDefn != null);
        return styleDefn;
    }

    public static boolean canInherit(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.canInherit();
        }
        return false;
    }

    public static Object getDefaultValue(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.getDefault();
        }
        return null;
    }

    public static Object getDefaultValue(String name, ReportDesignHandle handle) {
        Object value = StylePropertyMapping.getDefaultValue(name);
        if (value == null && handle != null && handle.isDirectionRTL() && "bidiTextDirection".equals(name)) {
            return "rtl";
        }
        return value;
    }

    public static Object getDefaultValue(int index) {
        return StylePropertyMapping.getDefaultValue(nameMapping.get(index).toString());
    }

    public static int getPropertyID(String name) {
        int id = -1;
        Integer obj = nameMapping.get(name);
        if (obj instanceof Integer) {
            id = obj;
        }
        return id;
    }

    public static Set<?> getPropertyMapping() {
        return nameMapping.entrySet();
    }
}

