/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.ide.wizards.NewReportWizard;
import org.eclipse.birt.report.designer.ui.ide.wizards.WizardNewReportCreationPage;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public class NewTemplateWizard
extends NewReportWizard {
    private static final String WIZARDPAGE = Messages.getString((String)"NewTemplateWizard.title.WizardPage");
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewTemplateWizard.text.OpenFileForEditing");
    private static final String CREATING = Messages.getString((String)"NewTemplateWizard.text.Creating");
    private static final String NEW_TEMPLATE_FILE_NAME_PREFIX = Messages.getString((String)"NewTemplateWizard.displayName.NewReportFileNamePrefix");
    private static final String NEW_TEMPLATE_DESCRIPTION = Messages.getString((String)"NewTemplateWizard.pageDescription.createNewTemplate");
    private static final String NEW_TEMPLATE_TITLE = Messages.getString((String)"NewTemplateWizard.title.Template");
    private static final String SAVE_TEMPLATE_PROPERTIES_TITLE = Messages.getString((String)"SaveReportAsWizard.SettingPage.title");
    private static final String SAVE_TEMPLATE_PROPERTIES_MESSAGES = Messages.getString((String)"SaveReportAsWizard.SettingPage.Messages");

    public NewTemplateWizard() {
        super(".rpttemplate");
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Messages.getString((String)"NewTemplateWizard.title.New"));
    }

    @Override
    public void addPages() {
        this.newReportFileWizardPage = new WizardNewReportCreationPage(WIZARDPAGE, this.getSelection(), "rpttemplate");
        this.addPage((IWizardPage)this.newReportFileWizardPage);
        this.resetUniqueCount();
        this.newReportFileWizardPage.setFileName(this.getUniqueReportName(NEW_TEMPLATE_FILE_NAME_PREFIX, this.getFileExtension()));
        this.newReportFileWizardPage.setContainerFullPath(this.getDefaultContainerPath());
        this.newReportFileWizardPage.setDescription(NEW_TEMPLATE_DESCRIPTION);
        this.newReportFileWizardPage.setTitle(NEW_TEMPLATE_TITLE);
        this.settingPage = new WizardReportSettingPage(null);
        this.settingPage.setTitle(SAVE_TEMPLATE_PROPERTIES_TITLE);
        this.settingPage.setPageDesc(SAVE_TEMPLATE_PROPERTIES_MESSAGES);
        this.addPage((IWizardPage)this.settingPage);
    }

    @Override
    public boolean canFinish() {
        return this.newReportFileWizardPage.isPageComplete() && this.settingPage.canFinish();
    }

    @Override
    public boolean performFinish() {
        String templateFileName;
        final IPath containerName = this.newReportFileWizardPage.getContainerFullPath();
        String fn = this.newReportFileWizardPage.getFileName();
        Object fileName = !Platform.getOS().equals("win32") ? (!fn.endsWith(this.getFileExtension()) ? fn + this.getFileExtension() : fn) : (!fn.toLowerCase(Locale.getDefault()).endsWith(this.getFileExtension()) ? fn + this.getFileExtension() : fn);
        if (Platform.getBundle((String)"org.eclipse.birt.resources") == null) {
            return true;
        }
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.birt.resources"), (IPath)new Path("/templates/blank_report.rpttemplate"), null);
        if (url == null) {
            return true;
        }
        try {
            templateFileName = FileLocator.resolve((URL)url).getPath();
        }
        catch (IOException e1) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress((String)fileName, templateFileName){
            private final /* synthetic */ String val$fileName;
            private final /* synthetic */ String val$templateFileName;
            {
                this.val$fileName = string;
                this.val$templateFileName = string2;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewTemplateWizard.this.doFinish(containerName, this.val$fileName, this.val$templateFileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionUtil.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private void doFinish(IPath containerName, String fileName, String sourceFileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CREATING + fileName, 2);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(containerName);
        IContainer container = null;
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            IFolder folder = this.createFolderHandle(containerName);
            UIUtil.createFolder((IFolder)folder, (IProgressMonitor)monitor);
            container = folder;
        } else {
            container = (IContainer)resource;
        }
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            ReportDesignHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().createDesignFromTemplate(sourceFileName);
            if (ReportPlugin.getDefault().getEnableCommentPreference(file.getProject())) {
                handle.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference(file.getProject()));
            }
            if (ReportPlugin.getDefault().getDefaultUnitPreference(file.getProject()) != null) {
                handle.setStringProperty("units", ReportPlugin.getDefault().getDefaultUnitPreference(file.getProject()));
            }
            this.setReportSettings(handle);
            handle.setBidiOrientation(ReportPlugin.getDefault().getLTRReportDirection() ? "ltr" : "rtl");
            handle.saveAs(file.getLocation().toOSString());
            handle.close();
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
        container.refreshLocal(2, monitor);
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    void setReportSettings(Object model) throws IOException {
        ReportDesignHandle handle = (ReportDesignHandle)model;
        try {
            handle.setDisplayName(this.settingPage.getDisplayName());
            handle.setDescription(this.settingPage.getDescription());
            handle.setIconFile(this.settingPage.getPreviewImagePath());
            UIUtil.addCreateBy((ModuleHandle)handle);
            if (handle.getProperty("imageDPI") == null) {
                UIUtil.setDPI((ReportDesignHandle)handle);
            }
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }
}

