/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.writer;

import java.io.OutputStream;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.emitter.XMLWriter;

public class MetaWriter {
    protected XMLWriter writer = new XMLWriter();

    public MetaWriter(OutputStream out) {
        this.writer.open(out);
    }

    public void start() {
        this.writer.startWriter();
        this.writer.openTag("office:document-meta");
        this.writer.attribute("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        this.writer.attribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.writer.attribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        this.writer.attribute("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        this.writer.attribute("xmlns:ooo", "http://openoffice.org/2004/office");
        this.writer.attribute("xmlns:grddl", "http://www.w3.org/2003/g/data-view#");
        this.writer.attribute("office:version", "1.2");
        this.writer.attribute("grddl:transformation", "http://docs.oasis-open.org/office/1.2/xslt/odf2rdf.xsl");
    }

    public void writeMeta(String creator, String title, String description, String subject) throws BirtException {
        Date now = new Date();
        String nowString = DataTypeUtil.toString((Object)now);
        this.writeTag("dc:title", title);
        this.writeTag("dc:description", description);
        this.writeTag("dc:subject", subject);
        this.writeTag("dc:date", nowString);
        this.writeTag("meta:creation-date", nowString);
        this.writeTag("meta:generator", "BIRT/2.6");
    }

    private void writeTag(String tag, String value) {
        if (value != null && !"".equals(value)) {
            this.writer.openTag(tag);
            this.writer.text(value);
            this.writer.closeTag(tag);
        }
    }

    public void end() {
        this.writer.closeTag("office:document-meta");
        this.writer.close();
    }
}

