/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

class SimpleIterator
implements Iterator {
    protected final SimpleValueHandle valueHandle;
    protected final ArrayList list;
    protected int index;

    public SimpleIterator(SimpleValueHandle handle) {
        this.valueHandle = handle;
        this.list = this.valueHandle.getListValue();
        this.index = 0;
    }

    @Override
    public void remove() {
        if (!this.hasNext()) {
            return;
        }
        try {
            this.valueHandle.removeItem(this.index);
        }
        catch (PropertyValueException propertyValueException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasNext() {
        return this.list != null && this.index < this.list.size();
    }

    public Object next() {
        Object value;
        if (!this.hasNext()) {
            return null;
        }
        if ((value = this.list.get(this.index++)) instanceof ElementRefValue) {
            ElementRefValue elementRef = (ElementRefValue)value;
            if (elementRef.isResolved()) {
                return elementRef.getElement().getHandle(elementRef.getElement().getRoot());
            }
            return elementRef.getQualifiedReference();
        }
        return value;
    }
}

