/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SQLKeywordRule
implements IPredicateRule {
    protected IToken token = null;
    protected String[] keywords;
    StringBuffer buf = null;

    public SQLKeywordRule(IToken _token, String[] keywords) {
        this.token = _token;
        this.buf = new StringBuffer();
        this.keywords = keywords;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int column = scanner.getColumn();
        int iCh = 32;
        if (column > 0) {
            scanner.unread();
            iCh = scanner.read();
        }
        IToken tokenToReturn = Token.UNDEFINED;
        this.buf.setLength(0);
        if (this.isValidPrecedingCharacter(iCh)) {
            do {
                iCh = scanner.read();
                this.buf.append(Character.toLowerCase((char)iCh));
            } while (this.isKeywordStart(this.buf.toString()) && iCh != -1);
        }
        if (this.buf.length() > 0) {
            String sToCompare;
            if (this.isValidTerminatingCharacter(iCh) && this.buf.length() > 1 && this.isKeyword(sToCompare = this.buf.substring(0, this.buf.length() - 1))) {
                scanner.unread();
                tokenToReturn = this.token;
            }
            if (tokenToReturn.isUndefined()) {
                this.unreadBuffer(scanner);
            }
        }
        return tokenToReturn;
    }

    private final boolean isValidPrecedingCharacter(int iCh) {
        return iCh == 32 || iCh == 9 || iCh == 13 || iCh == 10 || iCh == 40;
    }

    private final boolean isValidTerminatingCharacter(int iCh) {
        return this.isValidPrecedingCharacter(iCh) || iCh == -1;
    }

    private void unreadBuffer(ICharacterScanner scanner) {
        int i = this.buf.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }

    private boolean isKeywordStart(String keyword) {
        int n = 0;
        while (n < this.keywords.length) {
            if (this.keywords[n].startsWith(keyword)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isKeyword(String keyword) {
        int n = 0;
        while (n < this.keywords.length) {
            if (keyword.equals(this.keywords[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }
}

