/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.net.URI;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.IconCanvas;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CursorImageDialog
extends TrayDialog
implements SelectionListener {
    private Composite inputArea;
    private IconCanvas previewCanvas;
    private Text txtUriEditor;
    private Button btnPreview;
    private Cursor cursor;
    private Label title;

    public CursorImageDialog(Shell parentShell, Cursor cursor) {
        super(parentShell);
        this.cursor = cursor;
        this.setHelpAvailable(false);
    }

    protected Control createContents(Composite parent) {
        Control ct = super.createContents(parent);
        this.initDialog();
        return ct;
    }

    protected Control createDialogArea(Composite parent) {
        Composite topCompostie = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(topCompostie, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createInputArea(composite);
        this.createPreviewArea(composite);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        return topCompostie;
    }

    private void createInputArea(Composite parent) {
        this.inputArea = new Composite(parent, 0);
        GridData gd = new GridData(768);
        this.inputArea.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.inputArea.setLayout((Layout)gl);
        this.title = new Label(this.inputArea, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        Label l = new Label(this.inputArea, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        l.setText(Messages.getString("ImageDialog.uri.tooltip"));
        this.txtUriEditor = new Text(this.inputArea, 2052);
        this.txtUriEditor.setLayoutData((Object)new GridData(768));
        this.txtUriEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CursorImageDialog.this.updateButtons();
            }
        });
        this.txtUriEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CursorImageDialog.this.preview(CursorImageDialog.this.removeQuote(CursorImageDialog.this.txtUriEditor.getText()));
            }
        });
        this.btnPreview = new Button(this.inputArea, 0);
        gd = new GridData();
        this.btnPreview.setLayoutData((Object)gd);
        this.btnPreview.addSelectionListener((SelectionListener)this);
        this.btnPreview.setText(Messages.getString("ImageDialog.label.Preview"));
    }

    private void createPreviewArea(Composite composite) {
        Composite previewArea = new Composite(composite, 2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 200;
        previewArea.setLayoutData((Object)gd);
        previewArea.setLayout((Layout)new FillLayout());
        this.previewCanvas = new IconCanvas(previewArea);
        this.previewCanvas.setSize(250, 200);
    }

    protected void okPressed() {
        if (this.cursor.getImage().size() > 0) {
            this.cursor.getImage().clear();
        }
        this.cursor.getImage().add(0, (Object)ImageImpl.create((String)this.txtUriEditor.getText()));
        super.okPressed();
    }

    protected boolean initDialog() {
        this.getShell().setText(Messages.getString("ImageDialog.label.SelectImage"));
        this.title.setText(Messages.getString("ImageDialog.label.EnterURL"));
        this.getButton(0).setEnabled(false);
        this.initURIEditor();
        return true;
    }

    private void initURIEditor() {
        String uri = "";
        if (this.cursor.getImage().size() > 0) {
            uri = ((Image)this.cursor.getImage().get(0)).getURL();
        }
        this.txtUriEditor.setText(uri);
        this.txtUriEditor.setFocus();
        this.updateButtons();
        this.preview(this.removeQuote(this.txtUriEditor.getText()));
    }

    private void updateButtons() {
        boolean complete = this.txtUriEditor.getText() != null && this.txtUriEditor.getText().trim().length() > 0;
        this.btnPreview.setEnabled(complete);
        this.getButton(0).setEnabled(complete);
    }

    public String removeQuote(String string) {
        if (string != null && string.length() >= 2 && string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private void preview(String uri) {
        try {
            this.previewCanvas.loadImage(new URI(uri).toURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.btnPreview) {
            this.preview(this.removeQuote(this.txtUriEditor.getText()));
        }
    }
}

