/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.data.DateFormatFactory;
import org.eclipse.birt.core.data.PatternKey;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;

public class DateFormatISO8601 {
    private static Pattern T_PATTERN = Pattern.compile("T");
    private static Pattern TIME_PART_PATTERN = Pattern.compile("\\d\\d:\\d\\d:\\d\\d\\.\\d+");

    public static Date parse(String source, TimeZone timeZone) throws BirtException, ParseException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat dateFormat = DateFormatISO8601.getSimpleDateFormat(source, timeZone);
        TimeZone savedTimeZone = dateFormat.getTimeZone();
        Date resultDate = null;
        try {
            if (timeZone != null) {
                dateFormat.setTimeZone(timeZone);
            }
            if (dateFormat != null) {
                resultDate = dateFormat.parse(DateFormatISO8601.cleanDate(source));
            }
            Date date = resultDate;
            return date;
        }
        catch (ParseException e) {
            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
        }
        finally {
            dateFormat.setTimeZone(savedTimeZone);
        }
    }

    @Deprecated
    public static SimpleDateFormat getDateFormat(String source, TimeZone timeZone) throws BirtException {
        return DateFormatISO8601.getSimpleDateFormat(source, timeZone).clone();
    }

    public static SimpleDateFormat getSimpleDateFormat(String source, TimeZone timeZone) throws BirtException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat dateFormat = null;
        Date resultDate = null;
        SimpleDateFormat simpleDateFormatter = DateFormatFactory.getPatternInstance(PatternKey.getPatterKey(source = DateFormatISO8601.cleanDate(source)));
        if (simpleDateFormatter != null) {
            dateFormat = simpleDateFormatter;
            TimeZone savedTimeZone = null;
            try {
                if (timeZone != null) {
                    savedTimeZone = dateFormat.getTimeZone();
                    dateFormat.setTimeZone(timeZone);
                }
                resultDate = dateFormat.parse(source);
                SimpleDateFormat simpleDateFormat = dateFormat;
                return simpleDateFormat;
            }
            catch (ParseException parseException) {
            }
            finally {
                if (savedTimeZone != null) {
                    dateFormat.setTimeZone(savedTimeZone);
                }
            }
        }
        if (resultDate == null) {
            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
        }
        return dateFormat;
    }

    public static String format(Date date, TimeZone timeZone) throws BirtException {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormatter = DateFormatFactory.getPatternInstance(PatternKey.getPatterKey("yyyy-MM-dd HH:mm:ss.sZ"));
        TimeZone savedTimeZone = simpleDateFormatter.getTimeZone();
        if (simpleDateFormatter != null) {
            try {
                simpleDateFormatter.setTimeZone(timeZone);
                String string = simpleDateFormatter.format(date);
                return string;
            }
            catch (Exception exception) {
            }
            finally {
                simpleDateFormatter.setTimeZone(savedTimeZone);
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{date.toString(), "ISO8601 Format"});
    }

    public static String format(Date date) throws BirtException {
        return DateFormatISO8601.format(date, TimeZone.getDefault());
    }

    private static String cleanDate(String s) {
        String timePart;
        int zoneIndex;
        if ((s = s.trim()).indexOf(84) < 12) {
            s = T_PATTERN.matcher(s).replaceFirst(" ");
        }
        if ((zoneIndex = s.indexOf(90)) == -1) {
            zoneIndex = s.indexOf(122);
        }
        if (zoneIndex == s.length() - 1) {
            return s.substring(0, zoneIndex).trim();
        }
        Matcher m = TIME_PART_PATTERN.matcher(s);
        if (m.find() && (timePart = m.group()).length() > 12) {
            s = m.replaceFirst(timePart.substring(0, 12));
        }
        return s;
    }
}

