/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import java.util.Properties;
import org.eclipse.birt.report.data.bidi.utils.core.BidiTransform;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.ui.PlatformUI;

public final class DriverLoader {
    private DriverLoader() {
    }

    public static Connection getConnection(String driverClassName, String connectionString, String userId, String password) throws SQLException, OdaException {
        return DriverLoader.getConnection(driverClassName, connectionString, userId, password, null);
    }

    public static Connection getConnection(String driverClassName, String connectionString, String userId, String password, Properties props) throws SQLException, OdaException {
        return JDBCDriverManager.getInstance().getConnection(driverClassName, connectionString, userId, password, null, props);
    }

    public static Connection getConnectionWithExceptionTip(String driverClassName, String connectionString, String userId, String password, Properties props) throws SQLException {
        try {
            return JDBCDriverManager.getInstance().getConnection(driverClassName, connectionString, userId, password, null, props);
        }
        catch (Exception e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
            return null;
        }
    }

    static String escapeCharacters(String value) {
        StringCharacterIterator iterator = new StringCharacterIterator(value);
        char character = iterator.current();
        StringBuilder result = new StringBuilder();
        while (character != '\uffff') {
            if (character == '\\') {
                result.append("\\");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static boolean testConnection(String driverClassName, String connectionString, String userId, String password) throws OdaException {
        return DriverLoader.testConnection(driverClassName, connectionString, null, userId, password, new Properties());
    }

    public static boolean testConnection(String driverClassName, String connectionString, String userId, String password, Properties props) throws OdaException {
        return DriverLoader.testConnection(driverClassName, connectionString, null, userId, password, props);
    }

    public static boolean testConnection(String driverClassName, String connectionString, String jndiNameUrl, String userId, String password) throws OdaException {
        return DriverLoader.testConnection(driverClassName, connectionString, jndiNameUrl, userId, password, new Properties());
    }

    public static boolean testConnection(String driverClassName, String connectionString, String jndiNameUrl, String userId, String password, Properties props) throws OdaException {
        return JDBCDriverManager.getInstance().testConnection(driverClassName, connectionString, jndiNameUrl, userId, password, props);
    }

    public static boolean testConnection(String driverClassName, String connectionString, String jndiNameUrl, String userId, String password, String bidiFormatStr) throws OdaException {
        return DriverLoader.testConnection(driverClassName, connectionString, jndiNameUrl, userId, password, bidiFormatStr, new Properties());
    }

    public static boolean testConnection(String driverClassName, String connectionString, String jndiNameUrl, String userId, String password, String bidiFormatStr, Properties props) throws OdaException {
        userId = BidiTransform.transform((String)userId, (String)"ILYNN", (String)bidiFormatStr);
        password = BidiTransform.transform((String)password, (String)"ILYNN", (String)bidiFormatStr);
        connectionString = BidiTransform.transformURL((String)connectionString, (String)"ILYNN", (String)bidiFormatStr);
        return DriverLoader.testConnection(driverClassName, connectionString, jndiNameUrl, userId, password, props);
    }
}

