/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.bidi.utils.core.BidiTransform;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.ChildrenAllowedNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.FilterConfig;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.IDBNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.ProcedureColumnNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.provider.JdbcMetaDataProvider;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

public class ProcedureNode
extends ChildrenAllowedNode
implements Comparable<ProcedureNode> {
    private static Logger logger = Logger.getLogger(ProcedureNode.class.getName());
    private static String PROCEDURE_ICON = String.valueOf(ProcedureNode.class.getName()) + ".ProcedureIcon";
    private String schemaName;
    private String procedureName;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(PROCEDURE_ICON, ImageDescriptor.createFromFile(JdbcPlugin.class, (String)"icons/column.gif"));
    }

    public ProcedureNode(String schemaName, String procedureName) {
        assert (procedureName != null);
        this.schemaName = schemaName;
        this.procedureName = procedureName;
    }

    @Override
    public int compareTo(ProcedureNode o) {
        return this.procedureName.compareTo(o.procedureName);
    }

    @Override
    public String getDisplayName(String metadataBidiFormatStr) {
        return BidiTransform.transform((String)this.procedureName, (String)metadataBidiFormatStr, (String)"ILYNN");
    }

    @Override
    public Image getImage() {
        return JFaceResources.getImageRegistry().get(PROCEDURE_ICON);
    }

    @Override
    public String getQualifiedNameInSQL(boolean useIdentifierQuoteString, boolean includeSchema, String metadataBidiFormatStr) {
        StringBuilder sb = new StringBuilder();
        String quoteFlag = "";
        if (useIdentifierQuoteString) {
            quoteFlag = JdbcMetaDataProvider.getInstance().getIdentifierQuoteString();
        }
        if (includeSchema && this.schemaName != null) {
            sb.append(Utility.quoteString(BidiTransform.transform((String)this.schemaName, (String)metadataBidiFormatStr, (String)"ILYNN"), quoteFlag)).append(".");
        }
        sb.append(Utility.quoteString(BidiTransform.transform((String)this.procedureName, (String)metadataBidiFormatStr, (String)"ILYNN"), quoteFlag));
        return sb.toString();
    }

    @Override
    protected IDBNode[] refetchChildren(FilterConfig fc) {
        ArrayList<ProcedureColumnNode> columns = new ArrayList<ProcedureColumnNode>();
        ResultSet rs = JdbcMetaDataProvider.getInstance().getProcedureColumns(this.schemaName, this.procedureName, null);
        if (rs != null) {
            try {
                int n = 0;
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    if (columnName == null) {
                        columnName = "param" + ++n;
                    }
                    String mode = Utility.toModeType(rs.getInt("COLUMN_TYPE"));
                    String type = rs.getString("TYPE_NAME");
                    ProcedureColumnNode column = new ProcedureColumnNode(columnName, type, mode);
                    columns.add(column);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return columns.toArray(new ProcedureColumnNode[0]);
    }
}

