/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.models;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.TreeData;
import org.eclipse.birt.data.oda.pojo.util.ClassParser;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class ToolTipFaker {
    private static final String TREE_ITEM_FLAG = "_TREEITEM";
    private TreeViewer tv;

    public ToolTipFaker(TreeViewer tv) {
        this.tv = tv;
    }

    public void fakeToolTip() {
        this.tv.getTree().setToolTipText("");
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData(ToolTipFaker.TREE_ITEM_FLAG);
                        ToolTipFaker.this.tv.getTree().setSelection(new TreeItem[]{(TreeItem)e.item});
                        ToolTipFaker.this.tv.getTree().notifyListeners(13, e);
                        shell.dispose();
                        ToolTipFaker.this.tv.getTree().setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener treeListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TreeItem item = ToolTipFaker.this.tv.getTree().getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(ToolTipFaker.this.tv.getTree().getShell(), 540676);
                        this.tip.setBackground(ToolTipFaker.this.tv.getTree().getShell().getDisplay().getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(ToolTipFaker.this.tv.getTree().getShell().getDisplay().getSystemColor(28));
                        this.label.setBackground(ToolTipFaker.this.tv.getTree().getShell().getDisplay().getSystemColor(29));
                        this.label.setData(ToolTipFaker.TREE_ITEM_FLAG, (Object)item);
                        this.label.setText(ToolTipFaker.this.getToolTip(item));
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = ToolTipFaker.this.tv.getTree().toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        this.tv.getTree().addListener(12, treeListener);
        this.tv.getTree().addListener(1, treeListener);
        this.tv.getTree().addListener(5, treeListener);
        this.tv.getTree().addListener(32, treeListener);
    }

    private String getToolTip(TreeItem item) {
        Object obj = item.getData();
        if (obj instanceof TreeData) {
            Object data = ((TreeData)item.getData()).getWrappedObject();
            if (data instanceof Field) {
                return String.valueOf(((Field)data).getName()) + " : " + ClassParser.getTypeLabel((Type)((Field)data).getGenericType());
            }
            if (data instanceof Method) {
                return String.valueOf(((Method)data).getName()) + "(" + ClassParser.getParametersLabel((Method)((Method)data)) + ")" + " : " + ClassParser.getTypeLabel((Type)((Method)data).getGenericReturnType());
            }
            return item.getText();
        }
        return null;
    }
}

