/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.ui.launching;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.debug.internal.ui.launcher.IReportLauncherSettings;
import org.eclipse.birt.report.debug.internal.ui.launcher.util.ReportLauncherUtils;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

@Deprecated
public class ReportAdvancedLauncherTab
extends AbstractLauncherTab
implements ILaunchConfigurationTab,
IReportLauncherSettings {
    protected static final Logger logger = Logger.getLogger(ReportAdvancedLauncherTab.class.getName());
    private static final String REPORTPROJECTKID = "org.eclipse.birt.report.designer.ui.reportprojectnature";
    private Label fUseListRadio;
    private CheckboxTreeViewer fPluginTreeViewer;
    private Label fVisibleLabel;
    private NamedElement[] fWorkspacePlugins;
    private IProject[] fWorkspaceBIRTModels;
    private IProject[] fWorkspaceJavaModels;
    private Button fDefaultsButton;
    private int fNumWorkspaceBIRTChecked;
    private int fNumWorkspaceJavaChecked;
    private Image fImage;
    private boolean fShowFeatures;
    private Button fSelectAllButton;
    private Button fDeselectButton;

    private List getReportDesignFileFromProject(IProject project) {
        ArrayList<IResource> retValue = new ArrayList<IResource>();
        try {
            IResource[] resources = project.members();
            if (resources != null && resources.length > 0) {
                List extesionNameList = ReportPlugin.getDefault().getReportExtensionNameList();
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    if (extesionNameList.contains(resource.getFileExtension())) {
                        retValue.add(resource);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return retValue;
    }

    public ReportAdvancedLauncherTab() {
        this(true);
    }

    public ReportAdvancedLauncherTab(boolean showFeatures) {
        this.fShowFeatures = showFeatures;
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.fImage = PDEPluginImages.DESC_REQ_PLUGINS_OBJ.createImage();
        this.fWorkspaceBIRTModels = this.getInterestProject(REPORTPROJECTKID);
        this.fWorkspaceJavaModels = this.getInterestProject("org.eclipse.jdt.core.javanature");
    }

    private IProject[] getInterestProject(String type) {
        ArrayList<IProject> retValue = new ArrayList<IProject>();
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (allProjects == null) {
            return new IProject[0];
        }
        int len = allProjects.length;
        int i = 0;
        while (i < len) {
            IProject project = allProjects[i];
            try {
                if (project.hasNature(type)) {
                    retValue.add(project);
                }
            }
            catch (CoreException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            ++i;
        }
        IProject[] temp = new IProject[retValue.size()];
        temp = retValue.toArray(temp);
        return temp;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        this.fImage.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.fUseListRadio = new Label(composite, 16);
        this.fUseListRadio.setText(Messages.getString((String)"ReportAdvancedLauncherTab.UseListRadioText"));
        this.createPluginList(composite);
        this.hookListeners();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        UIUtil.bindHelp((Control)composite, (String)"org.eclipse.pde.doc.user.launcher_advanced");
    }

    private void hookListeners() {
        this.fDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportAdvancedLauncherTab.this.computeInitialCheckState();
                ReportAdvancedLauncherTab.this.updateStatus();
            }
        });
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportAdvancedLauncherTab.this.toggleGroups(true);
                ReportAdvancedLauncherTab.this.updateStatus();
            }
        });
        this.fDeselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportAdvancedLauncherTab.this.toggleGroups(false);
                ReportAdvancedLauncherTab.this.updateStatus();
            }
        });
    }

    protected void toggleGroups(boolean select) {
        int i = 0;
        while (i < this.fWorkspacePlugins.length) {
            this.handleGroupStateChanged(this.fWorkspacePlugins[i], select);
            ++i;
        }
    }

    private void adjustCustomControlEnableState(boolean enable) {
        this.fVisibleLabel.setVisible(enable);
        this.fPluginTreeViewer.getTree().setVisible(enable);
        this.fDefaultsButton.setVisible(enable);
        this.fSelectAllButton.setVisible(enable);
        this.fDeselectButton.setVisible(enable);
    }

    private void createPluginList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fVisibleLabel = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fVisibleLabel.setLayoutData((Object)gd);
        this.fVisibleLabel.setText(Messages.getString((String)"ReportAdvancedLauncherTab.VisibleLabelText"));
        this.createPluginViewer(composite);
        this.createButtonContainer(composite);
    }

    private void addPluginAndDependencies(IProject model, TreeMap map) {
        if (model == null) {
            return;
        }
        String id = model.getName();
        if (!map.containsKey(id)) {
            map.put(id, model);
        }
    }

    private void adjustGroupState() {
        int size = this.fWorkspaceBIRTModels.length;
        int i = 0;
        while (i < size) {
            IProject project = this.fWorkspaceBIRTModels[i];
            List list = this.getReportDesignFileFromProject(project);
            int len = list.size();
            int ori = 0;
            int j = 0;
            while (j < len) {
                Object obj = list.get(j);
                if (this.fPluginTreeViewer.getChecked(obj)) {
                    ++ori;
                }
                ++j;
            }
            if (ori > 0 && !this.fPluginTreeViewer.getChecked((Object)project)) {
                ++this.fNumWorkspaceBIRTChecked;
                this.fPluginTreeViewer.setChecked((Object)project, true);
            }
            this.fPluginTreeViewer.setGrayed((Object)project, ori > 0 && ori < len);
            ++i;
        }
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins[0], this.fNumWorkspaceBIRTChecked > 0);
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins[1], this.fNumWorkspaceJavaChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins[0], this.fNumWorkspaceBIRTChecked > 0 && this.fNumWorkspaceBIRTChecked < this.fWorkspaceBIRTModels.length);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins[1], this.fNumWorkspaceJavaChecked > 0 && this.fNumWorkspaceJavaChecked < this.fWorkspaceJavaModels.length);
    }

    private void createPluginViewer(Composite composite) {
        this.fPluginTreeViewer = new CheckboxTreeViewer(composite, 2048);
        this.fPluginTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fPluginTreeViewer.setLabelProvider((IBaseLabelProvider)new PDELabelProvider(){

            public String getText(Object obj) {
                if (obj instanceof IProject) {
                    return ((IProject)obj).getName();
                }
                if (obj instanceof IResource) {
                    return ((IResource)obj).getName();
                }
                return super.getText(obj);
            }
        });
        this.fPluginTreeViewer.setAutoExpandLevel(2);
        this.fPluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IPluginModelBase) {
                    ReportAdvancedLauncherTab.this.handleCheckStateChanged((IPluginModelBase)element, event.getChecked());
                } else {
                    ReportAdvancedLauncherTab.this.handleGroupStateChanged(element, event.getChecked());
                }
                ReportAdvancedLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fPluginTreeViewer.setComparator((ViewerComparator)new ListUtil.PluginComparator(){

            public int category(Object obj) {
                int i = 0;
                while (i < ReportAdvancedLauncherTab.this.fWorkspacePlugins.length) {
                    if (obj == ReportAdvancedLauncherTab.this.fWorkspacePlugins[i]) {
                        return -1;
                    }
                    ++i;
                }
                return 0;
            }
        });
        this.fPluginTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        Image pluginsImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
        this.fWorkspacePlugins = new NamedElement[]{new NamedElement(Messages.getString((String)"ReportAdvancedLauncherTab.WorkspaceReportProjects"), pluginsImage), new NamedElement(Messages.getString((String)"ReportClasspathLaucnTab.WorkspaceJavaProjects"), pluginsImage)};
    }

    private void createButtonContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1040));
        this.fSelectAllButton = new Button(composite, 8);
        this.fSelectAllButton.setText(Messages.getString((String)"ReportAdvancedLauncherTab.SelectAllButtonText"));
        this.fSelectAllButton.setLayoutData((Object)new GridData(770));
        SWTUtil.setButtonDimensionHint((Button)this.fSelectAllButton);
        this.fDeselectButton = new Button(composite, 8);
        this.fDeselectButton.setText(Messages.getString((String)"ReportAdvancedLauncherTab.DeselectButtonText"));
        this.fDeselectButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint((Button)this.fDeselectButton);
        this.fDefaultsButton = new Button(composite, 8);
        this.fDefaultsButton.setText(Messages.getString((String)"ReportAdvancedLauncherTab.DefaultsButtonText"));
        this.fDefaultsButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint((Button)this.fDefaultsButton);
    }

    private void initWorkspacePluginsState(ILaunchConfiguration config) throws CoreException {
        this.fNumWorkspaceBIRTChecked = this.fWorkspaceBIRTModels.length;
        this.fNumWorkspaceJavaChecked = this.fWorkspaceJavaModels.length;
        int i = 0;
        while (i < this.fWorkspacePlugins.length) {
            this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins[i], true);
            ++i;
        }
        Set<String> deselected = ReportLauncherUtils.parseDeselectedWSIds(config);
        int i2 = 0;
        while (i2 < this.fWorkspaceBIRTModels.length) {
            if (!deselected.contains(this.fWorkspaceBIRTModels[i2].getName()) && this.fPluginTreeViewer.setChecked((Object)this.fWorkspaceBIRTModels[i2], false)) {
                --this.fNumWorkspaceBIRTChecked;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.fWorkspaceJavaModels.length) {
            if (!deselected.contains(this.fWorkspaceJavaModels[i2].getName()) && this.fPluginTreeViewer.setChecked((Object)this.fWorkspaceJavaModels[i2], false)) {
                --this.fNumWorkspaceJavaChecked;
            }
            ++i2;
        }
        int[] checked = new int[]{this.fNumWorkspaceBIRTChecked, this.fNumWorkspaceJavaChecked};
        int[] length = new int[]{this.fWorkspaceBIRTModels.length, this.fWorkspaceJavaModels.length};
        int i3 = 0;
        while (i3 < this.fWorkspacePlugins.length) {
            if (checked[i3] == 0) {
                this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins[i3], false);
            }
            this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins[i3], checked[i3] > 0 && checked[i3] < length[i3]);
            ++i3;
        }
        int size = this.fWorkspaceBIRTModels.length;
        deselected = ReportLauncherUtils.parseDeselectedOpenFileNames(config);
        int i4 = 0;
        while (i4 < size) {
            int len;
            IProject project = this.fWorkspaceBIRTModels[i4];
            List list = this.getReportDesignFileFromProject(project);
            int ori = len = list.size();
            int j = 0;
            while (j < len) {
                IResource resource = (IResource)list.get(j);
                String path = resource.getFullPath().toString();
                if (!deselected.contains(path) && this.fPluginTreeViewer.setChecked((Object)resource, false)) {
                    --ori;
                }
                ++j;
            }
            if (ori > 0) {
                this.fPluginTreeViewer.setChecked((Object)project, true);
            }
            this.fPluginTreeViewer.setGrayed((Object)project, ori > 0 && ori < len);
            ++i4;
        }
    }

    private void initExternalPluginsState(ILaunchConfiguration config) throws CoreException {
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            if (this.fPluginTreeViewer.getInput() == null) {
                this.fPluginTreeViewer.setUseHashlookup(true);
                this.fPluginTreeViewer.setInput((Object)PDEPlugin.getDefault());
                this.fPluginTreeViewer.reveal((Object)this.fWorkspacePlugins);
            }
            this.initWorkspacePluginsState(config);
            this.initExternalPluginsState(config);
        }
        catch (CoreException e) {
            PDEPlugin.logException((Throwable)e);
        }
        this.adjustCustomControlEnableState(true);
        this.updateStatus();
    }

    private void computeInitialCheckState() {
        String id;
        IProject model;
        TreeSet<String> wtable = new TreeSet<String>();
        this.fNumWorkspaceBIRTChecked = 0;
        this.fNumWorkspaceJavaChecked = 0;
        int i = 0;
        while (i < this.fWorkspaceBIRTModels.length) {
            model = this.fWorkspaceBIRTModels[i];
            ++this.fNumWorkspaceBIRTChecked;
            id = model.getName();
            if (id != null) {
                wtable.add(model.getName());
            }
            ++i;
        }
        i = 0;
        while (i < this.fWorkspaceJavaModels.length) {
            model = this.fWorkspaceJavaModels[i];
            ++this.fNumWorkspaceJavaChecked;
            id = model.getName();
            if (id != null) {
                wtable.add(model.getName());
            }
            ++i;
        }
        i = 0;
        while (i < this.fWorkspacePlugins.length) {
            this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins[i], true);
            ++i;
        }
        this.adjustGroupState();
    }

    private void handleCheckStateChanged(IPluginModelBase model, boolean checked) {
        if (model.getUnderlyingResource() != null && model instanceof IProject) {
            try {
                if (((IProject)model).hasNature(REPORTPROJECTKID)) {
                    this.fNumWorkspaceBIRTChecked += checked ? 1 : -1;
                } else if (((IProject)model).hasNature("org.eclipse.jdt.core.javanature")) {
                    this.fNumWorkspaceJavaChecked += checked ? 1 : -1;
                }
            }
            catch (CoreException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.adjustGroupState();
    }

    private void handleGroupStateChanged(Object group, boolean checked) {
        this.fPluginTreeViewer.setSubtreeChecked(group, checked);
        this.fPluginTreeViewer.setGrayed(group, false);
        if (group == this.fWorkspacePlugins[0]) {
            int n = this.fNumWorkspaceBIRTChecked = checked ? this.fWorkspaceBIRTModels.length : 0;
        }
        if (group == this.fWorkspacePlugins[1]) {
            int n = this.fNumWorkspaceJavaChecked = checked ? this.fWorkspaceJavaModels.length : 0;
        }
        if (group instanceof IProject) {
            try {
                if (((IProject)group).hasNature(REPORTPROJECTKID)) {
                    this.fNumWorkspaceBIRTChecked += checked ? 1 : -1;
                } else if (((IProject)group).hasNature("org.eclipse.jdt.core.javanature")) {
                    this.fNumWorkspaceJavaChecked += checked ? 1 : -1;
                }
            }
            catch (CoreException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.adjustGroupState();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        if (this.fShowFeatures) {
            config.setAttribute("default", true);
            config.setAttribute("usefeatures", false);
        } else {
            config.setAttribute("default", true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        String path;
        IProject model;
        StringBuilder wbuf = new StringBuilder();
        int size = this.fWorkspaceBIRTModels.length;
        int i = 0;
        while (i < size) {
            model = this.fWorkspaceBIRTModels[i];
            path = model.getLocation().toOSString();
            if (this.fPluginTreeViewer.getChecked((Object)model)) {
                wbuf.append(";" + path);
            }
            ++i;
        }
        i = 0;
        while (i < this.fWorkspaceJavaModels.length) {
            model = this.fWorkspaceJavaModels[i];
            path = model.getLocation().toOSString();
            if (this.fPluginTreeViewer.getChecked((Object)model)) {
                wbuf.append(";" + path);
            }
            ++i;
        }
        config.setAttribute("importproject", wbuf.toString());
        wbuf = new StringBuilder();
        i = 0;
        while (i < size) {
            IProject project = this.fWorkspaceBIRTModels[i];
            List list = this.getReportDesignFileFromProject(project);
            int j = 0;
            while (j < list.size()) {
                IResource resource = (IResource)list.get(j);
                String path2 = resource.getFullPath().toString();
                if (this.fPluginTreeViewer.getChecked((Object)resource)) {
                    wbuf.append(";" + path2);
                }
                ++j;
            }
            ++i;
        }
        config.setAttribute("openfilenames", wbuf.toString());
        config.setAttribute("clearws", true);
        config.setAttribute("askclear", false);
        config.setAttribute("location0", "birt-debugger-workspace");
    }

    private void updateStatus() {
        this.updateStatus(this.validate());
    }

    private IStatus validate() {
        return ReportAdvancedLauncherTab.createStatus(0, "");
    }

    protected void updateStatus(IStatus status) {
        this.applyToStatusLine(status);
    }

    public void applyToStatusLine(IStatus status) {
        String errorMessage = null;
        String warningMessage = null;
        String statusMessage = status.getMessage();
        if (statusMessage.length() > 0) {
            if (status.matches(4)) {
                errorMessage = statusMessage;
            } else if (!status.isOK()) {
                warningMessage = statusMessage;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setMessage(warningMessage);
        this.updateLaunchConfigurationDialog();
    }

    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        return s1.getSeverity() >= s2.getSeverity() ? s1 : s2;
    }

    public static IStatus createStatus(int severity, String message) {
        return new Status(severity, PDEPlugin.getPluginId(), severity, message, null);
    }

    public String getName() {
        return Messages.getString((String)"ReportAdvancedLauncherTab.Name");
    }

    public Image getImage() {
        return this.fImage;
    }

    public void validateTab() {
    }

    class PluginContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IProject);
        }

        public Object[] getChildren(Object parent) {
            try {
                if (parent == ReportAdvancedLauncherTab.this.fWorkspacePlugins[0]) {
                    return ReportAdvancedLauncherTab.this.fWorkspaceBIRTModels;
                }
                if (parent == ReportAdvancedLauncherTab.this.fWorkspacePlugins[1]) {
                    return ReportAdvancedLauncherTab.this.fWorkspaceJavaModels;
                }
                if (parent instanceof IProject && ((IProject)parent).hasNature(ReportAdvancedLauncherTab.REPORTPROJECTKID)) {
                    List retValue = ReportAdvancedLauncherTab.this.getReportDesignFileFromProject((IProject)parent);
                    return retValue.toArray(new Object[retValue.size()]);
                }
            }
            catch (CoreException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getElements(Object input) {
            return ReportAdvancedLauncherTab.this.fWorkspacePlugins;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }
}

