/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.designer.internal.ui.data.DataService;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;

public class DteAdapter {
    private ExecutionContext executionContext;

    public void defineDataSet(DataSetHandle handle, DataRequestSession session, boolean keepDataSetFilter, boolean disAllowAggregation) throws AdapterException, BirtException {
        List computedColumns;
        BaseDataSetDesign baseDS;
        if (handle == null) {
            return;
        }
        DataSourceHandle dataSourceHandle = handle.getDataSource();
        if (dataSourceHandle != null) {
            BaseDataSourceDesign dsourceDesign = session.getModelAdaptor().adaptDataSource(dataSourceHandle);
            session.defineDataSource((IBaseDataSourceDesign)dsourceDesign);
        }
        if (handle instanceof JointDataSetHandle) {
            Iterator iter = ((JointDataSetHandle)handle).dataSetsIterator();
            while (iter.hasNext()) {
                DataSetHandle dsHandle = (DataSetHandle)iter.next();
                if (dsHandle == null) continue;
                this.defineDataSet(dsHandle, session, true, false);
            }
        }
        if (handle instanceof DerivedDataSetHandle) {
            List inputDataSet = ((DerivedDataSetHandle)handle).getInputDataSets();
            int i = 0;
            while (i < inputDataSet.size()) {
                this.defineDataSet((DataSetHandle)inputDataSet.get(i), session, keepDataSetFilter, disAllowAggregation);
                ++i;
            }
        }
        if ((baseDS = session.getModelAdaptor().adaptDataSet(handle)) == null) {
            return;
        }
        if (!keepDataSetFilter && baseDS.getFilters() != null) {
            baseDS.getFilters().clear();
        }
        if (disAllowAggregation && (computedColumns = baseDS.getComputedColumns()) != null && computedColumns.size() != 0) {
            int i = 0;
            while (i < computedColumns.size()) {
                IComputedColumn computedColumn = (IComputedColumn)computedColumns.get(i);
                if (computedColumn.getAggregateFunction() != null) {
                    computedColumns.set(i, new ComputedColumn(computedColumn.getName(), "null"));
                }
                ++i;
            }
        }
        if (this.executionContext == null) {
            new ModelDteApiAdapter().defineDataSet(handle, session);
        } else {
            new ModelDteApiAdapter(this.executionContext).defineDataSet(handle, session);
        }
    }

    public void setRowLimit(DataRequestSession session, int rowLimit, boolean isCube) {
        HashMap<String, Integer> appContext = session.getDataSessionContext().getAppContext();
        if (appContext == null) {
            appContext = new HashMap<String, Integer>();
        }
        if (!isCube) {
            appContext.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, rowLimit);
        } else {
            appContext.put(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE, rowLimit);
            appContext.put(DataEngine.CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE, rowLimit);
        }
        session.getDataSessionContext().setAppContext(appContext);
    }

    public void unsetRowLimit(DataRequestSession session) {
        Map appContext = session.getDataSessionContext().getAppContext();
        if (appContext == null) {
            return;
        }
        appContext.remove(DataEngine.DATA_SET_CACHE_ROW_LIMIT);
        appContext.remove(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE);
        appContext.remove(DataEngine.CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE);
    }

    public IQueryResults executeQuery(DataRequestSession session, IQueryDefinition queryDefn) throws BirtException {
        IPreparedQuery pq = session.prepare(queryDefn);
        return (IQueryResults)session.execute((IBasePreparedQuery)pq, null, session.getDataSessionContext().getDataEngineContext().getScriptContext());
    }

    public ICubeQueryResults executeQuery(DataRequestSession session, ICubeQueryDefinition queryDefn) throws BirtException {
        IPreparedCubeQuery pq = session.prepare(queryDefn);
        return (ICubeQueryResults)session.execute((IBasePreparedQuery)pq, null, new ScriptContext());
    }

    public void populateApplicationContext(DataSetHandle handle, DataRequestSession session) throws BirtException {
    }

    public void setExecutionContext(ExecutionContext context) {
        this.executionContext = context;
    }

    public void populateApplicationContext(CubeHandle handle, DataRequestSession session) throws BirtException {
    }

    public void registerSession(ReportElementHandle handle, DataRequestSession session) throws BirtException {
        if (handle instanceof DataSetHandle) {
            DataService.getInstance().registerSession((DataSetHandle)handle, session);
        } else if (handle instanceof CubeHandle) {
            DataService.getInstance().registerSession((CubeHandle)handle, session);
        }
    }

    public void unregisterSession(DataRequestSession session) throws BirtException {
        if (session != null) {
            DataService.getInstance().unRegisterSession(session);
        }
    }
}

