/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import org.eclipse.birt.chart.reportitem.api.ChartReportItemHelper;
import org.eclipse.birt.chart.ui.swt.ColorPalette;
import org.eclipse.birt.chart.ui.swt.ColumnBindingInfo;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ColumnNamesTableDragListener
extends DragSourceAdapter {
    private Table table;
    private TableItem item;
    private ExtendedItemHandle itemHandle;

    public ColumnNamesTableDragListener(Table table, ExtendedItemHandle itemhandle) {
        this.table = table;
        this.itemHandle = itemhandle;
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.item != null) {
            event.data = ((ColumnBindingInfo)this.item.getData()).getName();
        }
    }

    public void dragStart(DragSourceEvent event) {
        if (ChartReportItemHelper.instance().getBindingCubeHandle((ReportItemHandle)this.itemHandle) != null) {
            event.doit = false;
        } else {
            int index = this.table.getSelectionIndex();
            if (index < 0) {
                this.item = null;
                event.doit = false;
            } else {
                this.item = this.table.getItem(index);
                String strColumnName = ((ColumnBindingInfo)this.item.getData()).getName();
                event.doit = strColumnName != null && strColumnName.length() > 0;
            }
        }
    }

    public void dragFinished(DragSourceEvent event) {
        super.dragFinished(event);
        if (event.detail == 1 && this.item != null) {
            String strColumnName = ((ColumnBindingInfo)this.item.getData()).getName();
            this.item.setBackground(ColorPalette.getInstance().getColor(strColumnName));
        }
    }
}

