/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.ide.dialog.HandlerClassSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ClassFinder {
    protected static final Logger logger = Logger.getLogger(ClassFinder.class.getName());
    private static final String TASK_START = Messages.getString((String)"ClassFinder.TaskStart");
    private static final String DIALOG_TITLE = Messages.getString((String)"ClassFinder.DialogTitle");
    private static final String DIALOG_MESSAGE = Messages.getString((String)"ClassFinder.DialogMessage");
    private static final String ERROR_MESSAGE = Messages.getString((String)"ClassFinder.ErrorMessage");
    private static final String ID = "Hnadle class finder";
    private String parentClassName = null;

    public void doFindClasses(Object[] elements, Set result, IProgressMonitor pm) throws InterruptedException {
        int nElements = elements.length;
        pm.beginTask(TASK_START, nElements);
        try {
            int i = 0;
            while (i < nElements) {
                try {
                    this.collectTypes(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                }
                catch (CoreException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            pm.done();
        }
    }

    private void collectTypes(Object element, IProgressMonitor pm, Set result) throws CoreException {
        pm.beginTask(TASK_START, 10);
        if (element instanceof IProject && this.hasJavaNature((IProject)element)) {
            IJavaProject javaElement = JavaCore.create((IProject)((IProject)element));
            List testCases = this.findCLasses((IJavaElement)javaElement, (IProgressMonitor)new SubProgressMonitor(pm, 7));
            result.addAll(testCases);
            pm.done();
        }
    }

    private List findCLasses(IJavaElement element, IProgressMonitor pm) throws JavaModelException {
        ArrayList<IType> found = new ArrayList<IType>();
        IJavaProject javaProject = element.getJavaProject();
        IType testCaseType = this.classType(javaProject);
        if (testCaseType == null) {
            return found;
        }
        IType[] subtypes = javaProject.newTypeHierarchy(testCaseType, this.getRegion(element), pm).getAllSubtypes(testCaseType);
        if (subtypes == null) {
            throw new JavaModelException(new CoreException((IStatus)new Status(4, ID, 101, ERROR_MESSAGE, null)));
        }
        int i = 0;
        while (i < subtypes.length) {
            try {
                if (this.hasValidModifiers(subtypes[i])) {
                    found.add(subtypes[i]);
                }
            }
            catch (JavaModelException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            ++i;
        }
        return found;
    }

    private IType classType(IJavaProject javaProject) {
        block3: {
            try {
                if (this.getParentClassName() != null && this.getParentClassName().length() != 0) break block3;
                return null;
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        return javaProject.findType(this.getParentClassName());
    }

    private IRegion getRegion(IJavaElement element) throws JavaModelException {
        IRegion result = JavaCore.newRegion();
        if (element.getElementType() == 2) {
            IPackageFragmentRoot[] roots = ((IJavaProject)element).getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (!roots[i].isArchive()) {
                    result.add((IJavaElement)roots[i]);
                }
                ++i;
            }
        } else {
            result.add(element);
        }
        return result;
    }

    private boolean hasValidModifiers(IType type) throws JavaModelException {
        return !Flags.isAbstract((int)type.getFlags()) && Flags.isPublic((int)type.getFlags());
    }

    private boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IType[] findClasses(final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    ClassFinder.this.doFindClasses(elements, result, pm);
                }
            };
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    public String getFinderClassName() {
        Object[] projects = this.getWorkspaceRoot().getProjects();
        if (projects == null || projects.length == 0) {
            return null;
        }
        IType[] types = null;
        try {
            types = this.findClasses(projects);
        }
        catch (InterruptedException | InvocationTargetException e) {
            return null;
        }
        Shell shell = UIUtil.getDefaultShell();
        HandlerClassSelectionDialog dialog = new HandlerClassSelectionDialog(shell, types);
        dialog.setTitle(DIALOG_TITLE);
        dialog.setMessage(DIALOG_MESSAGE);
        if (dialog.open() == 1) {
            return null;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return null;
        }
        IType type = (IType)results[0];
        if (type != null) {
            return type.getFullyQualifiedName('.');
        }
        return null;
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public void setParentClassName(String parentClassName) {
        this.parentClassName = parentClassName;
    }
}

