/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceSynchronizer;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class IDEResourceSynchronizer
extends ReportResourceSynchronizer {
    public void notifyResourceChanged(IReportResourceChangeEvent event) {
        this.refreshWorkspace(event);
        this.notifyListeners(event);
    }

    private void refreshWorkspace(IReportResourceChangeEvent event) {
        if (event != null) {
            Object data = event.getData();
            if (data instanceof IPath) {
                this.refreshResource((IPath)data);
            } else if (data instanceof IPath[]) {
                IPath[] iPathArray = (IPath[])data;
                int n = iPathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path = iPathArray[n2];
                    this.refreshResource(path);
                    ++n2;
                }
            }
        }
    }

    private void refreshResource(IPath resPath) {
        IFile[] res = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(resPath);
        if (res.length == 0 && (res = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation(resPath)).length == 0) {
            return;
        }
        try {
            IFile[] targes = res;
            new WorkspaceModifyOperation((IResource[])targes){
                private final /* synthetic */ IResource[] val$targes;
                {
                    this.val$targes = iResourceArray;
                }

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    IResource[] iResourceArray = this.val$targes;
                    int n = this.val$targes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource rc = iResourceArray[n2];
                        rc.refreshLocal(2, null);
                        ++n2;
                    }
                }
            }.run(null);
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }
}

