/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.ResetAttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.SimpleComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.ComboSection;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.SeperatorSection;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.SimpleComboSection;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SectionPage
extends ResetAttributePage {
    private SimpleComboSection masterSection;
    private SeperatorSection sepSection;

    @Override
    public void buildUI(Composite parent) {
        super.buildUI(parent);
        this.container.setLayout((Layout)WidgetUtil.createGridLayout((int)5));
        ComboPropertyDescriptorProvider beforeProvider = new ComboPropertyDescriptorProvider("pageBreakBefore", "Style");
        beforeProvider.enableReset(true);
        SimpleComboPropertyDescriptorProvider masterProvider = new SimpleComboPropertyDescriptorProvider("masterPage", "Style");
        masterProvider.enableReset(true);
        ComboPropertyDescriptorProvider afterProvider = new ComboPropertyDescriptorProvider("pageBreakAfter", "Style");
        afterProvider.enableReset(true);
        ComboPropertyDescriptorProvider insideProvider = new ComboPropertyDescriptorProvider("pageBreakInside", "Style");
        insideProvider.enableReset(true);
        ComboSection beforeSection = new ComboSection(beforeProvider.getDisplayName(), this.container, true);
        ComboSection insideSection = new ComboSection(insideProvider.getDisplayName(), this.container, true);
        this.masterSection = new SimpleComboSection(masterProvider.getDisplayName(), this.container, true);
        ComboSection afterSection = new ComboSection(afterProvider.getDisplayName(), this.container, true);
        this.sepSection = new SeperatorSection(this.container, 256);
        beforeSection.setProvider(beforeProvider);
        this.masterSection.setProvider(masterProvider);
        afterSection.setProvider(afterProvider);
        insideSection.setProvider(insideProvider);
        beforeSection.setWidth(200);
        this.masterSection.setWidth(200);
        afterSection.setWidth(200);
        insideSection.setWidth(200);
        beforeSection.setLayoutNum(2);
        afterSection.setLayoutNum(3);
        this.masterSection.setGridPlaceholder(3, true);
        afterSection.setGridPlaceholder(1, true);
        insideSection.setGridPlaceholder(3, true);
        this.addSection("SECION_PAGE_BREAK_BEFORE", beforeSection);
        this.addSection("SECION_PAGE_BREAK_AFTER", afterSection);
        this.addSection("SECION_PAGE_BREAK_INSIDE", insideSection);
        this.addSection("SECION_SEPERATOR", this.sepSection);
        this.addSection("SECION_MASTER_PAGE", this.masterSection);
        this.createSections();
        this.layoutSections();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setVisible();
        this.container.layout(true);
        this.container.redraw();
    }

    protected void setVisible() {
        if (DEUtil.getInputSize((Object)this.input) == 1 && DEUtil.getInputFirstElement((Object)this.input) instanceof DesignElementHandle && this.isElementInMasterPage((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input))) {
            this.masterSection.setVisible(false);
            this.sepSection.setVisible(false);
        } else {
            this.masterSection.setVisible(true);
            this.sepSection.setVisible(true);
        }
    }

    protected boolean isElementInMasterPage(DesignElementHandle elementHandle) {
        ModuleHandle root = elementHandle.getRoot();
        DesignElementHandle container = elementHandle;
        while (container != null && container != root) {
            if (container instanceof MasterPageHandle) {
                return true;
            }
            container = container.getContainer();
        }
        return false;
    }
}

