/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.ui.extension.IAggregationCellViewProvider;
import org.eclipse.birt.report.item.crosstab.ui.extension.SwitchCellInfo;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public class AggregationCellProviderWrapper {
    private ProviderComparator providerComparator = new ProviderComparator(false);
    ExtendedItemHandle handle;
    CrosstabReportItemHandle crosstab;
    private IAggregationCellViewProvider[] providers;
    private List<AggregationCellHandle> filterCellList = new ArrayList<AggregationCellHandle>();
    private List<SwitchCellInfo> switchList = new ArrayList<SwitchCellInfo>();

    public AggregationCellProviderWrapper(ExtendedItemHandle handle) {
        IReportItem reportItem = null;
        try {
            reportItem = handle.getReportItem();
        }
        catch (ExtendedElementException e) {
            e.printStackTrace();
        }
        assert (reportItem instanceof CrosstabReportItemHandle);
        this.crosstab = (CrosstabReportItemHandle)reportItem;
        this.handle = handle;
        this.inilitializeProviders();
    }

    public AggregationCellProviderWrapper(CrosstabReportItemHandle crosstab) {
        this((ExtendedItemHandle)crosstab.getModelHandle());
    }

    private void inilitializeProviders() {
        Object[] obj = ElementAdapterManager.getAdapters((Object)this.handle, IAggregationCellViewProvider.class);
        if (obj instanceof Object[]) {
            Object[] arrays = obj;
            Arrays.sort(arrays, this.providerComparator);
            this.providers = new IAggregationCellViewProvider[arrays.length + 1];
            this.providers[0] = null;
            int i = 0;
            while (i < arrays.length) {
                IAggregationCellViewProvider tmp;
                this.providers[i + 1] = tmp = (IAggregationCellViewProvider)arrays[i];
                ++i;
            }
        }
    }

    public IAggregationCellViewProvider[] getAllProviders() {
        return this.providers;
    }

    public boolean switchView(String expectedView, AggregationCellHandle cell) {
        boolean ret = false;
        IAggregationCellViewProvider provider = this.getMatchProvider(cell);
        if (provider != null && !provider.getViewName().equals(expectedView)) {
            provider.restoreView(cell);
        }
        if ((provider = this.getProvider(expectedView)) == null) {
            return ret;
        }
        ret = true;
        provider.switchView(cell);
        this.filterCellList.add(cell);
        return ret;
    }

    public void restoreViews(SwitchCellInfo info) {
        AggregationCellHandle cell = info.getAggregationCell();
        String expectedView = info.getExpectedView();
        if (expectedView == null || expectedView.length() == 0) {
            return;
        }
        IAggregationCellViewProvider provider = this.getMatchProvider(cell);
        if (provider != null) {
            provider.restoreView(cell);
        }
    }

    public boolean switchView(SwitchCellInfo info) {
        boolean ret = false;
        AggregationCellHandle cell = info.getAggregationCell();
        String expectedView = info.getExpectedView();
        if (expectedView == null || expectedView.length() == 0) {
            return false;
        }
        IAggregationCellViewProvider provider = this.getMatchProvider(cell);
        if (provider != null) {
            if (provider.getViewName().equals(expectedView)) {
                return false;
            }
            provider.restoreView(cell);
        }
        if ((provider = this.getProvider(expectedView)) == null) {
            return ret;
        }
        ret = true;
        provider.switchView(info);
        this.filterCellList.add(cell);
        return ret;
    }

    public IAggregationCellViewProvider getProvider(String viewName) {
        IAggregationCellViewProvider retProvider = null;
        if (viewName == null || this.providers == null || this.providers.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < this.providers.length) {
            if (this.providers[i] != null && this.providers[i].getViewName().equals(viewName)) {
                retProvider = this.providers[i];
                break;
            }
            ++i;
        }
        return retProvider;
    }

    public IAggregationCellViewProvider getMatchProvider(AggregationCellHandle cell) {
        IAggregationCellViewProvider retProvider = null;
        if (this.providers == null || this.providers.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < this.providers.length) {
            if (this.providers[i] != null && this.providers[i].matchView(cell)) {
                retProvider = this.providers[i];
                break;
            }
            ++i;
        }
        return retProvider;
    }

    public void updateAggregationCell(AggregationCellHandle cell) {
        IAggregationCellViewProvider provider = this.getMatchProvider(cell);
        if (provider != null) {
            provider.updateView(cell);
        }
    }

    public void updateAggregationCell(AggregationCellHandle cell, int type) {
        IAggregationCellViewProvider provider = this.getMatchProvider(cell);
        if (provider != null) {
            provider.updateView(cell, type);
        }
    }

    public void addSwitchInfo(SwitchCellInfo info) {
        this.switchList.add(info);
    }

    public void updateAllAggregationCells() {
        int measureCount = this.crosstab.getMeasureCount();
        int i = 0;
        while (i < measureCount) {
            MeasureViewHandle measure = this.crosstab.getMeasure(i);
            if (measure != null && !(measure instanceof ComputedMeasureViewHandle)) {
                AggregationCellHandle cell = measure.getCell();
                if (this.filterCellList.indexOf(cell) < 0) {
                    this.updateAggregationCell(cell);
                }
                int j = 0;
                while (j < measure.getAggregationCount()) {
                    cell = measure.getAggregationCell(j);
                    if (this.filterCellList.indexOf(cell) < 0) {
                        this.updateAggregationCell(cell);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.filterCellList.clear();
    }

    public void updateAllAggregationCells(int types) {
        int measureCount = this.crosstab.getMeasureCount();
        int i = 0;
        while (i < measureCount) {
            MeasureViewHandle measure = this.crosstab.getMeasure(i);
            if (measure != null && !(measure instanceof ComputedMeasureViewHandle)) {
                AggregationCellHandle cell = measure.getCell();
                if (this.filterCellList.indexOf(cell) < 0) {
                    this.updateAggregationCell(cell, types);
                }
                int j = 0;
                while (j < measure.getAggregationCount()) {
                    cell = measure.getAggregationCell(j);
                    if (this.filterCellList.indexOf(cell) < 0) {
                        this.updateAggregationCell(cell, types);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.filterCellList.clear();
    }

    public void switchViews() {
        int i = 0;
        while (i < this.switchList.size()) {
            SwitchCellInfo info = this.switchList.get(i);
            this.switchView(info);
            ++i;
        }
        this.switchList.clear();
    }

    public String getViewDisplayName(String viewName) {
        if (viewName == null || viewName.length() == 0) {
            return "";
        }
        int i = 0;
        while (i < this.providers.length) {
            String cmpName;
            if (this.providers[i] != null && (cmpName = this.providers[i].getViewName()) != null && cmpName.equals(viewName)) {
                return this.providers[i].getViewDisplayName();
            }
            ++i;
        }
        return "";
    }

    static class ProviderComparator
    implements Comparator {
        private boolean ascending = true;

        public ProviderComparator(boolean ascending) {
            this.ascending = ascending;
        }

        public ProviderComparator() {
            this(true);
        }

        public int compare(Object arg0, Object arg1) {
            assert (arg0 instanceof IAggregationCellViewProvider);
            assert (arg1 instanceof IAggregationCellViewProvider);
            String name0 = ((IAggregationCellViewProvider)arg0).getViewDisplayName();
            String name1 = ((IAggregationCellViewProvider)arg1).getViewDisplayName();
            if (name0 == null) {
                name0 = "";
            }
            if (name1 == null) {
                name1 = "";
            }
            if (this.ascending) {
                return Collator.getInstance().compare(name0, name1);
            }
            return Collator.getInstance().compare(name1, name0);
        }
    }
}

