/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.dialogs.AbstractParameterControlHelper;
import org.eclipse.birt.report.designer.ui.dialogs.InputParameterDialog;
import org.eclipse.birt.report.designer.ui.dialogs.InputParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;

class RadioParameterControlHelper
extends AbstractParameterControlHelper {
    private List<IParameterSelectionChoice> list;
    private List<Button> radioItems = new ArrayList<Button>();

    public RadioParameterControlHelper(InputParameterDialog dialog) {
        super(dialog);
    }

    @Override
    protected void createParameterControl() {
        this.doCreateRadioParameter();
    }

    @Override
    protected void prepare() {
        this.needTypeCheck = true;
        this.list = this.parameter.getValueList();
        boolean isContainNull = false;
        for (IParameterSelectionChoice choice : this.list) {
            if (!InputParameterSelectionChoice.BLANKVALUECHOICE.getValue().equals(choice.getValue())) continue;
            isContainNull = true;
        }
        if (!this.isRequired && !isContainNull) {
            this.list.add(InputParameterSelectionChoice.NULLVALUECHOICE);
        }
    }

    private void doCreateRadioParameter() {
        int i = 0;
        while (i < this.list.size()) {
            if (i > 0) {
                new Label(this.parent, 0);
            }
            IParameterSelectionChoice choice = this.list.get(i);
            String choiceLabel = this.getChoiceLabel(choice);
            Button button = this.createRadioButton(choiceLabel, choice.getValue());
            this.initRadioButton(button, choice, choiceLabel);
            ++i;
        }
    }

    private void initRadioButton(Button button, IParameterSelectionChoice choice, String choiceLabel) {
        if (choice.getValue() == this.defaultValue || choice.getValue() != null && choice.getValue().equals(this.defaultValue)) {
            button.setSelection(true);
            this.putConfigValue(this.paramterHandleName, button.getData());
            this.clearSelectRadio(this.radioItems);
        } else if (this.defaultValue == null && choiceLabel.equals((Object)InputParameterSelectionChoice.NULLVALUECHOICE)) {
            button.setSelection(true);
            this.removeConfigValue(this.paramterHandleName);
            this.clearSelectRadio(this.radioItems);
        }
        this.radioItems.add(button);
    }

    private String getChoiceLabel(IParameterSelectionChoice choice) {
        String choiceLabel = choice.getLabel();
        if (choiceLabel == null) {
            choiceLabel = choice.getValue() == null ? NULL_VALUE_STR : this.getFormatLabelString(choice, this.parameter);
        }
        return choiceLabel;
    }

    private Button createRadioButton(String labelText, Object buttonData) {
        Button button = new Button(this.parent, 16);
        button.setText(labelText);
        button.setData(buttonData);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                RadioParameterControlHelper.this.putConfigValue(RadioParameterControlHelper.this.paramterHandleName, button.getData());
            }
        });
        return button;
    }

    private void clearSelectRadio(List<Button> radioItems) {
        for (Button b : radioItems) {
            b.setSelection(false);
        }
    }
}

