/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.birt.report.designer.internal.ui.preferences.CPListElement;
import org.eclipse.birt.report.designer.internal.ui.preferences.CPListLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.preferences.ITreeListAdapter;
import org.eclipse.birt.report.designer.internal.ui.preferences.LayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.preferences.TreeListDialogField;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.DialogField;
import org.eclipse.birt.report.designer.ui.preferences.IDialogFieldListener;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ClassPathBlock
extends OptionsConfigurationBlock {
    private static final String[] ALL_ARCHIVES_FILTER_EXTENSIONS = new String[]{"*.jar;*.zip", "*.*"};
    public static final String[] JAR_ZIP_FILTER_EXTENSIONS = new String[]{"*.jar;*.zip"};
    private static OptionsConfigurationBlock.Key PREF_CLASSPATH;
    private final TreeListDialogField fLibrariesList;
    private static final int IDX_ADDEXT = 0;
    private static final int IDX_ADDEXTFOL = 1;
    private static final int IDX_UP = 3;
    private static final int IDX_DOWN = 4;
    private static final int IDX_EDIT = 5;
    private static final int IDX_REMOVE = 6;
    private static final String ENTRY_SEPARATOR = "|";
    private static String lastUsedPath;

    static {
        lastUsedPath = "";
    }

    public ClassPathBlock(IStatusChangeListener context, IProject project) {
        super(context, ReportPlugin.getDefault(), project);
        PREF_CLASSPATH = this.getReportKey("org.eclipse.birt.report.designer.ui.preferences.classpath");
        String[] stringArray = new String[7];
        stringArray[0] = Messages.getString((String)"ClassPathBlock_button.addExtJars");
        stringArray[1] = Messages.getString((String)"ClassPathBlock_button.addExtFolder");
        stringArray[3] = Messages.getString((String)"ClassPathBlock_button.up");
        stringArray[4] = Messages.getString((String)"ClassPathBlock_button.down");
        stringArray[5] = Messages.getString((String)"ClassPathBlock_button.edit");
        stringArray[6] = Messages.getString((String)"ClassPathBlock_button.remove");
        String[] buttonLabels = stringArray;
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        this.fLibrariesList.setLabelText(Messages.getString((String)"ClassPathBlock_label.LibrariesList"));
        this.fLibrariesList.enableButton(3, false);
        this.fLibrariesList.enableButton(4, false);
        this.fLibrariesList.enableButton(6, false);
        this.fLibrariesList.enableButton(5, false);
        this.setKeys(this.getKeys());
        this.fLibrariesList.setElements(ClassPathBlock.readClassPathEntry(this.getValue(PREF_CLASSPATH)));
    }

    private OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{PREF_CLASSPATH};
        return keys;
    }

    @Override
    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        return composite;
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 0: {
                libentries = this.openExtJarFileDialog(null);
                break;
            }
            case 1: {
                libentries = this.openExternalClassFolderDialog(null);
                break;
            }
            case 3: {
                libentries = this.getSelection().toArray(new CPListElement[this.getSelection().size()]);
                this.fLibrariesList.up();
                break;
            }
            case 4: {
                libentries = this.getSelection().toArray(new CPListElement[this.getSelection().size()]);
                this.fLibrariesList.down();
                break;
            }
            case 5: {
                this.editEntry();
                return;
            }
            case 6: {
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fLibrariesList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            this.fLibrariesList.addElements(elementsToAdd);
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    protected void libaryPageDoubleClicked(TreeListDialogField field) {
        List selection = field.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        return selElements.size() != 0;
    }

    private void editEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        }
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement[] res = null;
        IPath path = elem.getPath();
        File file = path.toFile();
        res = file.isDirectory() ? this.openExternalClassFolderDialog(elem) : this.openExtJarFileDialog(elem);
        if (res != null && res.length > 0) {
            CPListElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fLibrariesList.replaceElement(elem, curr);
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        List selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(5, this.canEdit(selElements));
        this.fLibrariesList.enableButton(6, this.canRemove(selElements));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selElements);
        this.fLibrariesList.enableButton(0, noAttributes);
        this.fLibrariesList.enableButton(1, noAttributes);
        this.fLibrariesList.enableButton(3, this.fLibrariesList.canMoveUp(selElements));
        this.fLibrariesList.enableButton(4, this.fLibrariesList.canMoveDown(selElements));
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        return elem instanceof CPListElement;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
    }

    private CPListElement[] openExtJarFileDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = ClassPathBlock.chooseExternalJAREntries(this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new CPListElement(selected[i]));
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPath path = existing.getPath();
            IPath configured = ClassPathBlock.configureExternalJAREntry(this.getShell(), path);
            if (configured != null) {
                return new CPListElement[]{new CPListElement(configured)};
            }
        }
        return null;
    }

    private CPListElement[] openExternalClassFolderDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = ClassPathBlock.chooseExternalClassFolderEntries(this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new CPListElement(selected[i]));
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPath configured = ClassPathBlock.configureExternalClassFolderEntries(this.getShell(), existing.getPath());
            if (configured != null) {
                return new CPListElement[]{new CPListElement(configured)};
            }
        }
        return null;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setFocus() {
        this.fLibrariesList.setFocus();
    }

    protected boolean containsOnlyTopLevelEntries(List selElements) {
        if (selElements.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (!(elem instanceof CPListElement)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List<String> getEntries(String value) {
        List elements = ClassPathBlock.readClassPathEntry(value);
        ArrayList<String> retValue = new ArrayList<String>();
        int i = 0;
        while (i < elements.size()) {
            retValue.add(((CPListElement)elements.get(i)).getPath().toFile().getAbsolutePath());
            ++i;
        }
        return retValue;
    }

    private static List readClassPathEntry(String value) {
        ArrayList<CPListElement> retValue = new ArrayList<CPListElement>();
        if (value == null || value.length() == 0) {
            return retValue;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ENTRY_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String entry = tokenizer.nextToken();
            if (entry == null || entry.length() == 0) continue;
            boolean init = false;
            Path path = new Path(entry);
            retValue.add(new CPListElement((IPath)path));
        }
        return retValue;
    }

    @Override
    public boolean performApply() {
        StringBuilder buffer = new StringBuilder();
        List list = this.fLibrariesList.getElements();
        int i = 0;
        while (i < list.size()) {
            StringBuilder entryScript = new StringBuilder();
            CPListElement element = (CPListElement)list.get(i);
            entryScript.append(element.getPath().toFile().getAbsolutePath());
            if (i != list.size() - 1) {
                entryScript.append(ENTRY_SEPARATOR);
            }
            buffer.append(entryScript.toString());
            ++i;
        }
        String value = buffer.toString();
        this.setValue(PREF_CLASSPATH, value);
        return super.performApply();
    }

    @Override
    public void performDefaults() {
        this.fLibrariesList.setElements(new ArrayList());
        super.performDefaults();
    }

    @Override
    public void useProjectSpecificSettings(boolean enable) {
        super.useProjectSpecificSettings(enable);
    }

    public static IPath[] chooseExternalJAREntries(Shell shell) {
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(shell, 2);
        dialog.setText(Messages.getString((String)"ClassPathBlock_FileDialog.jar.text"));
        dialog.setFilterExtensions(ALL_ARCHIVES_FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        IPath filterPath = Path.fromOSString((String)dialog.getFilterPath());
        IPath[] elems = new IPath[nChosen];
        int i = 0;
        while (i < nChosen) {
            elems[i] = filterPath.append(fileNames[i]).makeAbsolute();
            ++i;
        }
        lastUsedPath = dialog.getFilterPath();
        return elems;
    }

    public static IPath configureExternalJAREntry(Shell shell, IPath initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        String lastUsedPath = initialEntry.removeLastSegments(1).toOSString();
        FileDialog dialog = new FileDialog(shell, 4);
        dialog.setText(Messages.getString((String)"ClassPathBlock_FileDialog.edit.text"));
        dialog.setFilterExtensions(JAR_ZIP_FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        dialog.setFileName(initialEntry.lastSegment());
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        return Path.fromOSString((String)res).makeAbsolute();
    }

    public static IPath[] chooseExternalClassFolderEntries(Shell shell) {
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        DirectoryDialog dialog = new DirectoryDialog(shell, 2);
        dialog.setText(Messages.getString((String)"ClassPathBlock_FolderDialog.text"));
        dialog.setMessage(Messages.getString((String)"ClassPathBlock_FolderDialog.message"));
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        File file = new File(res);
        if (file.isDirectory()) {
            return new IPath[]{new Path(file.getAbsolutePath())};
        }
        return null;
    }

    public static IPath configureExternalClassFolderEntries(Shell shell, IPath initialEntry) {
        DirectoryDialog dialog = new DirectoryDialog(shell, 4);
        dialog.setText(Messages.getString((String)"ClassPathBlock_FolderDialog.edit.text"));
        dialog.setMessage(Messages.getString((String)"ClassPathBlock_FolderDialog.edit.message"));
        dialog.setFilterPath(initialEntry.toString());
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        File file = new File(res);
        if (file.isDirectory()) {
            return new Path(file.getAbsolutePath());
        }
        return null;
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField field, int index) {
            ClassPathBlock.this.libaryPageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(TreeListDialogField field) {
            ClassPathBlock.this.libaryPageSelectionChanged(field);
        }

        @Override
        public void doubleClicked(TreeListDialogField field) {
            ClassPathBlock.this.libaryPageDoubleClicked(field);
        }

        @Override
        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            ClassPathBlock.this.libaryPageKeyPressed(field, event);
        }

        @Override
        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(false);
            }
            return this.EMPTY_ARR;
        }

        @Override
        public Object getParent(TreeListDialogField field, Object element) {
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            ClassPathBlock.this.libaryPageDialogFieldChanged(field);
        }
    }
}

