/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.util.UnicodeUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.GenericModuleParserHandler;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ParserFactory;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ModuleReader {
    private static Logger logger = Logger.getLogger(ModuleReader.class.getName());

    /*
     * Unable to fully structure code
     */
    protected Module readModule(ModuleParserHandler handler, InputStream inputStream) throws DesignFileException {
        block21: {
            if (!ModuleReader.$assertionsDisabled && handler == null) {
                throw new AssertionError();
            }
            internalStream = inputStream;
            if (!inputStream.markSupported()) {
                internalStream = new BufferedInputStream(inputStream);
            }
            if (!ModuleReader.$assertionsDisabled && !internalStream.markSupported()) {
                throw new AssertionError();
            }
            signature = null;
            parser = null;
            properties = null;
            try {
                try {
                    signature = ModuleReader.checkUTFSignature(internalStream, handler.getFileName());
                    properties = new HashMap<String, ModuleParserHandler.ModuleLexicalHandler>(2);
                    properties.put("http://xml.org/sax/properties/lexical-handler", new ModuleParserHandler.ModuleLexicalHandler(handler));
                    parser = ParserFactory.getInstance().getParser(properties);
                    inputSource = new InputSource(internalStream);
                    inputSource.setEncoding(signature);
                    parser.parse(inputSource, (DefaultHandler)handler);
                    warningExceptionList = handler.getErrorHandler().getWarnings();
                    if (handler.isLaterVersion() && (handler.getModule().getOptions() == null || handler.getModule().getOptions().isSupportedUnknownVersion()) && warningExceptionList != null && warningExceptionList.size() > 0) {
                        for (XMLParserException xmlException : warningExceptionList) {
                            ModuleReader.logger.log(Level.WARNING, xmlException.getMessage());
                        }
                    }
                    break block21;
                }
                catch (SAXException e) {
                    errors = handler.getErrorHandler().getErrors();
                    i = 0;
                    ** while (i < errors.size())
                }
lbl-1000:
                // 1 sources

                {
                    exception = errors.get(i);
                    ModuleReader.logger.log(Level.SEVERE, exception.getMessage());
                    ++i;
                    continue;
                }
lbl35:
                // 1 sources

                if (e.getException() instanceof DesignFileException) {
                    throw (DesignFileException)e.getException();
                }
                throw new DesignFileException(handler.getFileName(), errors, e);
                catch (ParserConfigurationException e) {
                    throw new DesignFileException(handler.getFileName(), handler.getErrorHandler().getErrors(), e);
                }
                catch (IOException e) {
                    ModuleReader.logger.log(Level.SEVERE, "IO error occurs " + e.getLocalizedMessage() + " on line " + handler.getCurrentLineNo());
                    throw new DesignFileException(handler.getFileName(), handler.getErrorHandler().getErrors(), e);
                }
            }
            catch (Throwable var11_17) {
                if (parser != null) {
                    try {
                        ParserFactory.getInstance().releaseParser(parser, properties);
                    }
                    catch (Exception var12_18) {
                        // empty catch block
                    }
                }
                if (properties != null) {
                    properties.clear();
                }
                throw var11_17;
            }
        }
        if (parser != null) {
            try {
                ParserFactory.getInstance().releaseParser(parser, properties);
            }
            catch (Exception var12_19) {
                // empty catch block
            }
        }
        if (properties != null) {
            properties.clear();
        }
        module = handler.getModule();
        module.setUTFSignature(signature);
        module.setValid(true);
        return module;
    }

    public Module readModule(ModuleParserHandler handler) throws DesignFileException {
        assert (handler != null);
        InputStream in = null;
        try {
            if (handler instanceof GenericModuleParserHandler) {
                URL url = ModelUtil.getURLPresentation(handler.getFileName());
                if (url != null) {
                    ((GenericModuleParserHandler)handler).location = url;
                    in = url.openStream();
                }
            } else {
                String location = handler.getModule().getLocation();
                if (location == null) {
                    throw new IOException();
                }
                URL url = new URL(location);
                in = url.openStream();
            }
        }
        catch (IOException e) {
            DesignParserException ex = new DesignParserException("Error.DesignParserException.FILE_NOT_FOUND", new String[]{handler.getFileName()}, (Throwable)e);
            ArrayList<DesignParserException> exceptionList = new ArrayList<DesignParserException>();
            exceptionList.add(ex);
            throw new DesignFileException(handler.getFileName(), exceptionList);
        }
        BufferedInputStream inputStream = new BufferedInputStream(in);
        assert (((InputStream)inputStream).markSupported());
        Module module = this.readModule(handler, inputStream);
        try {
            ((InputStream)inputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        inputStream = null;
        return module;
    }

    protected static String checkUTFSignature(InputStream inputStream, String fileName) throws IOException, SAXException {
        String encoding = UnicodeUtil.checkUTFSignature(inputStream);
        if (encoding != null && !"UTF-8".equals(encoding)) {
            DesignParserException cause = new DesignParserException("Error.DesignParserException.UNSUPPORTED_ENCODING");
            DesignFileException fileException = new DesignFileException(fileName, cause);
            throw new SAXException(fileException);
        }
        return encoding;
    }
}

