/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabMeasureRowExecutor;

public class CrosstabMeasureExecutor
extends BaseCrosstabExecutor {
    private int currentElement;
    private List elements;

    public CrosstabMeasureExecutor(BaseCrosstabExecutor parent) {
        super(parent);
    }

    @Override
    public void close() {
        super.close();
        this.elements = null;
    }

    @Override
    public IContent execute() {
        ITableBandContent content = this.context.getReportContent().createTableBandContent();
        content.setBandType(0);
        this.initializeContent(content, null);
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.elements = new ArrayList();
        this.currentElement = 0;
        int count = this.crosstabItem.getMeasureCount();
        int totalRow = count > 1 && "vertical".equals(this.crosstabItem.getMeasureDirection()) ? count : Math.min(count, 1);
        int i = 0;
        while (i < totalRow) {
            this.elements.add(new CrosstabMeasureRowExecutor(this, i));
            ++i;
        }
    }

    @Override
    public IReportItemExecutor getNextChild() {
        return (IReportItemExecutor)this.elements.get(this.currentElement++);
    }

    @Override
    public boolean hasNextChild() {
        return this.currentElement < this.elements.size();
    }
}

