/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabMeasureRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;

public abstract class BaseRowExecutor
extends BaseCrosstabExecutor {
    private static Logger logger = Logger.getLogger(CrosstabMeasureRowExecutor.class.getName());
    protected int rowIndex;
    protected long currentEdgePosition;
    protected int rowSpan;
    protected int colSpan;
    protected int currentChangeType;
    protected int currentColIndex;
    protected int lastMeasureIndex;
    protected int lastDimensionIndex;
    protected int lastLevelIndex;
    protected int totalMeasureCount;
    protected boolean measureDetailStarted;
    protected boolean measureSubTotalStarted;
    protected boolean measureGrandTotalStarted;
    protected boolean hasLast;
    protected boolean isFirst;
    protected boolean isVerticalMeasure;
    protected IReportItemExecutor nextExecutor;
    private AggregationCellHandle[] measureCellCache;

    protected BaseRowExecutor(BaseCrosstabExecutor parent, int rowIndex) {
        super(parent);
        this.rowIndex = rowIndex;
    }

    @Override
    public void close() {
        super.close();
        this.nextExecutor = null;
        this.measureCellCache = null;
    }

    protected void initMeasureCache() {
        this.measureCellCache = new AggregationCellHandle[this.crosstabItem.getMeasureCount()];
        int i = 0;
        while (i < this.measureCellCache.length) {
            this.measureCellCache[i] = this.crosstabItem.getMeasure(i).getCell();
            ++i;
        }
    }

    protected AggregationCellHandle getMeasureCell(int mx) {
        return this.measureCellCache[mx];
    }

    protected void prepareChildren() {
        this.currentChangeType = -1;
        this.currentColIndex = -1;
        this.currentEdgePosition = -1L;
        this.rowSpan = 1;
        this.colSpan = 0;
        this.lastMeasureIndex = -1;
        this.totalMeasureCount = this.crosstabItem.getMeasureCount();
        this.isVerticalMeasure = "vertical".equals(this.crosstabItem.getMeasureDirection());
        this.measureDetailStarted = false;
        this.measureSubTotalStarted = false;
        this.measureGrandTotalStarted = false;
        this.hasLast = false;
        this.isFirst = true;
    }

    protected AggregationCellHandle getAggregationCell(int rowDimensionIndex, int rowLevelIndex, int colDimensionIndex, int colLevelIndex, int measureIndex) {
        if (measureIndex >= 0 && measureIndex < this.totalMeasureCount) {
            String rdName = null;
            String rlName = null;
            String cdName = null;
            String clName = null;
            if (rowDimensionIndex >= 0 && rowLevelIndex >= 0) {
                DimensionViewHandle rdv = this.crosstabItem.getDimension(0, rowDimensionIndex);
                LevelViewHandle rlv = rdv.getLevel(rowLevelIndex);
                rdName = rdv.getCubeDimensionName();
                rlName = rlv.getCubeLevelName();
            }
            if (colDimensionIndex >= 0 || colLevelIndex >= 0) {
                DimensionViewHandle cdv = this.crosstabItem.getDimension(1, colDimensionIndex);
                LevelViewHandle clv = cdv.getLevel(colLevelIndex);
                cdName = cdv.getCubeDimensionName();
                clName = clv.getCubeLevelName();
            }
            return this.crosstabItem.getMeasure(measureIndex).getAggregationCell(rdName, rlName, cdName, clName);
        }
        return null;
    }

    protected boolean checkMeasureVerticalSpanOverlapped(ColumnEvent ev) {
        return false;
    }

    protected boolean isMeasureGrandTotalNeedStart(ColumnEvent ev) {
        if (this.measureDetailStarted || this.measureSubTotalStarted || this.measureGrandTotalStarted || ev.type != 4) {
            return false;
        }
        return !this.checkMeasureVerticalSpanOverlapped(ev);
    }

    protected boolean isMeasureSubTotalNeedStart(ColumnEvent ev) {
        return !this.measureDetailStarted && !this.measureSubTotalStarted && ev.type == 3 && !this.checkMeasureVerticalSpanOverlapped(ev);
    }

    protected boolean isMeasureDetailNeedStart(ColumnEvent ev) {
        return !this.measureDetailStarted && (ev.type == 6 || ev.type == 2) && !this.checkMeasureVerticalSpanOverlapped(ev);
    }

    protected boolean isMeetMeasureDetailEnd(ColumnEvent ev, AggregationCellHandle aggCell) {
        if (aggCell == null || ev.type == 4) {
            return true;
        }
        if (this.totalMeasureCount != 1 && !this.isVerticalMeasure) {
            return true;
        }
        int targetColSpanGroupIndex = GroupUtil.getGroupIndex(this.columnGroups, aggCell.getSpanOverOnColumn());
        if (targetColSpanGroupIndex != -1) {
            block10: {
                if (ev.type == 3) {
                    EdgeGroup gp = (EdgeGroup)this.columnGroups.get(targetColSpanGroupIndex);
                    if (ev.dimensionIndex < gp.dimensionIndex || ev.dimensionIndex == gp.dimensionIndex && ev.levelIndex < gp.levelIndex) {
                        return true;
                    }
                }
                if (--targetColSpanGroupIndex != -1) break block10;
                return false;
            }
            try {
                EdgeCursor columnEdgeCursor = this.getColumnEdgeCursor();
                if (columnEdgeCursor != null) {
                    columnEdgeCursor.setPosition(ev.dataPosition);
                    DimensionCursor dc = (DimensionCursor)columnEdgeCursor.getDimensionCursor().get(targetColSpanGroupIndex);
                    if (!GroupUtil.isDummyGroup(dc)) {
                        return this.currentEdgePosition < dc.getEdgeStart();
                    }
                }
            }
            catch (OLAPException e) {
                logger.log(Level.SEVERE, Messages.getString("CrosstabRowExecutor.error.check.edge.start"), e);
            }
        }
        return true;
    }

    protected abstract void advance();

    @Override
    public IReportItemExecutor getNextChild() {
        IReportItemExecutor childExecutor = this.nextExecutor;
        this.nextExecutor = null;
        this.advance();
        return childExecutor;
    }

    @Override
    public boolean hasNextChild() {
        if (this.isFirst) {
            this.isFirst = false;
            this.advance();
        }
        return this.nextExecutor != null;
    }
}

