/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.pptx;

import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.emitter.config.AbstractConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.AbstractEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IOptionValue;
import org.eclipse.birt.report.engine.emitter.config.OptionValue;
import org.eclipse.birt.report.engine.emitter.config.pptx.i18n.Messages;

public class PPTXEmitterDescriptor
extends AbstractEmitterDescriptor {
    private static final String FONT_SUBSTITUTION = "FontSubstitution";
    private static final String BIDI_PROCESSING = "BIDIProcessing";
    private static final String TEXT_WRAPPING = "TextWrapping";
    private static final String CHART_DPI = "ChartDpi";
    private static final String REPAGINATE_FOR_PDF = "repaginateForPDF";
    private static final String EDIT_MODE = "org.eclipse.birt.report.emitter.PPTX.editMode";

    @Override
    protected void initOptions() {
        this.loadDefaultValues("org.eclipse.birt.report.engine.emitter.config.pptx");
        ConfigurableOption bidiProcessing = new ConfigurableOption(BIDI_PROCESSING);
        bidiProcessing.setDisplayName(this.getMessage("OptionDisplayValue.BidiProcessing"));
        bidiProcessing.setDataType(IConfigurableOption.DataType.BOOLEAN);
        bidiProcessing.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        bidiProcessing.setDefaultValue(Boolean.TRUE);
        bidiProcessing.setToolTip(null);
        bidiProcessing.setDescription(this.getMessage("OptionDescription.BidiProcessing"));
        ConfigurableOption textWrapping = new ConfigurableOption(TEXT_WRAPPING);
        textWrapping.setDisplayName(this.getMessage("OptionDisplayValue.TextWrapping"));
        textWrapping.setDataType(IConfigurableOption.DataType.BOOLEAN);
        textWrapping.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        textWrapping.setDefaultValue(Boolean.TRUE);
        textWrapping.setToolTip(null);
        textWrapping.setDescription(this.getMessage("OptionDescription.TextWrapping"));
        ConfigurableOption fontSubstitution = new ConfigurableOption(FONT_SUBSTITUTION);
        fontSubstitution.setDisplayName(this.getMessage("OptionDisplayValue.FontSubstitution"));
        fontSubstitution.setDataType(IConfigurableOption.DataType.BOOLEAN);
        fontSubstitution.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        fontSubstitution.setDefaultValue(Boolean.TRUE);
        fontSubstitution.setToolTip(null);
        fontSubstitution.setDescription(this.getMessage("OptionDescription.FontSubstitution"));
        ConfigurableOption pageOverFlow = new ConfigurableOption("pdfRenderOption.pageOverflow");
        pageOverFlow.setDisplayName(this.getMessage("OptionDisplayValue.PageOverFlow"));
        pageOverFlow.setDataType(IConfigurableOption.DataType.INTEGER);
        pageOverFlow.setDisplayType(IConfigurableOption.DisplayType.COMBO);
        pageOverFlow.setChoices(new OptionValue[]{new OptionValue(1, this.getMessage("OptionDisplayValue.CLIP_CONTENT")), new OptionValue(2, this.getMessage("OptionDisplayValue.FIT_TO_PAGE_SIZE")), new OptionValue(4, this.getMessage("OptionDisplayValue.OUTPUT_TO_MULTIPLE_PAGES")), new OptionValue(8, this.getMessage("OptionDisplayValue.ENLARGE_PAGE_SIZE"))});
        pageOverFlow.setDefaultValue(4);
        pageOverFlow.setToolTip(null);
        pageOverFlow.setDescription(this.getMessage("OptionDescription.PageOverFlow"));
        ConfigurableOption chartDpi = new ConfigurableOption(CHART_DPI);
        chartDpi.setDisplayName(this.getMessage("OptionDisplayValue.ChartDpi"));
        chartDpi.setDataType(IConfigurableOption.DataType.INTEGER);
        chartDpi.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        chartDpi.setDefaultValue(new Integer(192));
        chartDpi.setToolTip(this.getMessage("Tooltip.ChartDpi"));
        chartDpi.setDescription(this.getMessage("OptionDescription.ChartDpi"));
        ConfigurableOption repaginateForPDF = new ConfigurableOption(REPAGINATE_FOR_PDF);
        repaginateForPDF.setDisplayName(this.getMessage("OptionDisplayValue.RepaginateForPDF"));
        repaginateForPDF.setDataType(IConfigurableOption.DataType.BOOLEAN);
        repaginateForPDF.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        repaginateForPDF.setDefaultValue(Boolean.FALSE);
        repaginateForPDF.setToolTip(null);
        repaginateForPDF.setDescription(this.getMessage("OptionDescription.RepaginateForPDF"));
        ConfigurableOption editMode = new ConfigurableOption(EDIT_MODE);
        editMode.setDisplayName(this.getMessage("OptionDisplayValue.EditMode"));
        editMode.setDataType(IConfigurableOption.DataType.BOOLEAN);
        editMode.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        editMode.setDefaultValue(Boolean.TRUE);
        editMode.setToolTip(null);
        editMode.setDescription(this.getMessage("OptionDescription.EditMode"));
        this.options = new IConfigurableOption[]{bidiProcessing, textWrapping, fontSubstitution, pageOverFlow, repaginateForPDF, chartDpi, editMode};
        this.applyDefaultValues();
    }

    @Override
    public IConfigurableOptionObserver createOptionObserver() {
        return new PPTXOptionObserver();
    }

    private String getMessage(String key) {
        return Messages.getString(key, this.locale);
    }

    @Override
    public String getDescription() {
        return this.getMessage("PPTXEmitter.Description");
    }

    @Override
    public String getDisplayName() {
        return this.getMessage("PPTXEmitter.DisplayName");
    }

    public String getRenderOptionName(String name) {
        assert (name != null);
        if (TEXT_WRAPPING.equals(name)) {
            return "pdfRenderOption.textWrapping";
        }
        if (BIDI_PROCESSING.equals(name)) {
            return "pdfRenderOption.bidiProcessing";
        }
        if (FONT_SUBSTITUTION.equals(name)) {
            return "pdfRenderOption.fontSubstitution";
        }
        if (CHART_DPI.equals(name)) {
            return CHART_DPI;
        }
        if (REPAGINATE_FOR_PDF.equals(name)) {
            return "pdfRenderOption.repaginateForPDF";
        }
        return name;
    }

    @Override
    public String getID() {
        return "org.eclipse.birt.report.engine.emitter.pptx";
    }

    class PPTXOptionObserver
    extends AbstractConfigurableOptionObserver {
        PPTXOptionObserver() {
        }

        @Override
        public IConfigurableOption[] getOptions() {
            return PPTXEmitterDescriptor.this.options;
        }

        @Override
        public IRenderOption getPreferredRenderOption() {
            PDFRenderOption renderOption = new PDFRenderOption();
            renderOption.setEmitterID(PPTXEmitterDescriptor.this.getID());
            renderOption.setOutputFormat("pptx");
            if (this.values != null && this.values.length > 0) {
                IOptionValue[] iOptionValueArray = this.values;
                int n = this.values.length;
                int n2 = 0;
                while (n2 < n) {
                    IOptionValue optionValue = iOptionValueArray[n2];
                    if (optionValue != null) {
                        renderOption.setOption(PPTXEmitterDescriptor.this.getRenderOptionName(optionValue.getName()), optionValue.getValue());
                    }
                    ++n2;
                }
            }
            return renderOption;
        }
    }
}

