/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseLinkDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.document.ExprUtil;
import org.eclipse.birt.data.engine.impl.util.DirectedGraph;
import org.eclipse.birt.data.engine.impl.util.DirectedGraphEdge;
import org.eclipse.birt.data.engine.impl.util.GraphNode;
import org.eclipse.birt.data.engine.olap.api.query.IComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDerivedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.impl.query.CubeOperationFactory;
import org.eclipse.birt.data.engine.olap.impl.query.DerivedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.MeasureDefinition;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

public class PreparedCubeQueryDefinition
implements ICubeQueryDefinition {
    private ICubeQueryDefinition cqd;
    private String cubeName;
    private List<IBinding> realBindings = new ArrayList<IBinding>();
    private Set<IBinding> bindingsForNestAggregation = new HashSet<IBinding>();
    private Map<String, IBinding> nameToBinding = new HashMap<String, IBinding>();
    private ICubeOperation[] realCubeOperations = new ICubeOperation[0];

    public PreparedCubeQueryDefinition(ICubeQueryDefinition cqd) throws DataException {
        assert (cqd != null);
        this.cqd = cqd;
        this.cubeName = cqd.getName();
        ArrayList<IBinding> bindingsInCubeQuery = new ArrayList<IBinding>();
        for (Object e : cqd.getBindings()) {
            bindingsInCubeQuery.add(((Binding)e).clone());
        }
        for (Object e : bindingsInCubeQuery) {
            List<String> referencedBindings;
            IBinding binding = (IBinding)e;
            if (this.nameToBinding.containsKey(binding.getBindingName())) {
                throw new DataException("data.engine.DuplicatedBindingName");
            }
            this.nameToBinding.put(binding.getBindingName(), binding);
            if (OlapExpressionUtil.isAggregationBinding(binding) && (referencedBindings = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "data")) != null && referencedBindings.size() > 0) {
                this.bindingsForNestAggregation.add(binding);
                continue;
            }
            this.realBindings.add(binding);
        }
        List list = cqd.getDerivedMeasures();
        if (list != null && list.size() > 0) {
            this.createBindingsForCalculatedMeasures(bindingsInCubeQuery, cqd.getMeasures(), cqd.getDerivedMeasures(), CubeQueryDefinitionUtil.populateMeasureAggrOns(cqd));
        }
        List<ICubeOperation> convertedCubeOperations = this.getConvertedCubeOperations();
        ArrayList<ICubeOperation> all = new ArrayList<ICubeOperation>(Arrays.asList(cqd.getCubeOperations()));
        all.addAll(convertedCubeOperations);
        this.realCubeOperations = all.toArray(new ICubeOperation[0]);
    }

    private String getRollUpAggregationFunctionName(String function) {
        if (function.equalsIgnoreCase("COUNT") || function.equalsIgnoreCase("COUNTDISTINCT") || function.equalsIgnoreCase("AVE")) {
            return "SUM";
        }
        return function;
    }

    private IBinding getSameBindingInQuery(IBinding binding, List bindings) throws DataException {
        int i = 0;
        while (i < bindings.size()) {
            IBinding b = (IBinding)bindings.get(i);
            if (b.getDataType() == binding.getDataType() && (binding.getAggrFunction() == null || binding.getAggrFunction().equals(b.getAggrFunction())) && ExprUtil.isEqualExpression(b.getExpression(), binding.getExpression()) && ExprUtil.isEqualExpression(b.getFilter(), binding.getFilter()) && b.getArguments().size() == binding.getArguments().size()) {
                Iterator itr1 = b.getArguments().iterator();
                Iterator itr2 = binding.getArguments().iterator();
                while (itr1.hasNext()) {
                    IBaseExpression expr2;
                    IBaseExpression expr1 = (IBaseExpression)itr1.next();
                    if (ExprUtil.isEqualExpression(expr1, expr2 = (IBaseExpression)itr2.next())) continue;
                }
                if (Arrays.deepEquals(b.getAggregatOns().toArray(), binding.getAggregatOns().toArray())) {
                    return b;
                }
            }
            ++i;
        }
        return null;
    }

    private void createBindingsForCalculatedMeasures(List bindingsInCubeQuery, List measures, List calculatedMeasures, List aggrOns) throws DataException {
        ArrayList<String> levelNames = new ArrayList<String>();
        int i = 0;
        while (i < aggrOns.size()) {
            DimLevel level = (DimLevel)aggrOns.get(i);
            levelNames.add(ExpressionUtil.createJSDimensionExpression(level.getDimensionName(), level.getLevelName()));
            ++i;
        }
        HashMap measureMap = new HashMap();
        int i2 = 0;
        while (i2 < measures.size()) {
            measureMap.put(((MeasureDefinition)measures.get(i2)).getName(), measures.get(i2));
            ++i2;
        }
        HashMap derivedMeasureMap = new HashMap();
        int i3 = 0;
        while (i3 < calculatedMeasures.size()) {
            derivedMeasureMap.put(((DerivedMeasureDefinition)calculatedMeasures.get(i3)).getName(), calculatedMeasures.get(i3));
            ++i3;
        }
        HashMap<String, IBinding> createdBindings = new HashMap<String, IBinding>();
        int i4 = 0;
        while (i4 < calculatedMeasures.size()) {
            DerivedMeasureDefinition measureDefinition = (DerivedMeasureDefinition)calculatedMeasures.get(i4);
            List<String> referencedMeasures = ExpressionCompilerUtil.extractColumnExpression(measureDefinition.getExpression(), "measure");
            int j = 0;
            while (j < referencedMeasures.size()) {
                String measureName = referencedMeasures.get(j).toString();
                if (measureMap.containsKey(measureName) && !createdBindings.containsKey(measureName)) {
                    MeasureDefinition md = (MeasureDefinition)measureMap.get(measureName);
                    Binding newBinding = new Binding("temp_" + measureName);
                    newBinding.setDataType(md.getDataType());
                    newBinding.setExpression(new ScriptExpression(ExpressionUtil.createJSMeasureExpression(measureName)));
                    int a = 0;
                    while (a < levelNames.size()) {
                        newBinding.addAggregateOn((String)levelNames.get(a));
                        ++a;
                    }
                    if (md.getAggrFunction() != null) {
                        newBinding.setAggrFunction(this.getRollUpAggregationFunctionName(md.getAggrFunction()));
                    } else {
                        newBinding.setAggrFunction(null);
                        newBinding.getAggregatOns().clear();
                    }
                    IBinding b = this.getSameBindingInQuery(newBinding, bindingsInCubeQuery);
                    if (b != null) {
                        createdBindings.put(measureName, b);
                    } else {
                        createdBindings.put(measureName, newBinding);
                        this.realBindings.add(newBinding);
                    }
                }
                ++j;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < bindingsInCubeQuery.size()) {
            IBinding binding = (IBinding)bindingsInCubeQuery.get(i4);
            ScriptExpression expression = this.cloneExpression((ScriptExpression)binding.getExpression());
            List<String> measureName = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)expression, "measure");
            if (measureName != null && measureName.size() > 0 && derivedMeasureMap.containsKey(measureName.get(0).toString())) {
                expression.setText("(" + ((ScriptExpression)((DerivedMeasureDefinition)derivedMeasureMap.get(measureName.get(0).toString())).getExpression()).getText() + ")");
                expression.setText(this.getReplacedExpressionText(expression.getText(), measureMap, derivedMeasureMap, createdBindings, binding, bindingsInCubeQuery));
                expression.setText(expression.getText().substring(1, expression.getText().length() - 1));
                binding.getAggregatOns().clear();
                binding.setAggrFunction(null);
                binding.setExpression(expression);
            }
            ++i4;
        }
    }

    private ScriptExpression cloneExpression(ScriptExpression expr) {
        ScriptExpression nExpr = new ScriptExpression(expr.getText(), expr.getDataType());
        nExpr.setGroupName(expr.getGroupName());
        nExpr.setHandle(expr.getHandle());
        nExpr.setScriptId(expr.getScriptId());
        return nExpr;
    }

    private boolean isObjectEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    private String getReplacedExpressionText(String text, Map measureMap, Map derivedMeasureMap, Map createdBindings, IBinding binding, List bindingsInCubeQuery) throws DataException {
        List<String> measureNames = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)new ScriptExpression(text.substring(1, text.length() - 1)), "measure");
        int i = 0;
        while (i < measureNames.size()) {
            if (measureMap.containsKey(measureNames.get(i).toString())) {
                IBinding b = (IBinding)createdBindings.get(measureNames.get(i).toString());
                String bindingName = b.getBindingName();
                if (!(Arrays.deepEquals(b.getAggregatOns().toArray(), binding.getAggregatOns().toArray()) && this.isObjectEqual(b.getAggrFunction(), binding.getAggrFunction()) && this.isObjectEqual(b.getFilter(), binding.getFilter()))) {
                    Binding newBinding = new Binding(String.valueOf(bindingName) + "_" + binding.getBindingName());
                    newBinding.setDataType(b.getDataType());
                    newBinding.setAggrFunction(binding.getAggrFunction());
                    newBinding.setExpression(b.getExpression());
                    newBinding.getAggregatOns().addAll(binding.getAggregatOns());
                    newBinding.setFilter(binding.getFilter());
                    IBinding sameBinding = this.getSameBindingInQuery(newBinding, this.realBindings);
                    if (sameBinding != null) {
                        bindingName = sameBinding.getBindingName();
                    } else {
                        bindingName = newBinding.getBindingName();
                        this.realBindings.add(newBinding);
                    }
                }
                text = text.replace(ExpressionUtil.createJSMeasureExpression(measureNames.get(i).toString()), ExpressionUtil.createJSDataExpression(bindingName));
            } else if (derivedMeasureMap.containsKey(measureNames.get(i).toString())) {
                text = text.replace(ExpressionUtil.createJSMeasureExpression(measureNames.get(i).toString()), "(" + ((ScriptExpression)((DerivedMeasureDefinition)derivedMeasureMap.get(measureNames.get(i).toString())).getExpression()).getText() + ")");
                text = this.getReplacedExpressionText(text, measureMap, derivedMeasureMap, createdBindings, binding, bindingsInCubeQuery);
            }
            ++i;
        }
        return text;
    }

    public ICubeQueryDefinition getCubeQueryDefinition() {
        return this.cqd;
    }

    private List<ICubeOperation> getConvertedCubeOperations() throws DataException {
        ArrayList<ICubeOperation> convertedCubeOperations = new ArrayList<ICubeOperation>();
        HashSet<DirectedGraphEdge> edges = new HashSet<DirectedGraphEdge>();
        for (IBinding binding : this.bindingsForNestAggregation) {
            List<String> referencedBindings = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "data");
            for (String name : referencedBindings) {
                IBinding reference = this.nameToBinding.get(name);
                if (reference == null || !this.bindingsForNestAggregation.contains(reference)) continue;
                edges.add(new DirectedGraphEdge(new GraphNode(binding), new GraphNode(reference)));
            }
        }
        GraphNode[] nodes = null;
        try {
            nodes = new DirectedGraph(edges).flattenNodesByDependency();
        }
        catch (DirectedGraph.CycleFoundException e) {
            throw new DataException("data.engine.ColumnBindingCycle", ((IBinding)e.getNode().getValue()).getBindingName());
        }
        HashSet<IBinding> processed = new HashSet<IBinding>();
        GraphNode[] graphNodeArray = nodes;
        int n = nodes.length;
        int name = 0;
        while (name < n) {
            GraphNode node = graphNodeArray[name];
            IBinding b = (IBinding)node.getValue();
            convertedCubeOperations.add(CubeOperationFactory.getInstance().createAddingNestAggregationsOperation(new IBinding[]{b}));
            processed.add(b);
            ++name;
        }
        if (this.bindingsForNestAggregation.size() > processed.size()) {
            ArrayList<IBinding> left = new ArrayList<IBinding>();
            for (IBinding b : this.bindingsForNestAggregation) {
                if (processed.contains(b)) continue;
                left.add(b);
            }
            convertedCubeOperations.add(CubeOperationFactory.getInstance().createAddingNestAggregationsOperation(left.toArray(new IBinding[0])));
        }
        return convertedCubeOperations;
    }

    @Override
    public void addBinding(IBinding binding) {
        throw new UnsupportedOperationException("adding binding is not allowed for prepared cube query definition");
    }

    @Override
    public void addCubeOperation(ICubeOperation cubeOperation) {
        throw new UnsupportedOperationException("adding cube operation is not allowed for prepared cube query definition");
    }

    @Override
    public void addFilter(IFilterDefinition filter) {
        this.cqd.addFilter(filter);
    }

    @Override
    public void addSort(ISortDefinition sort) {
        this.cqd.addSort(sort);
    }

    @Override
    public boolean cacheQueryResults() {
        return this.cqd.cacheQueryResults();
    }

    @Override
    public IComputedMeasureDefinition createComputedMeasure(String measureName, int type, IBaseExpression expr) throws DataException {
        return this.cqd.createComputedMeasure(measureName, type, expr);
    }

    @Override
    public IDerivedMeasureDefinition createDerivedMeasure(String measureName, int type, IBaseExpression expr) throws DataException {
        return this.cqd.createDerivedMeasure(measureName, type, expr);
    }

    @Override
    public IEdgeDefinition createEdge(int type) {
        return this.cqd.createEdge(type);
    }

    @Override
    public IMeasureDefinition createMeasure(String measureName) {
        return this.cqd.createMeasure(measureName);
    }

    @Override
    public List getBindings() {
        return Collections.unmodifiableList(this.realBindings);
    }

    @Override
    public List getComputedMeasures() {
        return this.cqd.getComputedMeasures();
    }

    public Set<IBinding> getBindingsForNestAggregation() {
        return this.bindingsForNestAggregation;
    }

    @Override
    public ICubeOperation[] getCubeOperations() {
        return this.realCubeOperations;
    }

    @Override
    public IEdgeDefinition getEdge(int type) {
        return this.cqd.getEdge(type);
    }

    @Override
    public int getFilterOption() {
        return this.cqd.getFilterOption();
    }

    @Override
    public List getFilters() {
        return this.cqd.getFilters();
    }

    @Override
    public List getMeasures() {
        return this.cqd.getMeasures();
    }

    @Override
    public List getDerivedMeasures() {
        return this.cqd.getDerivedMeasures();
    }

    @Override
    public String getQueryResultsID() {
        return this.cqd.getQueryResultsID();
    }

    @Override
    public List getSorts() {
        return this.cqd.getSorts();
    }

    @Override
    public void setCacheQueryResults(boolean b) {
        this.cqd.setCacheQueryResults(b);
    }

    @Override
    public void setFilterOption(int breakHierarchyOption) {
        this.cqd.setFilterOption(breakHierarchyOption);
    }

    @Override
    public void setQueryResultsID(String id) {
        this.cqd.setQueryResultsID(id);
    }

    @Override
    public String getName() {
        return this.cubeName;
    }

    @Override
    public void setName(String name) {
        this.cubeName = name;
    }

    @Override
    public boolean needAccessFactTable() {
        return this.cqd.needAccessFactTable();
    }

    @Override
    public void setNeedAccessFactTable(boolean needAccessFactTable) {
        this.cqd.setNeedAccessFactTable(needAccessFactTable);
    }

    @Override
    public String getID() {
        return this.cqd.getID();
    }

    @Override
    public void setID(String ID) {
        this.cqd.setID(ID);
    }

    @Override
    public ICubeQueryDefinition clone() {
        PreparedCubeQueryDefinition cloned = null;
        try {
            cloned = new PreparedCubeQueryDefinition(this.cqd.clone());
        }
        catch (DataException dataException) {
            // empty catch block
        }
        return cloned;
    }

    @Override
    public Set<IBaseLinkDefinition> getLinks() {
        return this.cqd.getLinks();
    }

    @Override
    public void addLink(IBaseLinkDefinition link) {
        this.cqd.getLinks().add(link);
    }
}

