/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.RowSaveUtil;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;
import org.eclipse.birt.data.engine.impl.document.viewing.IDataSetResultSet;
import org.eclipse.birt.data.engine.odi.IResultObject;

class ExprDataReader1
implements IExprDataReader {
    private int currReadIndex;
    private int currRowIndex;
    private int INT_LENGTH = 4;
    private DataInputStream rowExprsDis;
    private RAInputStream rowExprsRAIs;
    private RAInputStream rowLenRAIs;
    private DataInputStream rowLenDis;
    private int rowCount;
    private int version;
    private Map exprValueMap;
    private List exprKeys;
    private Map dataSetExprKeys;
    private int metaOffset;
    private IDataSetResultSet dataSetData;
    private Map bindingNameTypeMap;
    private ClassLoader currentClassLoader;

    ExprDataReader1(RAInputStream rowExprsRAIs, RAInputStream rowLenRAIs, int version, IDataSetResultSet dataSetData) throws DataException {
        try {
            this.currentClassLoader = DataEngineSession.getCurrentClassLoader();
            this.rowCount = IOUtil.readInt(rowExprsRAIs);
            int exprCount = IOUtil.readInt(rowExprsRAIs);
            this.exprKeys = new ArrayList();
            this.dataSetExprKeys = new HashMap();
            this.rowExprsDis = new DataInputStream(rowExprsRAIs);
            this.bindingNameTypeMap = new HashMap();
            int i = 0;
            while (i < exprCount) {
                String key = IOUtil.readString(this.rowExprsDis);
                this.exprKeys.add(key);
                if (version >= 50) {
                    this.bindingNameTypeMap.put(key, IOUtil.readInt(this.rowExprsDis));
                }
                ++i;
            }
            if (version >= 50) {
                int dataSetColumnExprCount = IOUtil.readInt(this.rowExprsDis);
                int i2 = 0;
                while (i2 < dataSetColumnExprCount) {
                    String key = IOUtil.readObject(this.rowExprsDis, this.currentClassLoader).toString();
                    this.dataSetExprKeys.put(key, IOUtil.readObject(this.rowExprsDis, this.currentClassLoader));
                    this.bindingNameTypeMap.put(key, IOUtil.readInt(this.rowExprsDis));
                    ++i2;
                }
            }
            this.metaOffset = this.INT_LENGTH + IOUtil.readInt(this.rowExprsDis) + this.INT_LENGTH;
            if (this.dataSetExprKeys.size() > 0) {
                this.dataSetData = dataSetData;
            }
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, (Object)"Result Data");
        }
        this.rowExprsRAIs = rowExprsRAIs;
        this.rowLenRAIs = rowLenRAIs;
        this.rowLenDis = new DataInputStream(rowLenRAIs);
        this.version = version;
        this.currReadIndex = 0;
        this.currRowIndex = -1;
    }

    @Override
    public int getCount() {
        return this.rowCount;
    }

    @Override
    public int getRowId() {
        try {
            if (this.dataSetData != null && this.dataSetData.getResultObject() != null) {
                return (Integer)this.dataSetData.getResultObject().getFieldValue("_$$_dte_inner_row_id_$$_");
            }
            if (this.bindingNameTypeMap.containsKey("_$$_dte_inner_row_id_$$_")) {
                return (Integer)this.getRowValue().get("_$$_dte_inner_row_id_$$_");
            }
            return this.getRowIndex();
        }
        catch (DataException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public int getRowIndex() {
        if (this.rowCount == -1) {
            return this.currRowIndex;
        }
        if (this.currRowIndex >= this.rowCount) {
            return this.rowCount;
        }
        return this.currRowIndex;
    }

    @Override
    public void moveTo(int index) throws DataException {
        if (this.rowCount != -1 && (index < 0 || index >= this.rowCount)) {
            throw new DataException("data.engine.invalidRowIndex", index);
        }
        if (index < this.currRowIndex) {
            throw new DataException("data.engine.backwardSeekError");
        }
        if (index == this.currRowIndex) {
            return;
        }
        this.currRowIndex = index;
        this.getRowValue();
    }

    @Override
    public boolean next() throws DataException {
        if (this.currRowIndex < this.rowCount - 1 || this.rowCount == -1) {
            IResultObject obj;
            ++this.currRowIndex;
            return this.dataSetData == null || (obj = this.dataSetData.next()) != null;
        }
        return false;
    }

    @Override
    public Map getRowValue() throws DataException {
        try {
            if (this.rowCount == 0) {
                if (this.exprValueMap == null) {
                    this.exprValueMap = this.getValueMap();
                }
            } else if (this.currReadIndex < this.currRowIndex + 1) {
                this.skipTo(this.currRowIndex);
                this.exprValueMap = this.getValueMap();
            }
            this.currReadIndex = this.currRowIndex + 1;
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, (Object)"Result Data");
        }
        return this.exprValueMap;
    }

    private void skipTo(int absoluteRowIndex) throws IOException, DataException {
        if (this.dataSetData != null) {
            this.dataSetData.skipTo(absoluteRowIndex);
        }
        if (this.currReadIndex == absoluteRowIndex) {
            return;
        }
        if (this.version == 0) {
            int gapRows = absoluteRowIndex - this.currReadIndex;
            int j = 0;
            while (j < gapRows) {
                int exprCount = IOUtil.readInt(this.rowExprsDis);
                int i = 0;
                while (i < exprCount) {
                    IOUtil.readObject(this.rowExprsDis, this.currentClassLoader);
                    ++i;
                }
                ++j;
            }
        } else if (this.version <= 25) {
            this.rowLenRAIs.seek(absoluteRowIndex * this.INT_LENGTH);
            int rowOffsetAbsolute = IOUtil.readInt(this.rowLenRAIs);
            this.rowExprsRAIs.seek(rowOffsetAbsolute + this.metaOffset);
            this.rowExprsDis = new DataInputStream(this.rowExprsRAIs);
        } else {
            this.rowLenRAIs.seek((long)absoluteRowIndex * 8L);
            long rowOffsetAbsolute = IOUtil.readLong(this.rowLenDis);
            this.rowExprsRAIs.seek(rowOffsetAbsolute + (long)this.metaOffset);
            this.rowExprsDis = new DataInputStream(this.rowExprsRAIs);
        }
    }

    private Map getValueMap() throws IOException, DataException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        int exprCount = IOUtil.readInt(this.rowExprsDis);
        int i = 0;
        while (i < exprCount) {
            String exprID = this.exprKeys.get(i).toString();
            Object exprValue = IOUtil.readObject(this.rowExprsDis, this.currentClassLoader);
            if (RowSaveUtil.EXCEPTION_INDICATOR.equals(exprValue)) {
                valueMap.put(exprID, new DataException("data.engine.ReadColumnValueFromDocumentError", exprID));
            } else {
                valueMap.put(exprID, exprValue);
            }
            ++i;
        }
        if (this.dataSetData != null) {
            Iterator it = this.dataSetExprKeys.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                String value = (String)this.dataSetExprKeys.get(key);
                IResultObject o = this.dataSetData.getResultObject();
                try {
                    valueMap.put(key, o == null ? null : DataTypeUtil.convert(o.getFieldValue(value), (Integer)this.bindingNameTypeMap.get(key)));
                }
                catch (BirtException e) {
                    valueMap.put(key, e);
                }
            }
        }
        return valueMap;
    }

    @Override
    public void close() {
        try {
            if (this.rowExprsDis != null) {
                this.rowExprsDis.close();
                this.rowExprsDis = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

