/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.model.HCounterSuperColumnImpl;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.CounterSuperSlice;
import me.prettyprint.hector.api.beans.HCounterSuperColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;

public final class CounterSuperSliceImpl<SN, N>
implements CounterSuperSlice<SN, N> {
    private final Map<SN, HCounterSuperColumn<SN, N>> columnsMap;
    private final List<HCounterSuperColumn<SN, N>> columnsList;

    public CounterSuperSliceImpl(List<CounterSuperColumn> tSuperColumns, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        Assert.noneNull(tSuperColumns, sNameSerializer, nameSerializer);
        this.columnsMap = new HashMap<SN, HCounterSuperColumn<SN, N>>(tSuperColumns.size());
        this.columnsList = new ArrayList<HCounterSuperColumn<SN, N>>(tSuperColumns.size());
        for (CounterSuperColumn sc : tSuperColumns) {
            HCounterSuperColumnImpl<SN, N> column = new HCounterSuperColumnImpl<SN, N>(sc, sNameSerializer, nameSerializer);
            this.columnsMap.put(column.getName(), column);
            this.columnsList.add(column);
        }
    }

    @Override
    public List<HCounterSuperColumn<SN, N>> getSuperColumns() {
        return this.columnsList;
    }

    @Override
    public HCounterSuperColumn<SN, N> getColumnByName(SN columnName) {
        return this.columnsMap.get(columnName);
    }

    public String toString() {
        return "SuperSlice(" + this.columnsList.toString() + ")";
    }
}

