/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class ReportItemPropSearchStrategy
extends PropertySearchStrategy {
    private static final ReportItemPropSearchStrategy instance = new ReportItemPropSearchStrategy();
    protected static Set<String> listingElementDataBindingProps;
    protected static Set<Integer> listingElementDataBindingPropsNameHash;
    protected static Set<String> extendedItemDataBindingProps;
    protected static Set<Integer> extendedItemDataBindingPropsNameHash;
    protected static Set<String> reportItemDataBindingProps;
    protected static Set<Integer> reportItemDataBindingPropsNameHash;

    static {
        HashSet<String> tmpSet = new HashSet<String>();
        tmpSet.add("paramBindings");
        tmpSet.add("boundDataColumns");
        tmpSet.add("dataSet");
        tmpSet.add("cube");
        tmpSet.add("filter");
        tmpSet.add("sort");
        listingElementDataBindingProps = tmpSet;
        HashSet<Integer> tmpIntegerSet = new HashSet<Integer>();
        tmpIntegerSet.add("paramBindings".hashCode());
        tmpIntegerSet.add("boundDataColumns".hashCode());
        tmpIntegerSet.add("dataSet".hashCode());
        tmpIntegerSet.add("cube".hashCode());
        tmpIntegerSet.add("filter".hashCode());
        tmpIntegerSet.add("sort".hashCode());
        listingElementDataBindingPropsNameHash = tmpIntegerSet;
        tmpSet = new HashSet();
        tmpSet.add("paramBindings");
        tmpSet.add("boundDataColumns");
        tmpSet.add("dataSet");
        tmpSet.add("cube");
        tmpSet.add("filter");
        extendedItemDataBindingProps = tmpSet;
        tmpIntegerSet = new HashSet();
        tmpIntegerSet.add("paramBindings".hashCode());
        tmpIntegerSet.add("boundDataColumns".hashCode());
        tmpIntegerSet.add("dataSet".hashCode());
        tmpIntegerSet.add("cube".hashCode());
        tmpIntegerSet.add("filter".hashCode());
        extendedItemDataBindingPropsNameHash = tmpIntegerSet;
        tmpSet = new HashSet();
        tmpSet.add("paramBindings");
        tmpSet.add("boundDataColumns");
        tmpSet.add("dataSet");
        tmpSet.add("cube");
        reportItemDataBindingProps = tmpSet;
        tmpIntegerSet = new HashSet();
        tmpIntegerSet.add("paramBindings".hashCode());
        tmpIntegerSet.add("boundDataColumns".hashCode());
        tmpIntegerSet.add("dataSet".hashCode());
        tmpIntegerSet.add("cube".hashCode());
        reportItemDataBindingPropsNameHash = tmpIntegerSet;
    }

    protected ReportItemPropSearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    @Override
    protected Object getPropertyFromSelf(Module module, DesignElement element, ElementPropertyDefn prop) {
        String propName = prop.getName();
        if (!ReportItemPropSearchStrategy.isDataBindingProperty(element, propName)) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        ElementRefValue refValue = (ElementRefValue)element.getLocalProperty(module, "dataBindingRef");
        if (refValue == null || !refValue.isResolved()) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        DesignElement refElement = refValue.getElement();
        ElementPropertyDefn refPropDefn = refElement.getPropertyDefn(propName);
        if (refPropDefn == null || prop.getTypeCode() != refPropDefn.getTypeCode() || prop.getStructDefn() != refPropDefn.getStructDefn() || prop.getTargetElementType() != refPropDefn.getTargetElementType()) {
            return null;
        }
        return refElement.getProperty(module, prop);
    }

    public static Set<String> getDataBindingProperties(DesignElement tmpElement) {
        if (tmpElement instanceof ListingElement) {
            return listingElementDataBindingProps;
        }
        if (tmpElement instanceof ExtendedItem) {
            return extendedItemDataBindingProps;
        }
        if (tmpElement instanceof ReportItem) {
            return reportItemDataBindingProps;
        }
        return Collections.emptySet();
    }

    private static Set<Integer> getDataBindingPropertiesNameHash(DesignElement tmpElement) {
        if (tmpElement instanceof ListingElement) {
            return listingElementDataBindingPropsNameHash;
        }
        if (tmpElement instanceof ExtendedItem) {
            return extendedItemDataBindingPropsNameHash;
        }
        if (tmpElement instanceof ReportItem) {
            return reportItemDataBindingPropsNameHash;
        }
        return Collections.emptySet();
    }

    public static boolean isDataBindingProperty(DesignElement element, String propName) {
        if (!(element instanceof ReportItem) || StringUtil.isBlank(propName)) {
            return false;
        }
        return ReportItemPropSearchStrategy.getDataBindingPropertiesNameHash(element).contains(propName.hashCode());
    }

    @Override
    public Object getPropertyExceptRomDefault(Module module, DesignElement element, ElementPropertyDefn prop) {
        if ("repeatHeader".equals(prop.getName()) && element instanceof ListingElement) {
            Object value = super.getPropertyExceptRomDefault(module, element, prop);
            if (Boolean.FALSE.equals(value)) {
                return value;
            }
            Object cascadeACL = element.getProperty(module, "cascadeACL");
            if (Boolean.FALSE.equals(cascadeACL)) {
                return value;
            }
            ListingElement listingElement = (ListingElement)element;
            List<DesignElement> groups = listingElement.getGroups();
            for (DesignElement group : groups) {
                Object aclExpr = group.getProperty(module, "ACLExpression");
                if (aclExpr == null) continue;
                return Boolean.FALSE;
            }
            return value;
        }
        return super.getPropertyExceptRomDefault(module, element, prop);
    }
}

