/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.IdentifierManager;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;

public abstract class ShortHandProcessor {
    private static Map<String, ShortHandProcessor> processorMap = new HashMap<String, ShortHandProcessor>();
    static String EMPTY_VALUE = "";
    static String COLON = ":";
    static String SEMICOLON = ";";

    static {
        processorMap.put("text-decoration", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                String[] vs = value.split(" ");
                int i = 0;
                while (i < vs.length) {
                    if ("underline".equals(vs[i])) {
                        1.appendStyle(buffer, "text-underline", "true");
                    } else if ("line-through".equals(vs[i])) {
                        1.appendStyle(buffer, "text-linethrough", "true");
                    } else if ("overline".equals(vs[i])) {
                        1.appendStyle(buffer, "text-overline", "true");
                    }
                    ++i;
                }
            }
        });
        processorMap.put("margin", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                String[] vs = value.split(" ");
                switch (vs.length) {
                    case 1: {
                        this.buildMargin(buffer, vs[0], vs[0], vs[0], vs[0]);
                        break;
                    }
                    case 2: {
                        this.buildMargin(buffer, vs[0], vs[1], vs[0], vs[1]);
                        break;
                    }
                    case 3: {
                        this.buildMargin(buffer, vs[0], vs[1], vs[2], vs[1]);
                        break;
                    }
                    case 4: {
                        this.buildMargin(buffer, vs[0], vs[1], vs[2], vs[3]);
                    }
                }
            }
        });
        processorMap.put("padding", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                String[] vs = value.split(" ");
                switch (vs.length) {
                    case 1: {
                        this.buildPadding(buffer, vs[0], vs[0], vs[0], vs[0]);
                        break;
                    }
                    case 2: {
                        this.buildPadding(buffer, vs[0], vs[1], vs[0], vs[1]);
                        break;
                    }
                    case 3: {
                        this.buildPadding(buffer, vs[0], vs[1], vs[2], vs[1]);
                        break;
                    }
                    case 4: {
                        this.buildPadding(buffer, vs[0], vs[1], vs[2], vs[3]);
                    }
                }
            }
        });
        processorMap.put("border", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                String[] vs = value.split(" ");
                this.buildBorder(buffer, this.getBorderWidth(vs, engine), this.getBorderColor(vs, engine), this.getBorderStyle(vs, engine));
            }
        });
        processorMap.put("border-style", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                this.buildBorder(buffer, null, null, value);
            }
        });
        processorMap.put("border-width", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                this.buildBorder(buffer, value, null, null);
            }
        });
        processorMap.put("border-color", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                this.buildBorder(buffer, null, value, null);
            }
        });
        processorMap.put("border-left", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                String[] vs = value.split(" ");
                this.buildLeftBorder(buffer, this.getBorderWidth(vs, engine), this.getBorderColor(vs, engine), this.getBorderStyle(vs, engine));
            }
        });
        processorMap.put("border-right", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                String[] vs = value.split(" ");
                this.buildRightBorder(buffer, this.getBorderWidth(vs, engine), this.getBorderColor(vs, engine), this.getBorderStyle(vs, engine));
            }
        });
        processorMap.put("border-top", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                String[] vs = value.split(" ");
                this.buildTopBorder(buffer, this.getBorderWidth(vs, engine), this.getBorderColor(vs, engine), this.getBorderStyle(vs, engine));
            }
        });
        processorMap.put("border-bottom", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                String[] vs = value.split(" ");
                this.buildBottomBorder(buffer, this.getBorderWidth(vs, engine), this.getBorderColor(vs, engine), this.getBorderStyle(vs, engine));
            }
        });
        processorMap.put("background", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                String color;
                String[] vs = value.split(" ");
                String url = this.getBackgroundImage(vs, engine);
                if (!EMPTY_VALUE.equals(url)) {
                    12.appendStyle(buffer, "background-image", url);
                }
                if ((color = this.getBackgroundColor(vs, engine)) != null) {
                    12.appendStyle(buffer, "background-color", color);
                }
            }
        });
        processorMap.put("font", new ShortHandProcessor(){

            @Override
            public void process(StringBuffer buffer, String value, CSSEngine engine) {
                ArrayList<String> vl = new ArrayList<String>();
                Pattern pattern = Pattern.compile("((?:(?:\"[^\",]+\")|(?:[^\",\\s]+))(?:,\\s*(?:(?:\"[^\",]+\")|(?:[^\",\\s]+)))*)");
                Matcher matcher = pattern.matcher(value);
                while (matcher.find()) {
                    vl.add(matcher.group(1));
                }
                String[] vs = new String[vl.size()];
                vl.toArray(vs);
                switch (vs.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        13.appendStyle(buffer, "font-family", vs[0]);
                        break;
                    }
                    case 2: {
                        13.appendStyle(buffer, "font-family", vs[0]);
                        this.buildFontSize(buffer, vs[1], engine);
                        break;
                    }
                    default: {
                        13.appendStyle(buffer, "font-family", vs[vs.length - 1]);
                        this.buildFontSize(buffer, vs[vs.length - 2], engine);
                        String[] values = new String[vs.length - 2];
                        System.arraycopy(vs, 0, values, 0, vs.length - 2);
                        this.buildFontStyle(buffer, values, engine);
                    }
                }
            }
        });
    }

    abstract void process(StringBuffer var1, String var2, CSSEngine var3);

    protected static void appendStyle(StringBuffer buffer, String name, String value) {
        if (value == null) {
            return;
        }
        buffer.append(name);
        buffer.append(COLON);
        buffer.append(value);
        buffer.append(SEMICOLON);
    }

    protected void buildFontStyle(StringBuffer buffer, String[] vs, CSSEngine engine) {
        int i = 0;
        while (i < vs.length) {
            LexicalUnit u = this.getUnit(vs[i], engine);
            if (u != null) {
                if (u.getLexicalUnitType() == 35) {
                    if (this.isIdentifier(vs[i], 40, engine)) {
                        ShortHandProcessor.appendStyle(buffer, "font-style", vs[i]);
                    } else if (this.isIdentifier(vs[i], 29, engine)) {
                        ShortHandProcessor.appendStyle(buffer, "font-weight", vs[i]);
                    }
                } else if (u.getLexicalUnitType() == 13 && ("100".equals(vs[i]) || "200".equals(vs[i]) || "300".equals(vs[i]) || "400".equals(vs[i]) || "500".equals(vs[i]) || "600".equals(vs[i]) || "700".equals(vs[i]) || "800".equals(vs[i]) || "900".equals(vs[i]))) {
                    ShortHandProcessor.appendStyle(buffer, "font-weight", vs[i]);
                }
            }
            ++i;
        }
    }

    protected void buildFontSize(StringBuffer buffer, String value, CSSEngine engine) {
        if (value != null && value.length() > 0) {
            String[] ss = value.split("/");
            if (ss.length == 1) {
                ShortHandProcessor.appendStyle(buffer, "font-size", value);
            } else {
                ShortHandProcessor.appendStyle(buffer, "font-size", ss[0]);
                ShortHandProcessor.appendStyle(buffer, "line-height", ss[1]);
            }
        }
    }

    protected LexicalUnit getUnit(String value, CSSEngine engine) {
        LexicalUnit u = null;
        try {
            u = engine.getParser().parsePropertyValue(new InputSource((Reader)new StringReader(value)));
        }
        catch (IOException | CSSException e) {
            e.printStackTrace();
        }
        return u;
    }

    protected String getBackgroundColor(String[] values, CSSEngine engine) {
        int i = 0;
        while (i < values.length) {
            LexicalUnit u = this.getUnit(values[i], engine);
            if (u != null) {
                if (u.getLexicalUnitType() == 27) {
                    return values[i];
                }
                if (u.getLexicalUnitType() == 35 && this.isIdentifier(values[i], 0, engine)) {
                    return values[i];
                }
            }
            ++i;
        }
        return null;
    }

    protected String[] getBackgroundRepeat(String[] values, CSSEngine engine) {
        String[] result = new String[]{"repeat", "repeat"};
        int i = 0;
        while (i < values.length) {
            LexicalUnit u = this.getUnit(values[i], engine);
            if (u != null && u.getLexicalUnitType() == 35 && this.isIdentifier(values[i], 9, engine)) {
                result[0] = values[i];
                if (i < values.length - 1 && (u = this.getUnit(values[i + 1], engine)) != null && u.getLexicalUnitType() == 35 && this.isIdentifier(values[i + 1], 9, engine)) {
                    result[1] = values[i + 1];
                    return result;
                }
                result[1] = values[i];
            }
            ++i;
        }
        return result;
    }

    protected boolean isIdentifier(String value, int index, CSSEngine engine) {
        IdentifierManager im;
        return value != null && (im = (IdentifierManager)engine.getPropertyManagerFactory().getValueManager(index)).getIdentifiers().get(value.toLowerCase().intern()) != null;
    }

    protected String getBackgroundImage(String[] values, CSSEngine engine) {
        int i = 0;
        while (i < values.length) {
            LexicalUnit u = this.getUnit(values[i], engine);
            if (u != null && u.getLexicalUnitType() == 24) {
                return values[i];
            }
            ++i;
        }
        return EMPTY_VALUE;
    }

    protected String getBorderStyle(String[] values, CSSEngine engine) {
        int i = 0;
        while (i < values.length) {
            LexicalUnit u = this.getUnit(values[i], engine);
            if (u != null && u.getLexicalUnitType() == 35 && this.isIdentifier(values[i], 49, engine)) {
                return values[i];
            }
            ++i;
        }
        return "solid";
    }

    protected String getBorderColor(String[] values, CSSEngine engine) {
        int i = 0;
        while (i < values.length) {
            LexicalUnit u = this.getUnit(values[i], engine);
            if (u != null) {
                if (u.getLexicalUnitType() == 27) {
                    return values[i];
                }
                if (u.getLexicalUnitType() == 35 && this.isIdentifier(values[i], 0, engine)) {
                    return values[i];
                }
            }
            ++i;
        }
        return "black";
    }

    protected String getBorderWidth(String[] values, CSSEngine engine) {
        int i = 0;
        while (i < values.length) {
            LexicalUnit u = this.getUnit(values[i], engine);
            if (u != null) {
                short type = u.getLexicalUnitType();
                if (type >= 15 && type <= 23) {
                    return values[i];
                }
                if (type == 35 && ("medium".equals(values[i]) || "thick".equals(values[i]) || "thin".equals(values[i]))) {
                    return values[i];
                }
            }
            ++i;
        }
        return "medium";
    }

    public ShortHandProcessor getProcessor(String name) {
        return processorMap.get(name);
    }

    protected void buildMargin(StringBuffer buffer, String top, String right, String bottom, String left) {
        ShortHandProcessor.appendStyle(buffer, "margin-top", top);
        ShortHandProcessor.appendStyle(buffer, "margin-right", right);
        ShortHandProcessor.appendStyle(buffer, "margin-bottom", bottom);
        ShortHandProcessor.appendStyle(buffer, "margin-left", left);
    }

    protected void buildPadding(StringBuffer buffer, String top, String right, String bottom, String left) {
        ShortHandProcessor.appendStyle(buffer, "padding-top", top);
        ShortHandProcessor.appendStyle(buffer, "padding-right", right);
        ShortHandProcessor.appendStyle(buffer, "padding-bottom", bottom);
        ShortHandProcessor.appendStyle(buffer, "padding-left", left);
    }

    protected void buildBorderWidth(StringBuffer buffer, String width) {
        ShortHandProcessor.appendStyle(buffer, "border-left-width", width);
        ShortHandProcessor.appendStyle(buffer, "border-right-width", width);
        ShortHandProcessor.appendStyle(buffer, "border-top-width", width);
        ShortHandProcessor.appendStyle(buffer, "border-bottom-width", width);
    }

    protected void buildBorderStyle(StringBuffer buffer, String style) {
        ShortHandProcessor.appendStyle(buffer, "border-left-style", style);
        ShortHandProcessor.appendStyle(buffer, "border-right-style", style);
        ShortHandProcessor.appendStyle(buffer, "border-top-style", style);
        ShortHandProcessor.appendStyle(buffer, "border-bottom-style", style);
    }

    protected void buildBorderColor(StringBuffer buffer, String color) {
        ShortHandProcessor.appendStyle(buffer, "border-left-color", color);
        ShortHandProcessor.appendStyle(buffer, "border-right-color", color);
        ShortHandProcessor.appendStyle(buffer, "border-top-color", color);
        ShortHandProcessor.appendStyle(buffer, "border-bottom-color", color);
    }

    protected void buildRightBorder(StringBuffer buffer, String width, String color, String style) {
        ShortHandProcessor.appendStyle(buffer, "border-right-width", width);
        ShortHandProcessor.appendStyle(buffer, "border-right-color", color);
        ShortHandProcessor.appendStyle(buffer, "border-right-style", style);
    }

    protected void buildBottomBorder(StringBuffer buffer, String width, String color, String style) {
        ShortHandProcessor.appendStyle(buffer, "border-bottom-width", width);
        ShortHandProcessor.appendStyle(buffer, "border-bottom-color", color);
        ShortHandProcessor.appendStyle(buffer, "border-bottom-style", style);
    }

    protected void buildLeftBorder(StringBuffer buffer, String width, String color, String style) {
        ShortHandProcessor.appendStyle(buffer, "border-left-width", width);
        ShortHandProcessor.appendStyle(buffer, "border-left-color", color);
        ShortHandProcessor.appendStyle(buffer, "border-left-style", style);
    }

    protected void buildTopBorder(StringBuffer buffer, String width, String color, String style) {
        ShortHandProcessor.appendStyle(buffer, "border-top-width", width);
        ShortHandProcessor.appendStyle(buffer, "border-top-color", color);
        ShortHandProcessor.appendStyle(buffer, "border-top-style", style);
    }

    protected void buildBorder(StringBuffer buffer, String width, String color, String style) {
        this.buildTopBorder(buffer, width, color, style);
        this.buildBottomBorder(buffer, width, color, style);
        this.buildLeftBorder(buffer, width, color, style);
        this.buildRightBorder(buffer, width, color, style);
    }

    public static void process(StringBuffer buffer, String name, String value, CSSEngine engine) {
        ShortHandProcessor p = processorMap.get(name);
        if (p != null) {
            p.process(buffer, value, engine);
        } else {
            ShortHandProcessor.appendStyle(buffer, name, value);
        }
    }
}

