/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.OlapQueryUtil;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DimensionLevel;
import org.eclipse.birt.report.data.adapter.api.IBindingMetaInfo;
import org.eclipse.birt.report.data.adapter.api.ICubeQueryUtil;
import org.eclipse.birt.report.data.adapter.api.IDimensionLevel;
import org.eclipse.birt.report.data.adapter.impl.DataRequestSessionImpl;
import org.eclipse.birt.report.data.adapter.impl.DataSetIterator;
import org.eclipse.birt.report.data.adapter.impl.DefineDataSourceSetUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;

public class CubeQueryUtil
implements ICubeQueryUtil {
    private DataRequestSessionImpl sessionImpl;
    private static Pattern pattern = Pattern.compile("(\\d+(\\.\\d*)?)*|(\\.\\d*)*");

    public CubeQueryUtil(DataRequestSessionImpl session) {
        this.sessionImpl = session;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List getReferableBindings(String targetLevel, ICubeQueryDefinition cubeDefn, boolean isSort) throws AdapterException {
        try {
            bindings = cubeDefn.getBindings();
            if (bindings == null) {
                return new ArrayList<E>();
            }
            target = OlapExpressionUtil.getTargetDimLevel(targetLevel);
            result = new ArrayList<BindingMetaInfo>();
            derivedBindings = OlapExpressionUtil.getDerivedMeasureNames(bindings);
            i = 0;
            while (i < bindings.size()) {
                block15: {
                    block18: {
                        block17: {
                            block16: {
                                binding = (IBinding)bindings.get(i);
                                if (!CubeQueryUtil.isNestAggregation(binding)) break block16;
                                result.add(new BindingMetaInfo(binding.getBindingName(), 1));
                                break block15;
                            }
                            if (OlapExpressionUtil.isDirectRerenrence(binding.getExpression(), bindings) && !derivedBindings.contains(binding.getBindingName()) && ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "data").isEmpty()) break block17;
                            result.add(new BindingMetaInfo(binding.getBindingName(), 13));
                            break block15;
                        }
                        refDimLevel = OlapExpressionCompiler.getReferencedDimLevel(binding.getExpression(), bindings, isSort);
                        if (refDimLevel.size() > 1) break block15;
                        if (refDimLevel.contains(target)) break block18;
                        aggrOns = binding.getAggregatOns();
                        if (this.isGrandTotal(binding) && isSort) break block15;
                        if (this.getReferencedMeasureName(binding.getExpression()) == null) ** GOTO lbl-1000
                        if (this.isMeasureBinding(cubeDefn, binding)) {
                            result.add(new BindingMetaInfo(binding.getBindingName(), 1));
                        } else if (this.isGrandTotal(binding)) {
                            result.add(new BindingMetaInfo(binding.getBindingName(), 11));
                        } else lbl-1000:
                        // 2 sources

                        {
                            j = 0;
                            while (j < aggrOns.size()) {
                                dimLevel = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(j).toString());
                                if (dimLevel.equals(target)) {
                                    if (j == aggrOns.size() - 1) {
                                        if (this.fromSameEdge(aggrOns, cubeDefn)) {
                                            result.add(new BindingMetaInfo(binding.getBindingName(), 11));
                                        } else {
                                            result.add(new BindingMetaInfo(binding.getBindingName(), 12));
                                        }
                                    } else {
                                        next = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(j + 1).toString());
                                        candidateEdge = this.getAxisQualifierEdgeType(dimLevel, cubeDefn);
                                        if (candidateEdge != -1 && this.getAxisQualifierLevel(next, cubeDefn.getEdge(candidateEdge)) != null) {
                                            result.add(new BindingMetaInfo(binding.getBindingName(), 12));
                                        }
                                    }
                                    break block15;
                                }
                                ++j;
                            }
                        }
                        break block15;
                    }
                    result.add(new BindingMetaInfo(binding.getBindingName(), 2));
                }
                ++i;
            }
            return result;
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private static boolean isNestAggregation(IBinding b) throws DataException {
        if (b.getAggrFunction() == null) {
            return false;
        }
        List<String> referencedBindings = ExpressionCompilerUtil.extractColumnExpression(b.getExpression(), "data");
        return referencedBindings != null && referencedBindings.size() != 0;
    }

    private boolean isMeasureBinding(ICubeQueryDefinition queryDefn, IBinding binding) throws DataException {
        if (binding.getAggrFunction() == null) {
            return true;
        }
        List aggrs = binding.getAggregatOns();
        int coveredLeafLevel = 0;
        int i = 0;
        while (i < aggrs.size()) {
            DimLevel dimLevel = OlapExpressionUtil.getTargetDimLevel(aggrs.get(i).toString());
            if (this.isLeafLevel(queryDefn, dimLevel)) {
                ++coveredLeafLevel;
            }
            ++i;
        }
        return coveredLeafLevel == this.getEdgeNumber(queryDefn);
    }

    private int getEdgeNumber(ICubeQueryDefinition cubeQuery) {
        int edgeNumber = 0;
        if (cubeQuery.getEdge(2) != null) {
            ++edgeNumber;
        }
        if (cubeQuery.getEdge(1) != null) {
            ++edgeNumber;
        }
        return edgeNumber;
    }

    @Override
    public List getReferableMeasureBindings(String measureName, ICubeQueryDefinition cubeDefn) throws DataException {
        ArrayList<BindingMetaInfo> result = new ArrayList<BindingMetaInfo>();
        List bindings = cubeDefn.getBindings();
        int i = 0;
        while (i < bindings.size()) {
            IBinding binding = (IBinding)bindings.get(i);
            String referencedMeasureName = this.getReferencedMeasureName(binding.getExpression());
            if (measureName.equals(referencedMeasureName)) {
                List aggrOns = binding.getAggregatOns();
                if (this.isMeasureBinding(cubeDefn, binding)) {
                    result.add(new BindingMetaInfo(binding.getBindingName(), 1));
                } else if (this.fromSameEdge(aggrOns, cubeDefn)) {
                    result.add(new BindingMetaInfo(binding.getBindingName(), 11));
                } else {
                    result.add(new BindingMetaInfo(binding.getBindingName(), 12));
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public List getReferableBindingsForLinkedDataSetCube(String targetLevel, ICubeQueryDefinition cubeQueryDefn, boolean isSort) throws AdapterException {
        return this.getReferableBindings(targetLevel, cubeQueryDefn, isSort);
    }

    @Override
    public List getReferableMeasureBindingsForLinkedDataSetCube(String measureName, ICubeQueryDefinition cubeDefn) throws DataException {
        return this.getReferableMeasureBindings(measureName, cubeDefn);
    }

    private boolean isGrandTotal(IBinding binding) throws DataException {
        return binding.getAggregatOns().size() == 0;
    }

    private boolean fromSameEdge(List aggrOns, ICubeQueryDefinition cubeDefn) throws DataException {
        int candidateEdge = -1;
        int i = 0;
        while (i < aggrOns.size()) {
            DimLevel dimLevel = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(i).toString());
            if (candidateEdge == -1) {
                candidateEdge = this.getAxisQualifierEdgeType(dimLevel, cubeDefn);
            } else if (candidateEdge != this.getAxisQualifierEdgeType(dimLevel, cubeDefn)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isLeafLevel(ICubeQueryDefinition query, DimLevel target) {
        return this.isLeafLevel(query.getEdge(2), target) || this.isLeafLevel(query.getEdge(1), target);
    }

    private boolean isLeafLevel(IEdgeDefinition edge, DimLevel target) {
        if (edge == null) {
            return false;
        }
        IDimensionDefinition dim = edge.getDimensions().get(edge.getDimensions().size() - 1);
        if (dim.getName().equals(target.getDimensionName())) {
            IHierarchyDefinition hier = dim.getHierarchy().get(0);
            ILevelDefinition level = hier.getLevels().get(hier.getLevels().size() - 1);
            if (target.getLevelName().equals(level.getName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List getReferencedLevels(String targetLevel, String bindingExpr, ICubeQueryDefinition queryDefn) throws AdapterException {
        try {
            int candidateEdge;
            ArrayList<ILevelDefinition> result = new ArrayList<ILevelDefinition>();
            DimLevel target = OlapExpressionUtil.getTargetDimLevel(targetLevel);
            String bindingName = OlapExpressionCompiler.getReferencedScriptObject(bindingExpr, "data");
            if (bindingName == null) {
                return result;
            }
            IBinding binding = null;
            List bindings = queryDefn.getBindings();
            int i = 0;
            while (i < bindings.size()) {
                IBinding bd = (IBinding)bindings.get(i);
                if (bd.getBindingName().equals(bindingName)) {
                    binding = bd;
                    break;
                }
                ++i;
            }
            if (binding == null) {
                return result;
            }
            List aggrOns = binding.getAggregatOns();
            boolean isMeasure = false;
            if (aggrOns.size() == 0) {
                boolean bl = isMeasure = this.getReferencedMeasureName(binding.getExpression()) != null;
            }
            if ((candidateEdge = this.getAxisQualifierEdgeType(target, queryDefn)) == -1) {
                return result;
            }
            IEdgeDefinition axisQualifierEdge = queryDefn.getEdge(candidateEdge);
            if (isMeasure) {
                int i2 = 0;
                while (i2 < axisQualifierEdge.getDimensions().size()) {
                    IHierarchyDefinition hier = axisQualifierEdge.getDimensions().get(i2).getHierarchy().get(0);
                    result.addAll(hier.getLevels());
                    ++i2;
                }
            } else {
                int i3 = 0;
                while (i3 < aggrOns.size()) {
                    DimLevel dimLevel = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(i3).toString());
                    ILevelDefinition lvl = this.getAxisQualifierLevel(dimLevel, axisQualifierEdge);
                    if (lvl != null) {
                        result.add(lvl);
                    }
                    ++i3;
                }
            }
            return result;
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private ILevelDefinition getAxisQualifierLevel(DimLevel dimLevel, IEdgeDefinition edge) {
        if (edge == null) {
            return null;
        }
        List<IDimensionDefinition> dims = edge.getDimensions();
        int i = 0;
        while (i < dims.size()) {
            IDimensionDefinition dim = dims.get(i);
            if (!dim.getName().equals(dimLevel.getDimensionName())) {
                return null;
            }
            IHierarchyDefinition hier = dim.getHierarchy().get(0);
            List<ILevelDefinition> levels = hier.getLevels();
            int j = 0;
            while (j < levels.size()) {
                ILevelDefinition level = levels.get(j);
                if (level.getName().equals(dimLevel.getLevelName())) {
                    return level;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private int getAxisQualifierEdgeType(DimLevel dimLevel, ICubeQueryDefinition queryDefn) {
        IDimensionDefinition dim;
        int i;
        List<IDimensionDefinition> dims;
        IEdgeDefinition edge = queryDefn.getEdge(2);
        if (edge != null) {
            dims = edge.getDimensions();
            i = 0;
            while (i < dims.size()) {
                dim = dims.get(i);
                if (dim.getName().equals(dimLevel.getDimensionName())) {
                    return 1;
                }
                ++i;
            }
        }
        if ((edge = queryDefn.getEdge(1)) != null) {
            dims = edge.getDimensions();
            i = 0;
            while (i < dims.size()) {
                dim = dims.get(i);
                if (dim.getName().equals(dimLevel.getDimensionName())) {
                    return 2;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public String getReferencedMeasureName(String expr) throws AdapterException {
        return OlapExpressionCompiler.getReferencedScriptObject(expr, "measure");
    }

    private String getReferencedMeasureName(IBaseExpression expr) {
        return OlapExpressionCompiler.getReferencedScriptObject(expr, "measure");
    }

    @Override
    public Iterator getMemberValueIterator(TabularCubeHandle cubeHandle, String dataBindingExpr, ICubeQueryDefinition queryDefn) throws AdapterException {
        return this.getMemberValueIterator(cubeHandle, dataBindingExpr, queryDefn, null);
    }

    @Override
    public Iterator getMemberValueIterator(CubeHandle cubeHandle, String dataBindingExpr, ICubeQueryDefinition queryDefn) throws AdapterException {
        return this.getMemberValueIterator(cubeHandle, dataBindingExpr, queryDefn, null);
    }

    @Override
    public Iterator getMemberValueIterator(CubeHandle cubeHandle, String dataBindingExpr, ICubeQueryDefinition queryDefn, Map appContext) throws AdapterException {
        Set dimLevels;
        List bindings;
        block7: {
            block6: {
                try {
                    if (cubeHandle != null && dataBindingExpr != null && queryDefn != null) break block6;
                    return null;
                }
                catch (BirtException e) {
                    throw new AdapterException(e.getLocalizedMessage(), e);
                }
            }
            bindings = queryDefn.getBindings();
            dimLevels = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)new ScriptExpression(dataBindingExpr), bindings, true);
            if (dimLevels.size() != 0 && dimLevels.size() <= 1) break block7;
            return null;
        }
        DimLevel target = (DimLevel)dimLevels.iterator().next();
        int targetDataType = this.getTargetDataType(bindings, dataBindingExpr);
        TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)cubeHandle.getDimension(target.getDimensionName()).getContent("hierarchies", 0);
        if (hierHandle.getDataSet() != null) {
            DefineDataSourceSetUtil.defineDataSourceAndDataSet(hierHandle.getDataSet(), this.sessionImpl);
        } else {
            DefineDataSourceSetUtil.defineDataSourceAndDataSet((DataSetHandle)cubeHandle.getElementProperty("dataSet"), this.sessionImpl);
        }
        HashMap levelValueMap = new HashMap();
        DataSetIterator it = this.createDataSetIterator(appContext, cubeHandle.getDimension(target.getDimensionName()), String.valueOf(cubeHandle.getElement().getID()));
        return new MemberValueIterator(it, levelValueMap, target.getLevelName(), target.getAttrName(), targetDataType);
    }

    @Override
    public Iterator getMemberValueIterator(TabularCubeHandle cubeHandle, String dataBindingExpr, ICubeQueryDefinition queryDefn, Map appContext) throws AdapterException {
        Set dimLevels;
        List bindings;
        block7: {
            block6: {
                try {
                    if (cubeHandle != null && dataBindingExpr != null && queryDefn != null) break block6;
                    return null;
                }
                catch (BirtException e) {
                    throw new AdapterException(e.getLocalizedMessage(), e);
                }
            }
            bindings = queryDefn.getBindings();
            dimLevels = OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)new ScriptExpression(dataBindingExpr), bindings, true);
            if (dimLevels.size() != 0 && dimLevels.size() <= 1) break block7;
            return null;
        }
        DimLevel target = (DimLevel)dimLevels.iterator().next();
        int targetDataType = this.getTargetDataType(bindings, dataBindingExpr);
        TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)cubeHandle.getDimension(target.getDimensionName()).getContent("hierarchies", 0);
        if (hierHandle.getDataSet() != null) {
            DefineDataSourceSetUtil.defineDataSourceAndDataSet(hierHandle.getDataSet(), this.sessionImpl);
        } else {
            DefineDataSourceSetUtil.defineDataSourceAndDataSet(cubeHandle.getDataSet(), this.sessionImpl);
        }
        HashMap levelValueMap = new HashMap();
        DataSetIterator it = this.createDataSetIterator(appContext, cubeHandle.getDimension(target.getDimensionName()), String.valueOf(cubeHandle.getElement().getID()));
        return new MemberValueIterator(it, levelValueMap, target.getLevelName(), target.getAttrName(), targetDataType);
    }

    private int getTargetDataType(List bindings, String dataBindingExpr) throws BirtException {
        String bindingName = OlapExpressionCompiler.getReferencedScriptObject(dataBindingExpr, "data");
        if (bindingName == null) {
            return -1;
        }
        int i = 0;
        while (i < bindings.size()) {
            IBinding binding = (IBinding)bindings.get(i);
            if (binding.getBindingName().equals(bindingName)) {
                return binding.getDataType();
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Iterator getMemberValueIterator(CubeHandle cubeHandle, String targetLevel, DimensionLevel[] dimensionLevels, Object[] values) throws AdapterException {
        return this.getMemberValueIterator(cubeHandle, targetLevel, dimensionLevels, values, null);
    }

    @Override
    public Iterator getMemberValueIterator(TabularCubeHandle cubeHandle, String targetLevel, DimensionLevel[] dimensionLevels, Object[] values) throws AdapterException {
        return this.getMemberValueIterator(cubeHandle, targetLevel, dimensionLevels, values, null);
    }

    @Override
    public Iterator getMemberValueIterator(CubeHandle cubeHandle, String targetLevel, DimensionLevel[] dimensionLevels, Object[] values, Map appContext) throws AdapterException {
        block8: {
            if (!(dimensionLevels == null && values != null || dimensionLevels != null && values == null || cubeHandle == null) && targetLevel != null) break block8;
            return null;
        }
        try {
            DimLevel target = OlapExpressionUtil.getTargetDimLevel(targetLevel);
            TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)cubeHandle.getDimension(target.getDimensionName()).getContent("hierarchies", 0);
            if (hierHandle.getDataSet() != null) {
                DefineDataSourceSetUtil.defineDataSourceAndDataSet(hierHandle.getDataSet(), this.sessionImpl);
            } else {
                DefineDataSourceSetUtil.defineDataSourceAndDataSet((DataSetHandle)cubeHandle.getElementProperty("dataSet"), this.sessionImpl);
            }
            HashMap<String, Object> levelValueMap = new HashMap<String, Object>();
            if (dimensionLevels != null) {
                int i = 0;
                while (i < dimensionLevels.length) {
                    if (target.getDimensionName().equals(dimensionLevels[i].getDimensionName())) {
                        levelValueMap.put(dimensionLevels[i].getLevelName(), values[i]);
                    }
                    ++i;
                }
            }
            DataSetIterator it = this.createDataSetIterator(appContext, cubeHandle.getDimension(target.getDimensionName()), String.valueOf(cubeHandle.getElement().getID()));
            return new MemberValueIterator(it, levelValueMap, target.getLevelName(), target.getAttrName());
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Iterator getMemberValueIterator(TabularCubeHandle cubeHandle, String targetLevel, DimensionLevel[] dimensionLevels, Object[] values, Map appContext) throws AdapterException {
        block8: {
            if (!(dimensionLevels == null && values != null || dimensionLevels != null && values == null || cubeHandle == null) && targetLevel != null) break block8;
            return null;
        }
        try {
            DimLevel target = OlapExpressionUtil.getTargetDimLevel(targetLevel);
            TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)cubeHandle.getDimension(target.getDimensionName()).getContent("hierarchies", 0);
            if (hierHandle.getDataSet() != null) {
                DefineDataSourceSetUtil.defineDataSourceAndDataSet(hierHandle.getDataSet(), this.sessionImpl);
            } else {
                DefineDataSourceSetUtil.defineDataSourceAndDataSet(cubeHandle.getDataSet(), this.sessionImpl);
            }
            HashMap<String, Object> levelValueMap = new HashMap<String, Object>();
            if (dimensionLevels != null) {
                int i = 0;
                while (i < dimensionLevels.length) {
                    if (target.getDimensionName().equals(dimensionLevels[i].getDimensionName())) {
                        levelValueMap.put(dimensionLevels[i].getLevelName(), values[i]);
                    }
                    ++i;
                }
            }
            DataSetIterator it = this.createDataSetIterator(appContext, cubeHandle.getDimension(target.getDimensionName()), String.valueOf(cubeHandle.getElement().getID()));
            return new MemberValueIterator(it, levelValueMap, target.getLevelName(), target.getAttrName());
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Iterator getMemberValueIterator(TabularCubeHandle cubeHandle, String targetLevel, ILevelDefinition[] higherLevelDefns, Object[] values) throws AdapterException {
        return this.getMemberValueIterator(cubeHandle, targetLevel, higherLevelDefns, values, null);
    }

    @Override
    public Iterator getMemberValueIterator(TabularCubeHandle cubeHandle, String targetLevel, ILevelDefinition[] higherLevelDefns, Object[] values, Map appContext) throws AdapterException {
        block8: {
            if (!(higherLevelDefns == null && values != null || higherLevelDefns != null && values == null || cubeHandle == null) && targetLevel != null) break block8;
            return null;
        }
        try {
            DimLevel target = OlapExpressionUtil.getTargetDimLevel(targetLevel);
            TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)cubeHandle.getDimension(target.getDimensionName()).getContent("hierarchies", 0);
            if (hierHandle.getDataSet() != null) {
                DefineDataSourceSetUtil.defineDataSourceAndDataSet(hierHandle.getDataSet(), this.sessionImpl);
            } else {
                DefineDataSourceSetUtil.defineDataSourceAndDataSet(cubeHandle.getDataSet(), this.sessionImpl);
            }
            HashMap<String, Object> levelValueMap = new HashMap<String, Object>();
            if (higherLevelDefns != null) {
                int i = 0;
                while (i < higherLevelDefns.length) {
                    if (target.getDimensionName().equals(higherLevelDefns[i].getHierarchy().getDimension().getName())) {
                        levelValueMap.put(higherLevelDefns[i].getName(), values[i]);
                    }
                    ++i;
                }
            }
            DataSetIterator it = this.createDataSetIterator(appContext, cubeHandle.getDimension(target.getDimensionName()), String.valueOf(cubeHandle.getElement().getID()));
            return new MemberValueIterator(it, levelValueMap, target.getLevelName(), target.getAttrName());
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public boolean isValidDimensionName(String name) {
        Matcher isNum = pattern.matcher(name);
        return !isNum.matches();
    }

    private DataSetIterator createDataSetIterator(Map appContext, DimensionHandle dim, String cubeName) throws AdapterException, BirtException {
        ArrayList<DataSetIterator.ColumnMeta> metaList = new ArrayList<DataSetIterator.ColumnMeta>();
        QueryDefinition defn = this.sessionImpl.createDimensionQuery(this.sessionImpl, dim, (TabularHierarchyHandle)dim.getContent("hierarchies", 0), metaList, cubeName);
        return new DataSetIterator(this.sessionImpl, defn, metaList, appContext);
    }

    @Override
    public List getInvalidBindings(ICubeQueryDefinition queryDefn) throws AdapterException {
        try {
            ArrayList<String> invalidBindingNameList = new ArrayList<String>();
            List invalidBinding = OlapQueryUtil.validateBinding(queryDefn, true);
            int i = 0;
            while (i < invalidBinding.size()) {
                IBinding binding = (IBinding)invalidBinding.get(i);
                invalidBindingNameList.add(binding.getBindingName());
                ++i;
            }
            return invalidBindingNameList;
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public List getInvalidBindingsForLinkedDataSetCube(ICubeQueryDefinition queryDefn) throws AdapterException {
        return this.getInvalidBindings(queryDefn);
    }

    @Override
    public IDimensionLevel[] getReferencedDimensionLevel(String expression) throws AdapterException {
        try {
            IDimensionLevel[] result = new IDimensionLevel[]{};
            Set dimLevels = OlapExpressionCompiler.getReferencedDimLevel(new ScriptExpression(expression), new ArrayList());
            if (dimLevels != null) {
                result = new IDimensionLevel[dimLevels.size()];
                Iterator it = dimLevels.iterator();
                int index = 0;
                while (it.hasNext()) {
                    DimLevel dimLevel = (DimLevel)it.next();
                    result[index] = new DimensionLevel(dimLevel);
                    ++index;
                }
            }
            return result;
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public IDimensionLevel[] getReferencedDimensionLevel(String expression, List<IBinding> bindings) throws AdapterException {
        try {
            IDimensionLevel[] result = new IDimensionLevel[]{};
            Set dimLevels = OlapExpressionCompiler.getReferencedDimLevel(new ScriptExpression(expression), bindings);
            if (dimLevels != null) {
                result = new IDimensionLevel[dimLevels.size()];
                Iterator it = dimLevels.iterator();
                int index = 0;
                while (it.hasNext()) {
                    DimLevel dimLevel = (DimLevel)it.next();
                    result[index] = new DimensionLevel(dimLevel);
                    ++index;
                }
            }
            return result;
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private static class BindingMetaInfo
    implements IBindingMetaInfo {
        private String name;
        private int type;

        BindingMetaInfo(String name, int type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public int getBindingType() {
            return this.type;
        }

        @Override
        public String getBindingName() {
            return this.name;
        }
    }

    private static class MemberValueIterator
    implements Iterator {
        private IDatasetIterator dataSetIterator;
        private boolean hasNext;
        private Map levelValueMap;
        private String targetLevelName;
        private Object currentValue;
        private String attribute;
        private int targetDateType;

        public MemberValueIterator(IDatasetIterator it, Map levelValueMap, String targetLevelName, String attribute) {
            this(it, levelValueMap, targetLevelName, attribute, -1);
        }

        public MemberValueIterator(IDatasetIterator it, Map levelValueMap, String targetLevelName, String attribute, int targetDataType) {
            this.dataSetIterator = it;
            this.hasNext = true;
            this.levelValueMap = levelValueMap;
            this.targetLevelName = targetLevelName;
            this.attribute = attribute;
            this.targetDateType = targetDataType;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            block5: {
                if (this.hasNext) break block5;
                return null;
            }
            try {
                Object result = this.currentValue;
                boolean accept = false;
                while (this.dataSetIterator.next()) {
                    accept = true;
                    Iterator it = this.levelValueMap.keySet().iterator();
                    while (it.hasNext()) {
                        String key = it.next().toString();
                        Object value = this.levelValueMap.get(key);
                        if (ScriptEvalUtil.compare(value, this.dataSetIterator.getValue(this.dataSetIterator.getFieldIndex(key))) == 0) continue;
                        accept = false;
                        break;
                    }
                    if (!accept) continue;
                    this.currentValue = this.dataSetIterator.getValue(this.dataSetIterator.getFieldIndex(this.attribute == null ? this.targetLevelName : OlapExpressionUtil.getAttributeColumnName(this.targetLevelName, this.attribute)));
                    break;
                }
                this.hasNext = accept;
                return DataTypeUtil.convert(result, this.targetDateType);
            }
            catch (BirtException e) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

