/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Set;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.ICombinedOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.OdaDataSetRuntime;

public class CombinedOdaDataSetRuntime
extends OdaDataSetRuntime {
    private DataSetRuntime[] dataSetRuntimes;

    public CombinedOdaDataSetRuntime(ICombinedOdaDataSetDesign dataSet, IQueryExecutor executor, DataEngineSession session) throws DataException {
        this((IOdaDataSetDesign)dataSet, executor, session);
    }

    private CombinedOdaDataSetRuntime(IOdaDataSetDesign dataSet, IQueryExecutor executor, DataEngineSession session) throws DataException {
        super(dataSet, executor, session);
        ICombinedOdaDataSetDesign design = (ICombinedOdaDataSetDesign)dataSet;
        Set<IOdaDataSetDesign> childDesigns = design.getDataSetDesigns();
        this.dataSetRuntimes = new DataSetRuntime[childDesigns.size()];
        int i = 0;
        for (IBaseDataSetDesign iBaseDataSetDesign : childDesigns) {
            this.dataSetRuntimes[i++] = DataSetRuntime.newInstance(iBaseDataSetDesign, this.queryExecutor, session);
        }
    }

    public String getQueryText(String dataSetName) {
        DataSetRuntime[] dataSetRuntimeArray = this.dataSetRuntimes;
        int n = this.dataSetRuntimes.length;
        int n2 = 0;
        while (n2 < n) {
            DataSetRuntime dataSetRuntime = dataSetRuntimeArray[n2];
            if (dataSetRuntime.getName().equals(dataSetName)) {
                return dataSetRuntime.getQueryText();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void beforeOpen() throws DataException {
        DataSetRuntime[] dataSetRuntimeArray = this.dataSetRuntimes;
        int n = this.dataSetRuntimes.length;
        int n2 = 0;
        while (n2 < n) {
            DataSetRuntime dataSetRuntime = dataSetRuntimeArray[n2];
            dataSetRuntime.beforeOpen();
            ++n2;
        }
    }

    @Override
    public void beforeClose() throws DataException {
        DataSetRuntime[] dataSetRuntimeArray = this.dataSetRuntimes;
        int n = this.dataSetRuntimes.length;
        int n2 = 0;
        while (n2 < n) {
            DataSetRuntime dataSetRuntime = dataSetRuntimeArray[n2];
            dataSetRuntime.beforeClose();
            ++n2;
        }
    }
}

