/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.log;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.eclipse.birt.chart.internal.log.JavaUtilLoggerImpl;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.core.framework.Platform;

public final class Logger {
    private static StreamHandler tracingHandler;

    private Logger() {
    }

    public static synchronized ILogger getLogger(String name) {
        String value;
        String pluginId;
        boolean isDebugging;
        int idx;
        JavaUtilLoggerImpl chartLogger = new JavaUtilLoggerImpl(name);
        if (name != null && (idx = name.indexOf("/")) > 0 && (isDebugging = "true".equals(Platform.getDebugOption(String.valueOf(pluginId = name.substring(0, idx)) + "/debug"))) && "true".equals(value = Platform.getDebugOption(name))) {
            java.util.logging.Logger javaLogger = chartLogger.getJavaLogger();
            try {
                if (javaLogger.getLevel().intValue() > Level.FINEST.intValue()) {
                    javaLogger.setLevel(Level.FINEST);
                }
                javaLogger.removeHandler(Logger.getTracingHandler());
                javaLogger.addHandler(Logger.getTracingHandler());
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return chartLogger;
    }

    private static StreamHandler getTracingHandler() {
        if (tracingHandler == null) {
            tracingHandler = AccessController.doPrivileged(new PrivilegedAction<StreamHandler>(){

                @Override
                public StreamHandler run() {
                    StreamHandler handler = new StreamHandler(System.out, new SimpleFormatter());
                    try {
                        tracingHandler.setLevel(Level.ALL);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    return handler;
                }
            });
        }
        return tracingHandler;
    }
}

