/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.Map;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.model.MultigetCountQuery;
import me.prettyprint.cassandra.model.QueryResultImpl;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.query.QueryResult;
import org.apache.cassandra.thrift.ColumnParent;

public class MultigetSubCountQuery<K, SN, N>
extends MultigetCountQuery<K, N> {
    private final Serializer<SN> superNameSerializer;
    private SN superColumnName;

    public MultigetSubCountQuery(Keyspace ko, Serializer<SN> superNameSerializer, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        super(ko, keySerializer, nameSerializer);
        Assert.notNull(superNameSerializer, "superNameSerializer is null");
        this.superNameSerializer = superNameSerializer;
    }

    public MultigetSubCountQuery<K, SN, N> setSuperColumn(SN sc) {
        this.superColumnName = sc;
        return this;
    }

    @Override
    public QueryResult<Map<K, Integer>> execute() {
        Assert.notNull(this.keys, "keys list is null");
        Assert.notNull(this.columnFamily, "columnFamily is null");
        Assert.notNull(this.superColumnName, "superColumnName is null");
        return new QueryResultImpl<Map<K, Integer>>(this.keyspace.doExecute(new KeyspaceOperationCallback<Map<K, Integer>>(){

            @Override
            public Map<K, Integer> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(MultigetSubCountQuery.this.columnFamily);
                columnParent.setSuper_column(MultigetSubCountQuery.this.superNameSerializer.toByteBuffer(MultigetSubCountQuery.this.superColumnName));
                Map counts = MultigetSubCountQuery.this.keySerializer.fromBytesMap(ks.multigetCount(MultigetSubCountQuery.this.keySerializer.toBytesList(MultigetSubCountQuery.this.keys), columnParent, MultigetSubCountQuery.this.slicePredicate.toThrift()));
                return counts;
            }
        }), this);
    }
}

