/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.wizards;

import org.eclipse.birt.report.designer.internal.ui.editors.wizards.WizardSaveAsPage;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;

public class SaveReportAsWizard
extends Wizard {
    private static final String SaveAsWizardWindowTitle = Messages.getString((String)"SaveReportAsWizard.SaveAsWizardWindowTitle");
    private static final String SaveAsWizardPageTitle = Messages.getString((String)"SaveReportAsWizard.SaveAsWizardPageTitle");
    private static final String SaveAsWizardPageDesc = Messages.getString((String)"SaveReportAsWizard.SaveAsWizardPageDesc");
    private static final String ReportSettingPageTitle = Messages.getString((String)"SaveReportAsWizard.SettingPageTitle");
    private static final String ReportSettingPageMessage = Messages.getString((String)"SaveReportAsWizard.SettingPage.message");
    private ModuleHandle model;
    private IEditorInput orginalFile;
    private WizardSaveAsPage saveAsPage;
    private WizardReportSettingPage settingPage;
    private IPath saveAsPath;

    public SaveReportAsWizard(ModuleHandle model, IEditorInput orginalFile) {
        this.setWindowTitle(SaveAsWizardWindowTitle);
        this.model = model;
        this.orginalFile = orginalFile;
    }

    public void addPages() {
        this.saveAsPage = new WizardSaveAsPage("WizardSaveAsPage");
        this.saveAsPage.setOriginalFile(this.orginalFile);
        this.saveAsPage.setTitle(SaveAsWizardPageTitle);
        this.saveAsPage.setMessage(SaveAsWizardPageDesc);
        this.addPage((IWizardPage)this.saveAsPage);
        if (this.model instanceof ReportDesignHandle) {
            this.settingPage = new WizardReportSettingPage((ReportDesignHandle)this.model);
            this.settingPage.setTitle(ReportSettingPageTitle);
            this.settingPage.setPageDesc(ReportSettingPageMessage);
            this.addPage((IWizardPage)this.settingPage);
        }
    }

    public boolean canFinish() {
        return this.saveAsPage.validatePage();
    }

    public boolean performFinish() {
        this.saveAsPath = this.saveAsPage.getResult();
        if (this.saveAsPath != null && this.saveAsPath.isEmpty()) {
            return false;
        }
        if (this.saveAsPath != null && this.model instanceof ReportDesignHandle) {
            ReportDesignHandle reportHandle = (ReportDesignHandle)this.model;
            try {
                reportHandle.setDisplayName(this.settingPage.getDisplayName());
                reportHandle.setDescription(this.settingPage.getDescription());
                if (!this.settingPage.getPreviewImagePath().equals("")) {
                    reportHandle.setIconFile(this.settingPage.getPreviewImagePath());
                    reportHandle.deleteThumbnail();
                }
                reportHandle.setFileName(this.saveAsPath.toOSString());
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
        return true;
    }

    public IPath getSaveAsPath() {
        return this.saveAsPath;
    }
}

