/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dnd;

import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.extension.IExtendedDataModelUIAdapter;
import org.eclipse.birt.report.designer.util.IVirtualValidator;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class MeasureHandleDropAdapter
implements IDropAdapter {
    private IExtendedDataModelUIAdapter adapter = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter();

    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        EditPart editPart;
        if (!this.isMeasureHandle(transfer)) {
            return 0;
        }
        if (target instanceof EditPart && (editPart = (EditPart)target).getModel() instanceof IVirtualValidator) {
            if (((IVirtualValidator)editPart.getModel()).handleValidate(transfer)) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private boolean isMeasureHandle(Object transfer) {
        if (transfer instanceof Object[]) {
            Object[] items = (Object[])transfer;
            int i = 0;
            while (i < items.length) {
                if (!(items[i] instanceof MeasureHandle)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return transfer instanceof MeasureHandle || transfer instanceof MeasureGroupHandle;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (target instanceof EditPart) {
            EditPart editPart = (EditPart)target;
            CreateRequest request = new CreateRequest();
            request.getExtendedData().put("newObject", transfer);
            request.setLocation(location.getPoint());
            Command command = editPart.getCommand((Request)request);
            if (command != null && command.canExecute()) {
                ReportElementHandle extendedData;
                CubeHandle measureCubeHandle;
                CrosstabReportItemHandle crosstab = this.getCrosstab(editPart);
                if (crosstab != null) {
                    crosstab.getModuleHandle().getCommandStack().startTrans(Messages.getString("MeasureHandleDropAdapter_trans_name"));
                }
                if (!((measureCubeHandle = CrosstabAdaptUtil.getCubeHandle((DesignElementHandle)((ReportElementHandle)transfer))) != null || (extendedData = this.adapter.getBoundExtendedData((ReportItemHandle)crosstab.getModelHandle())) != null && extendedData.equals(this.adapter.resolveExtendedData((DesignElementHandle)((ReportElementHandle)transfer))) || this.adapter.setExtendedData((ReportItemHandle)crosstab.getModelHandle(), this.adapter.resolveExtendedData((DesignElementHandle)((ReportElementHandle)transfer))))) {
                    crosstab.getModuleHandle().getCommandStack().rollback();
                    return false;
                }
                editPart.getViewer().getEditDomain().getCommandStack().execute(command);
                if (crosstab != null) {
                    AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(crosstab);
                    providerWrapper.updateAllAggregationCells(0);
                    if (crosstab.getDimensionCount(1) != 0) {
                        DimensionViewHandle viewHnadle = crosstab.getDimension(1, crosstab.getDimensionCount(1) - 1);
                        CrosstabUtil.addLabelToHeader((LevelViewHandle)viewHnadle.getLevel(viewHnadle.getLevelCount() - 1));
                    }
                    crosstab.getModuleHandle().getCommandStack().commit();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private CrosstabReportItemHandle getCrosstab(EditPart editPart) {
        CrosstabReportItemHandle crosstab = null;
        Object tmp = editPart.getModel();
        if (!(tmp instanceof CrosstabCellAdapter)) {
            return null;
        }
        if (tmp instanceof VirtualCrosstabCellAdapter) {
            return ((VirtualCrosstabCellAdapter)tmp).getCrosstabReportItemHandle();
        }
        CrosstabCellHandle handle = ((CrosstabCellAdapter)tmp).getCrosstabCellHandle();
        if (handle != null) {
            crosstab = handle.getCrosstab();
        }
        return crosstab;
    }
}

