/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabComputedMeasureExpressionProvider;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddComputedSummaryDialog
extends BaseDialog {
    private CrosstabReportItemHandle crosstab = null;
    private static final String TITLE = Messages.getString("AddComputedSummaryDialog.Title");
    private Text nameText;
    private Text expressionText;
    private Combo dataTypeCmb;
    private CLabel errorLabel;
    private String name;
    private Expression expression;
    private String dataType;
    protected static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices();
    protected String[] dataTypes = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)DATA_TYPE_CHOICE_SET);
    protected static final IChoice[] DATA_TYPE_CHOICES = DATA_TYPE_CHOICE_SET.getChoices(null);
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AddComputedSummaryDialog.this.validate();
        }
    };

    public AddComputedSummaryDialog(Shell parentShell, CrosstabReportItemHandle crosstab) {
        super(parentShell, TITLE);
        this.crosstab = crosstab;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)layout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("AddComputedSummaryDialog.Label.Name"));
        this.nameText = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        gridData.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gridData);
        this.nameText.addModifyListener(this.modifyListener);
        Label dataTypeLb = new Label(composite, 0);
        dataTypeLb.setText(Messages.getString("AddComputedSummaryDialog.Label.DataType"));
        this.dataTypeCmb = new Combo(composite, 2056);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.dataTypeCmb.setLayoutData((Object)gridData);
        this.dataTypeCmb.setVisibleItemCount(30);
        Label expressionLabel = new Label(composite, 0);
        expressionLabel.setText(Messages.getString("AddComputedSummaryDialog.Label.Expression"));
        this.expressionText = new Text(composite, 2050);
        gridData = new GridData(768);
        gridData.heightHint = this.expressionText.computeSize((int)-1, (int)-1).y - this.expressionText.getBorderWidth() * 2;
        this.expressionText.setLayoutData((Object)gridData);
        this.expressionText.addModifyListener(this.modifyListener);
        ExpressionButtonUtil.createExpressionButton((Composite)composite, (Control)this.expressionText, (IExpressionProvider)new CrosstabComputedMeasureExpressionProvider(this.crosstab.getModelHandle()), (Object)this.crosstab.getModelHandle());
        Label seperator = new Label(parentComposite, 258);
        gridData = new GridData(768);
        seperator.setLayoutData((Object)gridData);
        this.errorLabel = new CLabel(parentComposite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.AddComputedSummaryDialog_ID");
        return parentComposite;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initialize();
        this.validate();
        return contents;
    }

    protected void initialize() {
        this.dataTypeCmb.setItems(this.dataTypes);
        if (this.dataTypeCmb.getItemCount() > 0) {
            int i = 0;
            while (i < DATA_TYPE_CHOICES.length) {
                if ("string".equals(DATA_TYPE_CHOICES[i].getValue())) {
                    this.dataTypeCmb.select(i);
                    return;
                }
                ++i;
            }
            this.dataTypeCmb.select(0);
        }
    }

    protected void validate() {
        boolean ok = true;
        String EMPTY_STRING = "";
        String errorMessage = "";
        String name = this.nameText.getText().trim();
        String expression = this.expressionText.getText().trim();
        if (name.length() == 0) {
            errorMessage = Messages.getString("AddComputedSummaryDialog.ErrMsg.Msg1");
        } else if (this.crosstab.getMeasure(name) != null) {
            errorMessage = Messages.getString("AddComputedSummaryDialog.ErrMsg.Msg2");
        } else if (expression.length() == 0) {
            errorMessage = Messages.getString("AddComputedSummaryDialog.ErrMsg.Msg3");
        }
        if (!errorMessage.equals("")) {
            ok = false;
        }
        this.getOkButton().setEnabled(ok);
        if (this.errorLabel != null && !this.errorLabel.isDisposed()) {
            this.errorLabel.setText(errorMessage);
            if (ok) {
                this.errorLabel.setImage(null);
            } else {
                this.errorLabel.setImage(ReportPlatformUIImages.getImage((String)"IMG_OBJS_ERROR_TSK"));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getDataType() {
        return this.dataType;
    }

    protected void okPressed() {
        this.name = this.nameText.getText().trim();
        this.expression = new Expression((Object)this.expressionText.getText(), (String)this.expressionText.getData("exprType"));
        this.dataType = this.getType();
        super.okPressed();
    }

    private String getType() {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.dataTypeCmb.getText())) {
                return DATA_TYPE_CHOICES[i].getName();
            }
            ++i;
        }
        return "";
    }
}

