/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui;

import com.ibm.icu.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.providers.ISchematicMenuListener;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.util.CategorizedElementSorter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.GeneralInsertMenuAction;
import org.eclipse.birt.report.designer.ui.actions.InsertAggregationAction;
import org.eclipse.birt.report.designer.ui.actions.InsertRelativeTimePeriodAction;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddComputedMeasureAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddLevelHandleAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddMeasureViewHandleAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddRelativeTimePeriodAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddSubTotalAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.CopyCrosstabCellContentsAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.DeleteDimensionViewHandleAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.DeleteMeasureHandleAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.MergeCrosstabHeaderCellAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.ShowAsViewMenuAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.SplitCrosstabHeadCellAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.ui.extension.IAggregationCellViewProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class CrosstabCellMenuAdapterFactory
implements IAdapterFactory {
    private void createMeasureMenu(IMenuManager menu, Object firstSelectedObj, IContributionItem beforeThis) {
        DesignElementHandle element = null;
        String firstId = beforeThis.getId();
        if (firstSelectedObj instanceof DesignElementHandle) {
            element = (DesignElementHandle)firstSelectedObj;
        } else if (firstSelectedObj instanceof CrosstabCellAdapter) {
            element = ((CrosstabCellAdapter)firstSelectedObj).getDesignElementHandle();
        }
        if (element != null) {
            this.buildShowMenu(menu, element, firstId);
            Object action = new AddRelativeTimePeriodAction(element);
            menu.insertBefore(firstId, (IAction)action);
            action = new AddComputedMeasureAction(element);
            menu.insertBefore(firstId, (IAction)action);
            action = new AddMeasureViewHandleAction(element);
            menu.insertBefore(firstId, (IAction)action);
            action = new DeleteMeasureHandleAction(element);
            menu.insertBefore(firstId, (IAction)action);
        }
    }

    protected void buildShowMenu(IMenuManager menu, DesignElementHandle element, String firstId) {
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(element);
        MeasureViewHandle measureViewHandle = CrosstabAdaptUtil.getMeasureViewHandle(extendedHandle);
        if (measureViewHandle == null || measureViewHandle instanceof ComputedMeasureViewHandle || measureViewHandle.getCubeMeasure() != null && measureViewHandle.getCubeMeasure().isCalculated()) {
            return;
        }
        AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(measureViewHandle.getCrosstab());
        IAggregationCellViewProvider[] providers = providerWrapper.getAllProviders();
        int count = 1;
        int i = 0;
        while (i < providers.length) {
            IAggregationCellViewProvider provider = providers[i];
            if (provider != null) {
                ShowAsViewMenuAction showAsViewAction = new ShowAsViewMenuAction(element, provider.getViewName(), count);
                ++count;
                menu.insertBefore(firstId, (IAction)showAsViewAction);
            }
            ++i;
        }
        menu.insertBefore(firstId, (IContributionItem)new Separator());
    }

    private void createLevelMenu(IMenuManager menu, Object firstSelectedObj, IContributionItem beforeThis) {
        DesignElementHandle element = null;
        if (firstSelectedObj instanceof DesignElementHandle) {
            element = (DesignElementHandle)firstSelectedObj;
        } else if (firstSelectedObj instanceof CrosstabCellAdapter) {
            element = ((CrosstabCellAdapter)firstSelectedObj).getDesignElementHandle();
        }
        String firstId = beforeThis.getId();
        if (element != null) {
            AbstractCrosstabAction action = new AddLevelHandleAction(element);
            menu.insertBefore(firstId, (IAction)action);
            action = new AddSubTotalAction(element);
            menu.insertBefore(firstId, (IAction)action);
            action = new DeleteDimensionViewHandleAction(element);
            menu.insertBefore(firstId, (IAction)action);
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof CrosstabCellAdapter && ((CrosstabCellAdapter)adaptableObject).getCrosstabCellHandle() != null && adapterType == IMenuListener.class) {
            final String position = ((CrosstabCellAdapter)adaptableObject).getPositionType();
            final CrosstabCellAdapter firstSelectedElement = (CrosstabCellAdapter)adaptableObject;
            return new ISchematicMenuListener(){
                private ActionRegistry actionRegistry;

                public void menuAboutToShow(IMenuManager manager) {
                    IContributionItem[] items = manager.getItems();
                    IContributionItem firstMemuItem = items[0];
                    if ("first_level_handle".equals(position)) {
                        CrosstabCellMenuAdapterFactory.this.createLevelMenu(manager, firstSelectedElement, firstMemuItem);
                        manager.insertBefore(firstMemuItem.getId(), (IContributionItem)new Separator());
                    } else if ("cell_measure".equals(position)) {
                        CrosstabCellMenuAdapterFactory.this.createMeasureMenu(manager, firstSelectedElement, firstMemuItem);
                        manager.insertBefore(firstMemuItem.getId(), (IContributionItem)new Separator());
                    } else if ("crosstab_header".equals(position)) {
                        AbstractCrosstabAction action = new SplitCrosstabHeadCellAction(firstSelectedElement.getCrosstabCellHandle().getModelHandle());
                        manager.insertBefore(firstMemuItem.getId(), (IAction)action);
                        action = new MergeCrosstabHeaderCellAction(firstSelectedElement.getCrosstabCellHandle().getModelHandle());
                        manager.insertBefore(firstMemuItem.getId(), (IAction)action);
                        manager.insertBefore(firstMemuItem.getId(), (IContributionItem)new Separator());
                        manager.insertBefore(firstMemuItem.getId(), (IContributionItem)new Separator());
                    }
                    MenuManager subMenu = new MenuManager(Messages.getString((String)"SchematicContextMenuProvider.Menu.insertElement"));
                    IAction action = this.getAction("Insert Label");
                    action.setText(GeneralInsertMenuAction.INSERT_LABEL_DISPLAY_TEXT);
                    subMenu.add(action);
                    action = this.getAction("Insert Text");
                    action.setText(GeneralInsertMenuAction.INSERT_TEXT_DISPLAY_TEXT);
                    subMenu.add(action);
                    action = this.getAction("Insert Dynamic Text");
                    action.setText(GeneralInsertMenuAction.INSERT_DYNAMIC_TEXT_DISPLAY_TEXT);
                    subMenu.add(action);
                    action = this.getAction("Insert Data");
                    action.setText(GeneralInsertMenuAction.INSERT_DATA_DISPLAY_TEXT);
                    subMenu.add(action);
                    action = this.getAction("Insert Image");
                    action.setText(GeneralInsertMenuAction.INSERT_IMAGE_DISPLAY_TEXT);
                    subMenu.add(action);
                    action = this.getAction("Insert Grid");
                    action.setText(GeneralInsertMenuAction.INSERT_GRID_DISPLAY_TEXT);
                    subMenu.add(action);
                    action = this.getAction("Insert List");
                    action.setText(GeneralInsertMenuAction.INSERT_LIST_DISPLAY_TEXT);
                    subMenu.add(action);
                    action = this.getAction("Insert Table");
                    action.setText(GeneralInsertMenuAction.INSERT_TABLE_DISPLAY_TEXT);
                    subMenu.add(action);
                    CategorizedElementSorter elementSorter = new CategorizedElementSorter();
                    List points = ExtensionPointManager.getInstance().getExtendedElementPoints();
                    for (ExtendedElementUIPoint point : points) {
                        IElementDefn extension = DEUtil.getMetaDataDictionary().getExtension(point.getExtensionName());
                        action = this.getAction(point.getExtensionName());
                        if (action == null) continue;
                        String menuLabel = (String)point.getAttribute("menuLabel");
                        action.setText(menuLabel == null ? extension.getDisplayName() : menuLabel);
                        String category = (String)point.getAttribute("category");
                        elementSorter.addElement(category, (Object)action);
                    }
                    PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
                    int i = 0;
                    while (i < entries.length) {
                        action = this.getAction(entries[i].getItemName());
                        if (action != null) {
                            action.setText(entries[i].getMenuLabel());
                            String category = entries[i].getCategory();
                            elementSorter.addElement(category, (Object)action);
                        }
                        ++i;
                    }
                    List actions = elementSorter.getSortedElements();
                    Collections.sort(actions, new Comparator<IAction>(){

                        @Override
                        public int compare(IAction o1, IAction o2) {
                            return Collator.getInstance().compare(o1.getText(), o2.getText());
                        }
                    });
                    Iterator itr = actions.iterator();
                    while (itr.hasNext()) {
                        subMenu.add((IAction)itr.next());
                    }
                    subMenu.add((IContributionItem)new Separator());
                    action = this.getAction("InsertAggregationAction");
                    action.setText(InsertAggregationAction.TEXT);
                    subMenu.add(action);
                    action = this.getAction("InsertRelativeTimePeriodAction");
                    action.setText(InsertRelativeTimePeriodAction.TEXT);
                    subMenu.add(action);
                    manager.add((IAction)new CopyCrosstabCellContentsAction(firstSelectedElement.getCrosstabCellHandle()));
                    manager.add((IContributionItem)subMenu);
                }

                public void setActionRegistry(ActionRegistry actionRegistry) {
                    this.actionRegistry = actionRegistry;
                }

                protected IAction getAction(String actionID) {
                    IAction action = this.getActionRegistry().getAction((Object)actionID);
                    if (action instanceof UpdateAction) {
                        ((UpdateAction)action).update();
                    }
                    return action;
                }

                private ActionRegistry getActionRegistry() {
                    if (this.actionRegistry == null) {
                        this.actionRegistry = new ActionRegistry();
                    }
                    return this.actionRegistry;
                }
            };
        }
        return null;
    }

    public Class[] getAdapterList() {
        return null;
    }
}

